/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.engine.uniform;

import dev.djefrey.colorwheel.engine.uniform.UniformWriter;
import dev.engine_room.flywheel.api.backend.RenderContext;
import dev.engine_room.flywheel.backend.FlwBackendXplat;
import dev.engine_room.flywheel.backend.engine.uniform.UniformBuffer;
import dev.engine_room.flywheel.backend.mixin.AbstractClientPlayerAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.util.FastColor;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import org.jetbrains.annotations.Nullable;

public final class ClrwlPlayerUniforms
extends UniformWriter {
    private static final int SIZE = 76;
    static final UniformBuffer BUFFER = new UniformBuffer(2, 76);

    private ClrwlPlayerUniforms() {
    }

    public static void update(RenderContext context) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            BUFFER.clear();
            return;
        }
        long ptr = BUFFER.ptr();
        PlayerInfo info = ((AbstractClientPlayerAccessor)player).flywheel$getPlayerInfo();
        Vec3 eyePos = player.m_20299_(context.partialTick());
        ptr = ClrwlPlayerUniforms.writeVec3(ptr, (float)eyePos.f_82479_, (float)eyePos.f_82480_, (float)eyePos.f_82481_);
        ptr = ClrwlPlayerUniforms.writeTeamColor(ptr, info == null ? null : info.m_105340_());
        ptr = ClrwlPlayerUniforms.writeEyeBrightness(ptr, player);
        ptr = ClrwlPlayerUniforms.writeHeldLight(ptr, player);
        ptr = ClrwlPlayerUniforms.writeEyeIn(ptr, player);
        ptr = ClrwlPlayerUniforms.writeInt(ptr, player.m_6047_() ? 1 : 0);
        ptr = ClrwlPlayerUniforms.writeInt(ptr, player.m_5803_() ? 1 : 0);
        ptr = ClrwlPlayerUniforms.writeInt(ptr, player.m_6069_() ? 1 : 0);
        ptr = ClrwlPlayerUniforms.writeInt(ptr, player.m_21255_() ? 1 : 0);
        ptr = ClrwlPlayerUniforms.writeInt(ptr, player.m_6144_() ? 1 : 0);
        ptr = ClrwlPlayerUniforms.writeInt(ptr, info == null ? 0 : info.m_105325_().m_46392_());
        BUFFER.markDirty();
    }

    private static long writeTeamColor(long ptr, @Nullable PlayerTeam team) {
        if (team != null) {
            Integer color = team.m_7414_().m_126665_();
            if (color != null) {
                int red = FastColor.ARGB32.m_13665_((int)color);
                int green = FastColor.ARGB32.m_13667_((int)color);
                int blue = FastColor.ARGB32.m_13669_((int)color);
                return ClrwlPlayerUniforms.writeVec4(ptr, (float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, 1.0f);
            }
            return ClrwlPlayerUniforms.writeVec4(ptr, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        return ClrwlPlayerUniforms.writeVec4(ptr, 1.0f, 1.0f, 1.0f, 0.0f);
    }

    private static long writeEyeBrightness(long ptr, LocalPlayer player) {
        ClientLevel level = player.f_108545_;
        int blockBrightness = level.m_45517_(LightLayer.BLOCK, player.m_20183_());
        int skyBrightness = level.m_45517_(LightLayer.SKY, player.m_20183_());
        int maxBrightness = level.m_7469_();
        return ClrwlPlayerUniforms.writeVec2(ptr, (float)blockBrightness / (float)maxBrightness, (float)skyBrightness / (float)maxBrightness);
    }

    private static long writeHeldLight(long ptr, LocalPlayer player) {
        int heldLight = 0;
        for (InteractionHand hand : InteractionHand.values()) {
            BlockItem blockItem;
            Block block;
            int blockLight;
            Item handItem = player.m_21120_(hand).m_41720_();
            if (!(handItem instanceof BlockItem) || heldLight >= (blockLight = FlwBackendXplat.INSTANCE.getLightEmission((block = (blockItem = (BlockItem)handItem).m_40614_()).m_49966_(), (BlockGetter)player.f_108545_, player.m_20183_()))) continue;
            heldLight = blockLight;
        }
        return ClrwlPlayerUniforms.writeFloat(ptr, (float)heldLight / 15.0f);
    }

    private static long writeEyeIn(long ptr, LocalPlayer player) {
        ClientLevel level = player.f_108545_;
        Vec3 eyePos = player.m_146892_();
        BlockPos blockPos = BlockPos.m_274446_((Position)eyePos);
        return ClrwlPlayerUniforms.writeInFluidAndBlock(ptr, (Level)level, blockPos, eyePos);
    }
}

