/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel;

import dev.djefrey.colorwheel.ClrwlConfig;
import dev.djefrey.colorwheel.ClrwlXplat;
import dev.djefrey.colorwheel.accessors.ProgramSetAccessor;
import dev.djefrey.colorwheel.engine.ClrwlEngine;
import dev.djefrey.colorwheel.util.AccumulateTimer;
import dev.engine_room.flywheel.api.backend.Backend;
import dev.engine_room.flywheel.backend.gl.GlCompat;
import dev.engine_room.flywheel.lib.backend.SimpleBackend;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Optional;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.pipeline.IrisRenderingPipeline;
import net.irisshaders.iris.pipeline.WorldRenderingPipeline;
import net.irisshaders.iris.shaderpack.ShaderPack;
import net.irisshaders.iris.shaderpack.programs.ProgramSet;
import net.minecraft.class_124;
import net.minecraft.class_1936;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_746;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Colorwheel {
    public static final String MOD_ID = "colorwheel";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"colorwheel");
    public static final Backend IRIS_INSTANCING = SimpleBackend.builder().engineFactory(level -> new ClrwlEngine((class_1936)level, 256)).priority(500).supported(() -> GlCompat.SUPPORTS_INSTANCING && Colorwheel.isUsingCompatibleShaderPack()).register(Colorwheel.rl("instancing"));
    public static ClrwlConfig CONFIG = null;
    public static String FORMATTED_VERSION = ClrwlXplat.INSTANCE.getFormattedVersion();
    private static final AccumulateTimer ACCUMULATE_INCOMPATIBLE = new AccumulateTimer(0.5f);

    public static void init() {
    }

    public static class_2960 rl(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    public static boolean isUsingCompatibleShaderPack() {
        Optional pack = Iris.getCurrentPack();
        if (pack.isEmpty()) {
            return false;
        }
        if (!CONFIG.isFallbackModeEnabled()) {
            String name = Iris.getCurrentPackName();
            ProgramSet programSet = ((ShaderPack)pack.get()).getProgramSet(Iris.getCurrentDimension());
            boolean isFallback = ((ProgramSetAccessor)programSet).colorwheel$isFallbackMode();
            if (isFallback) {
                if (CONFIG.shouldAlertIncompatiblePack()) {
                    ACCUMULATE_INCOMPATIBLE.request(() -> {
                        Optional<String> patch = Colorwheel.findPatchedShaderpack(name);
                        Colorwheel.sendEmptyMessage();
                        class_5250 packComp = class_2561.method_43470((String)name).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(true)));
                        Colorwheel.sendErrorMessage((class_2561)class_2561.method_43469((String)"colorwheel.alert.incompatible_pack", (Object[])new Object[]{packComp}), true);
                        if (patch.isPresent()) {
                            class_5250 patchComp = class_2561.method_43470((String)patch.get()).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(true)));
                            Colorwheel.sendErrorMessage((class_2561)class_2561.method_43469((String)"colorwheel.alert.incompatible_pack.patch_available", (Object[])new Object[]{patchComp}), false);
                        } else {
                            class_5250 fallbackComp = class_2561.method_43471((String)"colorwheel.fallback_mode").method_27696(class_2583.field_24360.method_30938(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11745, "/colorwheel enableFallbackMode on")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"colorwheel.fallback_mode.enable"))));
                            Colorwheel.sendErrorMessage((class_2561)class_2561.method_43469((String)"colorwheel.alert.incompatible_pack.ask_fallback_mode", (Object[])new Object[]{fallbackComp}), false);
                        }
                        class_5250 disableComp = class_2561.method_43471((String)"colorwheel.alert.ask_disable").method_27696(class_2583.field_24360.method_30938(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11745, "/colorwheel alertIncompatiblePack off")).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"colorwheel.alert.incompatible_pack.disable"))));
                        Colorwheel.sendEmptyMessage();
                        Colorwheel.sendErrorMessage((class_2561)disableComp, false);
                        Colorwheel.sendEmptyMessage();
                    });
                }
                return false;
            }
        }
        WorldRenderingPipeline worldPipeline = Iris.getPipelineManager().getPipelineNullable();
        return worldPipeline instanceof IrisRenderingPipeline;
    }

    public static Optional<String> findPatchedShaderpack(String shaderpack) {
        Path shaderpackFolder = Iris.getShaderpacksDirectory();
        try {
            Optional maybePatch;
            Class<?> clazz = Class.forName("dev.djefrey.colorwheel_patcher.ClrwlPatcher");
            Method method = clazz.getMethod("findPatchedShaderpackInFolder", String.class, Path.class);
            Object res = method.invoke(null, shaderpack, shaderpackFolder);
            if (res instanceof Optional && (maybePatch = (Optional)res).isPresent() && maybePatch.get() instanceof String) {
                return Optional.of((String)maybePatch.get());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.empty();
    }

    public static void sendWarnMessage(class_5250 component, boolean prefix) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        class_5250 comp = prefix ? class_2561.method_43470((String)"[Colorwheel] ") : class_2561.method_43473();
        comp.method_10852((class_2561)component);
        comp.method_10862(class_2583.field_24360.method_27703(class_5251.method_27718((class_124)class_124.field_1054)));
        player.method_43496((class_2561)comp);
    }

    public static void sendErrorMessage(class_2561 component, boolean prefix) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        class_5250 comp = prefix ? class_2561.method_43470((String)"[Colorwheel] ") : class_2561.method_43473();
        comp.method_10852(component);
        comp.method_10862(class_2583.field_24360.method_27703(class_5251.method_27718((class_124)class_124.field_1061)));
        player.method_43496((class_2561)comp);
    }

    public static void sendEmptyMessage() {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        player.method_43496((class_2561)class_2561.method_43473());
    }
}

