/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.compile;

import dev.djefrey.colorwheel.Colorwheel;
import dev.djefrey.colorwheel.ShaderType;
import dev.djefrey.colorwheel.compile.ClrwlCompilation;
import dev.djefrey.colorwheel.compile.ClrwlPipeline;
import dev.djefrey.colorwheel.compile.ClrwlPipelineCompiler;
import dev.djefrey.colorwheel.compile.ClrwlPrograms;
import dev.djefrey.colorwheel.compile.ClrwlShaderKey;
import dev.djefrey.colorwheel.compile.FallbackCutoutComponent;
import dev.djefrey.colorwheel.compile.IrisShaderComponent;
import dev.djefrey.colorwheel.compile.oit.ClrwlOitCompositePipeline;
import dev.djefrey.colorwheel.compile.oit.OitCoefficientsOutputComponent;
import dev.djefrey.colorwheel.compile.oit.OitCoefficientsSamplersComponent;
import dev.djefrey.colorwheel.compile.oit.OitCollectCoeffsComponent;
import dev.djefrey.colorwheel.compile.oit.OitCompositeComponent;
import dev.djefrey.colorwheel.compile.oit.OitEvaluateComponent;
import dev.djefrey.colorwheel.engine.ClrwlOitAccumulateOverride;
import dev.djefrey.colorwheel.engine.ClrwlVertex;
import dev.djefrey.colorwheel.shaderpack.ClrwlProgramGroup;
import dev.djefrey.colorwheel.shaderpack.ClrwlProgramId;
import dev.djefrey.colorwheel.util.Utils;
import dev.engine_room.flywheel.api.material.CutoutShader;
import dev.engine_room.flywheel.backend.BackendConfig;
import dev.engine_room.flywheel.backend.compile.ContextShader;
import dev.engine_room.flywheel.backend.compile.LightSmoothness;
import dev.engine_room.flywheel.backend.compile.component.BufferTextureInstanceComponent;
import dev.engine_room.flywheel.backend.compile.component.InstanceStructComponent;
import dev.engine_room.flywheel.backend.gl.GlCompat;
import dev.engine_room.flywheel.backend.glsl.SourceComponent;
import dev.engine_room.flywheel.lib.material.CutoutShaders;
import dev.engine_room.flywheel.lib.util.ResourceUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2960;

public class ClrwlPipelines {
    public static final class_2960 API_IMPL_VERT = Colorwheel.rl("internal/api_impl.vert");
    public static final class_2960 API_IMPL_GEOM = Colorwheel.rl("internal/api_impl_geom.glsl");
    public static final class_2960 API_IMPL_FRAG = Colorwheel.rl("internal/api_impl.frag");
    public static final class_2960 FALLBACK_API_IMPL_VERT = Colorwheel.rl("internal/fallback/api_impl.vert");
    public static final class_2960 FALLBACK_API_IMPL_GEOM = Colorwheel.rl("internal/fallback/api_impl_geom.glsl");
    public static final class_2960 FALLBACK_API_IMPL_FRAG = Colorwheel.rl("internal/fallback/api_impl.frag");
    public static final class_2960 IRIS_COMPAT_VERT = Colorwheel.rl("internal/instancing/iris_compat.vert");
    public static final class_2960 IRIS_COMPAT_GEOM = Colorwheel.rl("internal/instancing/iris_compat_geom.glsl");
    public static final class_2960 IRIS_COMPAT_FRAG = Colorwheel.rl("internal/instancing/iris_compat.frag");
    public static final class_2960 FALLBACK_IRIS_COMPAT_VERT = Colorwheel.rl("internal/fallback/instancing/iris_compat.vert");
    public static final class_2960 FALLBACK_IRIS_COMPAT_GEOM = Colorwheel.rl("internal/fallback/instancing/iris_compat_geom.glsl");
    public static final class_2960 FALLBACK_IRIS_COMPAT_FRAG = Colorwheel.rl("internal/fallback/instancing/iris_compat.frag");
    public static final class_2960 MAIN_VERT = Colorwheel.rl("internal/instancing/main.vert");
    public static final class_2960 MAIN_GEOM = Colorwheel.rl("internal/instancing/main_geom.glsl");
    public static final class_2960 MAIN_FRAG = Colorwheel.rl("internal/instancing/main.frag");
    public static final class_2960 FALLBACK_MAIN_VERT = Colorwheel.rl("internal/fallback/instancing/main.vert");
    public static final class_2960 FALLBACK_MAIN_GEOM = Colorwheel.rl("internal/fallback/instancing/main_geom.glsl");
    public static final class_2960 FALLBACK_MAIN_FRAG = Colorwheel.rl("internal/fallback/instancing/main.frag");
    public static final class_2960 OIT_DEPTH_RANGE_FRAG = Colorwheel.rl("internal/oit/depth_range.frag");
    public static final class_2960 COMPONENTS_HEADER_FRAG = ResourceUtil.rl((String)"internal/components_header.frag");
    private static final class_2960 FULLSCREEN = ResourceUtil.rl((String)"internal/fullscreen.vert");
    public static ClrwlPipeline INSTANCING = ClrwlPipeline.builder().id("instancing").minVersion(GlCompat.MAX_GLSL_VERSION).onSetup(b -> {
        for (String ext : ClrwlPrograms.EXTENSIONS) {
            b.requireExtension(ext);
        }
    }).vertex(ClrwlPipeline.vertexStage().define("IS_COLORWHEEL").onCompile((k, c) -> {
        if (k.isDebugEnabled()) {
            c.define("_FLW_DEBUG");
        }
    }).onCompile(ClrwlPipelines::setIrisDefines).onCompile((k, c) -> {
        List<String> exts = c.getIrisSources().extensions().get((Object)ShaderType.VERTEX);
        for (String ext : exts) {
            c.enableExtension(ext);
        }
    }).onCompile(($, c) -> c.define("fma(a, b, c)", "((a) * (b) + (c))")).onCompile((k, c) -> ClrwlPipelines.setContextDefine(k.context(), c)).onCompile((k, c) -> {
        if (k.oit() != ClrwlPipelineCompiler.OitMode.OFF) {
            c.define("CLRWL_OIT");
            c.define(k.oit().define);
        }
    }).onCompile(ClrwlPipelines::setLightSmoothness).withResource(API_IMPL_VERT).withComponent(k -> new InstanceStructComponent(k.instanceType())).withLoader((k, sources) -> sources.get(k.instanceType().vertexShader())).withLoader((k, sources) -> sources.get(k.material().vertexSource())).withResource(ClrwlVertex.LAYOUT_SHADER).withResource(IRIS_COMPAT_VERT).withComponent(k -> new BufferTextureInstanceComponent(k.instanceType())).with(ClrwlPipelines::getIrisShaderVertexSource).withResource(MAIN_VERT).build()).geometry(ClrwlPipeline.geometryStage().define("IS_COLORWHEEL").onCompile((k, c) -> {
        if (k.isDebugEnabled()) {
            c.define("_FLW_DEBUG");
        }
    }).onCompile(ClrwlPipelines::setIrisDefines).onCompile((k, c) -> {
        List<String> exts = c.getIrisSources().extensions().get((Object)ShaderType.GEOMETRY);
        for (String ext : exts) {
            c.enableExtension(ext);
        }
    }).withResource(API_IMPL_GEOM).withResource(IRIS_COMPAT_GEOM).with(ClrwlPipelines::getIrisShaderGeometrySource).withResource(MAIN_GEOM).build()).fragment(ClrwlPipeline.fragmentStage().define("IS_COLORWHEEL").onCompile((k, c) -> {
        if (k.isDebugEnabled()) {
            c.define("_FLW_DEBUG");
        }
    }).onCompile(ClrwlPipelines::setIrisDefines).enableExtension("GL_ARB_conservative_depth").onCompile((k, c) -> {
        List<String> exts = c.getIrisSources().extensions().get((Object)ShaderType.FRAGMENT);
        for (String ext : exts) {
            c.enableExtension(ext);
        }
    }).onCompile(($, c) -> c.define("fma(a, b, c)", "((a) * (b) + (c))")).onCompile((k, c) -> ClrwlPipelines.setContextDefine(k.context(), c)).onCompile((k, c) -> ClrwlPipelines.setCutoutDefine(k.cutout(), c)).onCompile((k, c) -> {
        if (k.oit() != ClrwlPipelineCompiler.OitMode.OFF) {
            c.define("CLRWL_OIT");
            c.define(k.oit().define);
        }
    }).onCompile(ClrwlPipelines::setLightSmoothness).withResource(COMPONENTS_HEADER_FRAG).withResource(API_IMPL_FRAG).withLoader((k, sources) -> sources.get(k.material().fragmentSource())).withLoader((k, sources) -> sources.get(k.fog().source())).withLoader((k, sources) -> sources.get(k.light().source())).withLoader((k, sources) -> k.cutout() == CutoutShaders.OFF ? sources.get(CutoutShaders.OFF.source()) : sources.get(k.cutout().source())).withLoader(($, sources) -> sources.get(IRIS_COMPAT_FRAG)).with(ClrwlPipelines::getOitInouts).with(ClrwlPipelines::getIrisShaderFragmentSource).with(ClrwlPipelines::getPostShaderFragmentSource).withResource(MAIN_FRAG).build()).build();
    public static ClrwlPipeline FALLBACK_INSTANCING = ClrwlPipeline.builder().id("fallback_instancing").minVersion(GlCompat.MAX_GLSL_VERSION).onSetup(b -> {
        for (String ext : ClrwlPrograms.EXTENSIONS) {
            b.requireExtension(ext);
        }
    }).vertex(ClrwlPipeline.vertexStage().define("IS_COLORWHEEL").onCompile((k, c) -> {
        if (k.isDebugEnabled()) {
            c.define("_FLW_DEBUG");
        }
    }).onCompile(ClrwlPipelines::setIrisDefines).onCompile((k, c) -> {
        List<String> exts = c.getIrisSources().extensions().get((Object)ShaderType.VERTEX);
        for (String ext : exts) {
            c.enableExtension(ext);
        }
    }).onCompile(($, c) -> c.define("fma(a, b, c)", "((a) * (b) + (c))")).onCompile((k, c) -> ClrwlPipelines.setContextDefine(k.context(), c)).onCompile(ClrwlPipelines::setLightSmoothness).withResource(FALLBACK_API_IMPL_VERT).withComponent(k -> new InstanceStructComponent(k.instanceType())).withLoader((k, sources) -> sources.get(k.instanceType().vertexShader())).withLoader((k, sources) -> sources.get(k.material().vertexSource())).withResource(ClrwlVertex.LAYOUT_SHADER).withResource(FALLBACK_IRIS_COMPAT_VERT).withComponent(k -> new BufferTextureInstanceComponent(k.instanceType())).with(ClrwlPipelines::getIrisShaderVertexSource).withResource(FALLBACK_MAIN_VERT).build()).geometry(ClrwlPipeline.geometryStage().define("IS_COLORWHEEL").onCompile((k, c) -> {
        if (k.isDebugEnabled()) {
            c.define("_FLW_DEBUG");
        }
    }).onCompile(ClrwlPipelines::setIrisDefines).onCompile((k, c) -> {
        List<String> exts = c.getIrisSources().extensions().get((Object)ShaderType.GEOMETRY);
        for (String ext : exts) {
            c.enableExtension(ext);
        }
    }).withResource(FALLBACK_API_IMPL_GEOM).withResource(FALLBACK_IRIS_COMPAT_GEOM).with(ClrwlPipelines::getIrisShaderGeometrySource).withResource(FALLBACK_MAIN_GEOM).build()).fragment(ClrwlPipeline.fragmentStage().define("IS_COLORWHEEL").onCompile((k, c) -> {
        if (k.isDebugEnabled()) {
            c.define("_FLW_DEBUG");
        }
    }).onCompile(ClrwlPipelines::setIrisDefines).enableExtension("GL_ARB_conservative_depth").onCompile((k, c) -> {
        List<String> exts = c.getIrisSources().extensions().get((Object)ShaderType.FRAGMENT);
        for (String ext : exts) {
            c.enableExtension(ext);
        }
    }).onCompile(($, c) -> c.define("fma(a, b, c)", "((a) * (b) + (c))")).onCompile((k, c) -> ClrwlPipelines.setContextDefine(k.context(), c)).onCompile((k, c) -> ClrwlPipelines.setCutoutDefine(k.cutout(), c)).onCompile((k, c) -> ClrwlPipelines.setSeparateAoDefine(c)).onCompile(ClrwlPipelines::setLightSmoothness).withResource(COMPONENTS_HEADER_FRAG).withResource(FALLBACK_API_IMPL_FRAG).withLoader((k, sources) -> k.cutout() == CutoutShaders.OFF ? sources.get(CutoutShaders.OFF.source()) : sources.get(k.cutout().source())).withLoader(($, sources) -> sources.get(FALLBACK_IRIS_COMPAT_FRAG)).with(ClrwlPipelines::getOitInouts).with(ClrwlPipelines::getIrisShaderFragmentSource).with(ClrwlPipelines::getFallbackCutoutFragmentSource).withResource(FALLBACK_MAIN_FRAG).build()).build();
    public static ClrwlOitCompositePipeline OIT_COMPOSITE = ClrwlOitCompositePipeline.builder().id("oit_composite").minVersion(GlCompat.MAX_GLSL_VERSION).vertex(ClrwlOitCompositePipeline.vertexStage().withResource(FULLSCREEN).build()).fragment(ClrwlOitCompositePipeline.fragmentStage().onCompile(($, c) -> c.define("fma(a, b, c)", "((a) * (b) + (c))")).with((k, c) -> new OitCompositeComponent(c.getLoader(), k.drawBuffers(), k.ranks(), k.overrides())).build()).build();

    private static void setIrisDefines(ClrwlShaderKey k, ClrwlCompilation c) {
        if (c.getProgramSet().getPackDirectives().isOldLighting()) {
            c.define("CLRWL_OLD_LIGHTING");
        }
    }

    private static void setLightSmoothness(ClrwlShaderKey k, ClrwlCompilation c) {
        LightSmoothness smoothness = BackendConfig.INSTANCE.lightSmoothness();
        switch (smoothness) {
            case FLAT: {
                c.define("_FLW_LIGHT_SMOOTHNESS", "0");
                break;
            }
            case TRI_LINEAR: {
                c.define("_FLW_LIGHT_SMOOTHNESS", "1");
                break;
            }
            case SMOOTH: {
                c.define("_FLW_LIGHT_SMOOTHNESS", "2");
                break;
            }
            case SMOOTH_INNER_FACE_CORRECTED: {
                c.define("_FLW_LIGHT_SMOOTHNESS", "2");
                c.define("_FLW_INNER_FACE_CORRECTION");
            }
        }
    }

    private static void setContextDefine(ContextShader ctx, ClrwlCompilation c) {
        switch (ctx) {
            case DEFAULT: {
                break;
            }
            case CRUMBLING: {
                c.define("_FLW_CRUMBLING");
                break;
            }
            case EMBEDDED: {
                c.define("FLW_EMBEDDED");
            }
        }
    }

    private static void setCutoutDefine(CutoutShader cutout, ClrwlCompilation c) {
        if (cutout != CutoutShaders.OFF) {
            c.define("_FLW_USE_DISCARD");
        }
    }

    private static SourceComponent getIrisShaderVertexSource(ClrwlShaderKey k, ClrwlCompilation c) {
        ClrwlProgramId programId = ClrwlProgramId.fromTransparency(k.transparency(), k.isShadow());
        String name = programId.programName() + ".vsh";
        String patched = c.getIrisSources().vertex();
        return new IrisShaderComponent(name, patched);
    }

    private static SourceComponent getIrisShaderGeometrySource(ClrwlShaderKey k, ClrwlCompilation c) {
        ClrwlProgramId programId = ClrwlProgramId.fromTransparency(k.transparency(), k.isShadow());
        String name = programId.programName() + ".gsh";
        String patched = c.getIrisSources().geometry().orElseThrow();
        return new IrisShaderComponent(name, patched);
    }

    private static SourceComponent getIrisShaderFragmentSource(ClrwlShaderKey k, ClrwlCompilation c) {
        ClrwlProgramId programId = ClrwlProgramId.fromTransparency(k.transparency(), k.isShadow());
        String name = programId.programName() + ".fsh";
        String patched = c.getIrisSources().fragment().code();
        return new IrisShaderComponent(name, patched);
    }

    private static SourceComponent getOitInouts(ClrwlShaderKey k, ClrwlCompilation c) {
        ClrwlProgramGroup programGroup;
        ClrwlProgramGroup clrwlProgramGroup = programGroup = k.isShadow() ? ClrwlProgramGroup.SHADOW : ClrwlProgramGroup.GBUFFERS;
        if (k.oit() == ClrwlPipelineCompiler.OitMode.GENERATE_COEFFICIENTS) {
            int[] ranks = c.getProperties().getOitCoeffRanks(programGroup);
            return new OitCoefficientsOutputComponent(ranks);
        }
        if (k.oit() == ClrwlPipelineCompiler.OitMode.EVALUATE) {
            int[] ranks = c.getProperties().getOitCoeffRanks(programGroup);
            return new OitCoefficientsSamplersComponent(ranks.length);
        }
        return null;
    }

    private static SourceComponent getPostShaderFragmentSource(ClrwlShaderKey k, ClrwlCompilation c) {
        ClrwlProgramGroup programGroup = k.isShadow() ? ClrwlProgramGroup.SHADOW : ClrwlProgramGroup.GBUFFERS;
        switch (k.oit()) {
            case DEPTH_RANGE: {
                c.define("CLRWL_POST_SHADER");
                return c.getLoader().get(OIT_DEPTH_RANGE_FRAG);
            }
            case GENERATE_COEFFICIENTS: {
                int[] drawBuffers = c.getIrisSources().drawBuffers();
                int[] ranks = c.getProperties().getOitCoeffRanks(programGroup);
                List<ClrwlOitAccumulateOverride> overrides = c.getProperties().getOitAccumulateOverrides(programGroup);
                HashMap<Integer, Integer> coeffFrag = new HashMap<Integer, Integer>();
                for (int i = 0; i < drawBuffers.length; ++i) {
                    int buffer = drawBuffers[i];
                    Optional maybeCoeffId = Utils.findFirst(overrides, e -> e.drawBuffer() == buffer).flatMap(ClrwlOitAccumulateOverride::coefficientId);
                    if (!maybeCoeffId.isPresent()) continue;
                    coeffFrag.putIfAbsent((Integer)maybeCoeffId.get(), i);
                }
                c.define("CLRWL_POST_SHADER");
                return new OitCollectCoeffsComponent(ranks, coeffFrag, c.getIrisSources().fragment().outputs());
            }
            case EVALUATE: {
                int[] drawBuffers = c.getIrisSources().drawBuffers();
                int[] ranks = c.getProperties().getOitCoeffRanks(programGroup);
                List<ClrwlOitAccumulateOverride> overrides = c.getProperties().getOitAccumulateOverrides(programGroup);
                Map<Integer, String> outputs = c.getIrisSources().fragment().outputs();
                c.define("CLRWL_POST_SHADER");
                return new OitEvaluateComponent(drawBuffers, ranks, overrides, outputs);
            }
        }
        return null;
    }

    private static void setSeparateAoDefine(ClrwlCompilation c) {
        if (c.getProgramSet().getPackDirectives().shouldUseSeparateAo()) {
            c.define("_CLRWL_SEPARATE_AO");
        }
    }

    private static SourceComponent getFallbackCutoutFragmentSource(ClrwlShaderKey k, ClrwlCompilation c) {
        return new FallbackCutoutComponent(c.getIrisSources().fragment().outputs());
    }

    private ClrwlPipelines() {
    }
}

