/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.engine.uniform;

import dev.djefrey.colorwheel.engine.ShadowRenderContext;
import dev.djefrey.colorwheel.engine.uniform.DebugMode;
import dev.djefrey.colorwheel.engine.uniform.UniformWriter;
import dev.engine_room.flywheel.api.backend.RenderContext;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.backend.engine.indirect.DepthPyramid;
import dev.engine_room.flywheel.backend.engine.uniform.UniformBuffer;
import dev.engine_room.flywheel.backend.mixin.LevelRendererAccessor;
import net.minecraft.class_1041;
import net.minecraft.class_156;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import org.joml.Math;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.system.MemoryUtil;

public final class ClrwlShadowFrameUniforms
extends UniformWriter {
    private static final int SIZE = 1168;
    public static final UniformBuffer BUFFER = new UniformBuffer(0, 1168);
    private static final Matrix4f VIEW = new Matrix4f();
    private static final Matrix4f VIEW_INVERSE = new Matrix4f();
    private static final Matrix4f VIEW_PREV = new Matrix4f();
    private static final Matrix4f PROJECTION = new Matrix4f();
    private static final Matrix4f PROJECTION_INVERSE = new Matrix4f();
    private static final Matrix4f PROJECTION_PREV = new Matrix4f();
    private static final Matrix4f VIEW_PROJECTION = new Matrix4f();
    private static final Matrix4f VIEW_PROJECTION_INVERSE = new Matrix4f();
    private static final Matrix4f VIEW_PROJECTION_PREV = new Matrix4f();
    private static final Matrix3f NORMAL = new Matrix3f();
    private static final Vector3f CAMERA_POS = new Vector3f();
    private static final Vector3f CAMERA_POS_PREV = new Vector3f();
    private static final Vector3f CAMERA_LOOK = new Vector3f();
    private static final Vector3f CAMERA_LOOK_PREV = new Vector3f();
    private static final Vector2f CAMERA_ROT = new Vector2f();
    private static final Vector2f CAMERA_ROT_PREV = new Vector2f();
    private static boolean firstWrite = true;
    private static boolean frustumPaused = false;
    private static boolean frustumCapture = false;

    private ClrwlShadowFrameUniforms() {
    }

    public static void captureFrustum() {
        frustumPaused = true;
        frustumCapture = true;
    }

    public static void unpauseFrustum() {
        frustumPaused = false;
    }

    public static void update(ShadowRenderContext context) {
        long ptr = BUFFER.ptr();
        ClrwlShadowFrameUniforms.setPrev();
        class_2382 renderOrigin = VisualizationManager.getOrThrow((class_1936)context.level()).renderOrigin();
        class_4184 camera = context.camera();
        float camX = context.camX() - (float)renderOrigin.method_10263();
        float camY = context.camY() - (float)renderOrigin.method_10264();
        float camZ = context.camZ() - (float)renderOrigin.method_10260();
        VIEW.set(context.modelView());
        VIEW.translate(-camX, -camY, -camZ);
        PROJECTION.set(context.projection());
        VIEW_PROJECTION.set(context.viewProjection());
        VIEW_PROJECTION.translate(-camX, -camY, -camZ);
        CAMERA_POS.set(camX, camY, camZ);
        CAMERA_LOOK.set((Vector3fc)camera.method_19335());
        CAMERA_ROT.set(camera.method_19329(), camera.method_19330());
        Matrix4f normal = new Matrix4f(context.modelView()).translate(-camX, -camY, -camZ).invert().transpose();
        normal.get3x3(NORMAL);
        if (firstWrite) {
            ClrwlShadowFrameUniforms.setPrev();
        }
        if (firstWrite || !frustumPaused || frustumCapture) {
            ClrwlShadowFrameUniforms.writePackedFrustumPlanes(ptr, VIEW_PROJECTION);
            frustumCapture = false;
        }
        ptr += 96L;
        ptr = ClrwlShadowFrameUniforms.writeCullData(ptr);
        ptr = ClrwlShadowFrameUniforms.writeMatrices(ptr);
        ptr = ClrwlShadowFrameUniforms.writeRenderOrigin(ptr, renderOrigin);
        ptr = ClrwlShadowFrameUniforms.writeCamera(ptr);
        class_1041 window = class_310.method_1551().method_22683();
        ptr = ClrwlShadowFrameUniforms.writeVec2(ptr, window.method_4489(), window.method_4506());
        ptr = ClrwlShadowFrameUniforms.writeFloat(ptr, (float)window.method_4489() / (float)window.method_4506());
        ptr = ClrwlShadowFrameUniforms.writeFloat(ptr, Math.max((float)2.5f, (float)((float)window.method_4489() / 1920.0f * 2.5f)));
        ptr = ClrwlShadowFrameUniforms.writeFloat(ptr, class_310.method_1551().field_1773.method_32796());
        ptr = ClrwlShadowFrameUniforms.writeTime(ptr, context);
        ptr = ClrwlShadowFrameUniforms.writeCameraIn(ptr, camera);
        ptr = ClrwlShadowFrameUniforms.writeInt(ptr, DebugMode.OFF.ordinal());
        ptr = ClrwlShadowFrameUniforms.writeFloat(ptr, 0.07f);
        firstWrite = false;
        BUFFER.markDirty();
    }

    private static long writeRenderOrigin(long ptr, class_2382 renderOrigin) {
        ptr = ClrwlShadowFrameUniforms.writeIVec3(ptr, renderOrigin.method_10263(), renderOrigin.method_10264(), renderOrigin.method_10260());
        return ptr;
    }

    private static void setPrev() {
        VIEW_PREV.set((Matrix4fc)VIEW);
        PROJECTION_PREV.set((Matrix4fc)PROJECTION);
        VIEW_PROJECTION_PREV.set((Matrix4fc)VIEW_PROJECTION);
        CAMERA_POS_PREV.set((Vector3fc)CAMERA_POS);
        CAMERA_LOOK_PREV.set((Vector3fc)CAMERA_LOOK);
        CAMERA_ROT_PREV.set((Vector2fc)CAMERA_ROT);
    }

    private static long writeMatrices(long ptr) {
        ptr = ClrwlShadowFrameUniforms.writeMat4(ptr, VIEW);
        ptr = ClrwlShadowFrameUniforms.writeMat4(ptr, VIEW.invert(VIEW_INVERSE));
        ptr = ClrwlShadowFrameUniforms.writeMat4(ptr, VIEW_PREV);
        ptr = ClrwlShadowFrameUniforms.writeMat4(ptr, PROJECTION);
        ptr = ClrwlShadowFrameUniforms.writeMat4(ptr, PROJECTION.invert(PROJECTION_INVERSE));
        ptr = ClrwlShadowFrameUniforms.writeMat4(ptr, PROJECTION_PREV);
        ptr = ClrwlShadowFrameUniforms.writeMat4(ptr, VIEW_PROJECTION);
        ptr = ClrwlShadowFrameUniforms.writeMat4(ptr, VIEW_PROJECTION.invert(VIEW_PROJECTION_INVERSE));
        ptr = ClrwlShadowFrameUniforms.writeMat4(ptr, VIEW_PROJECTION_PREV);
        ptr = ClrwlShadowFrameUniforms.writeMat4(ptr, VIEW);
        ptr = ClrwlShadowFrameUniforms.writeMat4(ptr, VIEW_INVERSE);
        ptr = ClrwlShadowFrameUniforms.writeMat4(ptr, PROJECTION);
        ptr = ClrwlShadowFrameUniforms.writeMat4(ptr, PROJECTION_INVERSE);
        ptr = ClrwlShadowFrameUniforms.writeMat3(ptr, NORMAL);
        return ptr;
    }

    private static long writeCamera(long ptr) {
        ptr = ClrwlShadowFrameUniforms.writeVec3(ptr, ClrwlShadowFrameUniforms.CAMERA_POS.x, ClrwlShadowFrameUniforms.CAMERA_POS.y, ClrwlShadowFrameUniforms.CAMERA_POS.z);
        ptr = ClrwlShadowFrameUniforms.writeVec3(ptr, ClrwlShadowFrameUniforms.CAMERA_POS_PREV.x, ClrwlShadowFrameUniforms.CAMERA_POS_PREV.y, ClrwlShadowFrameUniforms.CAMERA_POS_PREV.z);
        ptr = ClrwlShadowFrameUniforms.writeVec3(ptr, ClrwlShadowFrameUniforms.CAMERA_LOOK.x, ClrwlShadowFrameUniforms.CAMERA_LOOK.y, ClrwlShadowFrameUniforms.CAMERA_LOOK.z);
        ptr = ClrwlShadowFrameUniforms.writeVec3(ptr, ClrwlShadowFrameUniforms.CAMERA_LOOK_PREV.x, ClrwlShadowFrameUniforms.CAMERA_LOOK_PREV.y, ClrwlShadowFrameUniforms.CAMERA_LOOK_PREV.z);
        ptr = ClrwlShadowFrameUniforms.writeVec2(ptr, ClrwlShadowFrameUniforms.CAMERA_ROT.x, ClrwlShadowFrameUniforms.CAMERA_ROT.y);
        ptr = ClrwlShadowFrameUniforms.writeVec2(ptr, ClrwlShadowFrameUniforms.CAMERA_ROT_PREV.x, ClrwlShadowFrameUniforms.CAMERA_ROT_PREV.y);
        return ptr;
    }

    private static long writeTime(long ptr, RenderContext context) {
        int ticks = ((LevelRendererAccessor)context.renderer()).flywheel$getTicks();
        float partialTick = context.partialTick();
        float renderTicks = (float)ticks + partialTick;
        float renderSeconds = renderTicks / 20.0f;
        float systemSeconds = (float)class_156.method_658() / 1000.0f;
        int systemMillis = (int)(class_156.method_658() % Integer.MAX_VALUE);
        ptr = ClrwlShadowFrameUniforms.writeInt(ptr, ticks);
        ptr = ClrwlShadowFrameUniforms.writeFloat(ptr, partialTick);
        ptr = ClrwlShadowFrameUniforms.writeFloat(ptr, renderTicks);
        ptr = ClrwlShadowFrameUniforms.writeFloat(ptr, renderSeconds);
        ptr = ClrwlShadowFrameUniforms.writeFloat(ptr, systemSeconds);
        ptr = ClrwlShadowFrameUniforms.writeInt(ptr, systemMillis);
        return ptr;
    }

    private static long writeCameraIn(long ptr, class_4184 camera) {
        if (!camera.method_19332()) {
            ptr = ClrwlShadowFrameUniforms.writeInt(ptr, 0);
            ptr = ClrwlShadowFrameUniforms.writeInt(ptr, 0);
            return ptr;
        }
        class_1937 level = camera.method_19331().method_37908();
        class_2338 blockPos = camera.method_19328();
        class_243 cameraPos = camera.method_19326();
        return ClrwlShadowFrameUniforms.writeInFluidAndBlock(ptr, level, blockPos, cameraPos);
    }

    private static long writeCullData(long ptr) {
        class_310 mc = class_310.method_1551();
        class_276 mainRenderTarget = mc.method_1522();
        int pyramidWidth = DepthPyramid.mip0Size((int)mainRenderTarget.field_1482);
        int pyramidHeight = DepthPyramid.mip0Size((int)mainRenderTarget.field_1481);
        int pyramidDepth = DepthPyramid.getImageMipLevels((int)pyramidWidth, (int)pyramidHeight);
        ptr = ClrwlShadowFrameUniforms.writeFloat(ptr, 0.05f);
        ptr = ClrwlShadowFrameUniforms.writeFloat(ptr, mc.field_1773.method_32796());
        ptr = ClrwlShadowFrameUniforms.writeFloat(ptr, PROJECTION.m00());
        ptr = ClrwlShadowFrameUniforms.writeFloat(ptr, PROJECTION.m11());
        ptr = ClrwlShadowFrameUniforms.writeFloat(ptr, pyramidWidth);
        ptr = ClrwlShadowFrameUniforms.writeFloat(ptr, pyramidHeight);
        ptr = ClrwlShadowFrameUniforms.writeInt(ptr, pyramidDepth - 1);
        ptr = ClrwlShadowFrameUniforms.writeInt(ptr, 0);
        return ptr;
    }

    private static void writePackedFrustumPlanes(long ptr, Matrix4f m) {
        float nxX = m.m03() + m.m00();
        float nxY = m.m13() + m.m10();
        float nxZ = m.m23() + m.m20();
        float nxW = m.m33() + m.m30();
        float invl = Math.invsqrt((float)(nxX * nxX + nxY * nxY + nxZ * nxZ));
        nxX *= invl;
        nxY *= invl;
        nxZ *= invl;
        nxW *= invl;
        float pxX = m.m03() - m.m00();
        float pxY = m.m13() - m.m10();
        float pxZ = m.m23() - m.m20();
        float pxW = m.m33() - m.m30();
        invl = Math.invsqrt((float)(pxX * pxX + pxY * pxY + pxZ * pxZ));
        pxX *= invl;
        pxY *= invl;
        pxZ *= invl;
        pxW *= invl;
        float nyX = m.m03() + m.m01();
        float nyY = m.m13() + m.m11();
        float nyZ = m.m23() + m.m21();
        float nyW = m.m33() + m.m31();
        invl = Math.invsqrt((float)(nyX * nyX + nyY * nyY + nyZ * nyZ));
        nyX *= invl;
        nyY *= invl;
        nyZ *= invl;
        nyW *= invl;
        float pyX = m.m03() - m.m01();
        float pyY = m.m13() - m.m11();
        float pyZ = m.m23() - m.m21();
        float pyW = m.m33() - m.m31();
        invl = Math.invsqrt((float)(pyX * pyX + pyY * pyY + pyZ * pyZ));
        pyX *= invl;
        pyY *= invl;
        pyZ *= invl;
        pyW *= invl;
        float nzX = m.m03() + m.m02();
        float nzY = m.m13() + m.m12();
        float nzZ = m.m23() + m.m22();
        float nzW = m.m33() + m.m32();
        invl = Math.invsqrt((float)(nzX * nzX + nzY * nzY + nzZ * nzZ));
        nzX *= invl;
        nzY *= invl;
        nzZ *= invl;
        nzW *= invl;
        float pzX = m.m03() - m.m02();
        float pzY = m.m13() - m.m12();
        float pzZ = m.m23() - m.m22();
        float pzW = m.m33() - m.m32();
        invl = Math.invsqrt((float)(pzX * pzX + pzY * pzY + pzZ * pzZ));
        pzX *= invl;
        pzY *= invl;
        pzZ *= invl;
        pzW *= invl;
        MemoryUtil.memPutFloat((long)ptr, (float)nxX);
        MemoryUtil.memPutFloat((long)(ptr + 4L), (float)pxX);
        MemoryUtil.memPutFloat((long)(ptr + 8L), (float)nyX);
        MemoryUtil.memPutFloat((long)(ptr + 12L), (float)pyX);
        MemoryUtil.memPutFloat((long)(ptr + 16L), (float)nxY);
        MemoryUtil.memPutFloat((long)(ptr + 20L), (float)pxY);
        MemoryUtil.memPutFloat((long)(ptr + 24L), (float)nyY);
        MemoryUtil.memPutFloat((long)(ptr + 28L), (float)pyY);
        MemoryUtil.memPutFloat((long)(ptr + 32L), (float)nxZ);
        MemoryUtil.memPutFloat((long)(ptr + 36L), (float)pxZ);
        MemoryUtil.memPutFloat((long)(ptr + 40L), (float)nyZ);
        MemoryUtil.memPutFloat((long)(ptr + 44L), (float)pyZ);
        MemoryUtil.memPutFloat((long)(ptr + 48L), (float)nxW);
        MemoryUtil.memPutFloat((long)(ptr + 52L), (float)pxW);
        MemoryUtil.memPutFloat((long)(ptr + 56L), (float)nyW);
        MemoryUtil.memPutFloat((long)(ptr + 60L), (float)pyW);
        MemoryUtil.memPutFloat((long)(ptr + 64L), (float)nzX);
        MemoryUtil.memPutFloat((long)(ptr + 68L), (float)pzX);
        MemoryUtil.memPutFloat((long)(ptr + 72L), (float)nzY);
        MemoryUtil.memPutFloat((long)(ptr + 76L), (float)pzY);
        MemoryUtil.memPutFloat((long)(ptr + 80L), (float)nzZ);
        MemoryUtil.memPutFloat((long)(ptr + 84L), (float)pzZ);
        MemoryUtil.memPutFloat((long)(ptr + 88L), (float)nzW);
        MemoryUtil.memPutFloat((long)(ptr + 92L), (float)pzW);
    }
}

