/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.compile.oit;

import dev.djefrey.colorwheel.Colorwheel;
import dev.djefrey.colorwheel.compile.GlslFragmentOutput;
import dev.djefrey.colorwheel.compile.oit.OitCoefficientsSamplersComponent;
import dev.djefrey.colorwheel.engine.ClrwlOitAccumulateOverride;
import dev.djefrey.colorwheel.util.Utils;
import dev.engine_room.flywheel.backend.glsl.ShaderSources;
import dev.engine_room.flywheel.backend.glsl.SourceComponent;
import dev.engine_room.flywheel.backend.glsl.generate.FnSignature;
import dev.engine_room.flywheel.backend.glsl.generate.GlslBlock;
import dev.engine_room.flywheel.backend.glsl.generate.GlslBuilder;
import dev.engine_room.flywheel.backend.glsl.generate.GlslStmt;
import dev.engine_room.flywheel.backend.glsl.generate.GlslUniform;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class OitCompositeComponent
implements SourceComponent {
    private final ShaderSources sources;
    private final int[] drawBuffers;
    private final int[] ranks;
    private final List<ClrwlOitAccumulateOverride> overrides;

    public OitCompositeComponent(ShaderSources sources, int[] drawBuffers, int[] ranks, List<ClrwlOitAccumulateOverride> overrides) {
        this.sources = sources;
        this.drawBuffers = drawBuffers;
        this.ranks = ranks;
        this.overrides = overrides;
    }

    public Collection<? extends SourceComponent> included() {
        return List.of(this.sources.get(Colorwheel.rl("internal/oit/wavelet.glsl")), this.sources.get(Colorwheel.rl("internal/uniform/frame.glsl")), this.sources.get(Colorwheel.rl("internal/depth.glsl")));
    }

    public String source() {
        int i;
        GlslBuilder builder = new GlslBuilder();
        OitCoefficientsSamplersComponent.addSamplers(builder, this.ranks.length);
        OitCompositeComponent.addAccumulateSamplers(builder, this.drawBuffers);
        builder.uniform().type("sampler2D").name("_flw_depthRange");
        OitCompositeComponent.addOutputs(builder, this.drawBuffers.length);
        GlslBlock body = new GlslBlock();
        body.add(GlslStmt.raw((String)"float minDepth = -texelFetch(_flw_depthRange, ivec2(gl_FragCoord.xy), 0).r;"));
        body.add(GlslStmt.raw((String)"if (minDepth == _flw_cullData.zfar) { discard; }"));
        body.add(GlslStmt.raw((String)"gl_FragDepth = _clrwl_delinearize_depth(minDepth, _flw_cullData.znear, _flw_cullData.zfar);"));
        for (i = 0; i < this.ranks.length; ++i) {
            int rank = this.ranks[i];
            String name = "total_transmittance" + i;
            String coeffName = "clrwl_coefficients" + i;
            body.add(GlslStmt.raw((String)("float " + name + " = _clrwl_total_transmittance(" + coeffName + ", " + rank + ");")));
        }
        for (i = 0; i < this.drawBuffers.length; ++i) {
            int drawBuffer = this.drawBuffers[i];
            Optional coeffId = Utils.findFirst(this.overrides, e -> e.drawBuffer() == drawBuffer).flatMap(ClrwlOitAccumulateOverride::coefficientId);
            String accumulate = "_clrwl_accumulate" + drawBuffer;
            String out = "frag" + i;
            if (coeffId.isPresent()) {
                String texelName = "texelTranslucent" + drawBuffer;
                String totalName = "total_transmittance" + coeffId.get();
                body.add(GlslStmt.raw((String)("vec4 " + texelName + " = texelFetch(" + accumulate + ", ivec2(gl_FragCoord.xy), 0);")));
                body.add(GlslStmt.raw((String)(out + " = vec4(" + texelName + ".rgb / " + texelName + ".a, 1. - " + totalName + ");")));
                continue;
            }
            body.add(GlslStmt.raw((String)(out + " = texelFetch(" + accumulate + ", ivec2(gl_FragCoord.xy), 0);")));
        }
        builder.function().signature(FnSignature.create().returnType("void").name("main").build()).body(body);
        return builder.build();
    }

    public String name() {
        return Colorwheel.rl("oit_composite").toString();
    }

    public static void addOutputs(GlslBuilder builder, int targetCnt) {
        for (int i = 0; i < targetCnt; ++i) {
            GlslFragmentOutput out = new GlslFragmentOutput().binding(i).type("vec4").name("frag" + i);
            builder.add((GlslBuilder.Declaration)out);
        }
    }

    public static void addAccumulateSamplers(GlslBuilder builder, int[] drawBuffers) {
        for (int drawBuffer : drawBuffers) {
            GlslUniform uniform = new GlslUniform().type("sampler2D").name("_clrwl_accumulate" + drawBuffer);
            builder.add((GlslBuilder.Declaration)uniform);
        }
    }
}

