/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.instancing;

import com.mojang.datafixers.util.Pair;
import dev.djefrey.colorwheel.ClrwlSamplers;
import dev.djefrey.colorwheel.Colorwheel;
import dev.djefrey.colorwheel.accessors.ProgramSetAccessor;
import dev.djefrey.colorwheel.accessors.ShaderPackAccessor;
import dev.djefrey.colorwheel.compile.ClrwlPipelineCompiler;
import dev.djefrey.colorwheel.compile.ClrwlProgram;
import dev.djefrey.colorwheel.compile.ClrwlPrograms;
import dev.djefrey.colorwheel.compile.ClrwlShaderKey;
import dev.djefrey.colorwheel.engine.ClrwlAbstractInstancer;
import dev.djefrey.colorwheel.engine.ClrwlBlendModeOverride;
import dev.djefrey.colorwheel.engine.ClrwlDrawManager;
import dev.djefrey.colorwheel.engine.ClrwlInstanceHandle;
import dev.djefrey.colorwheel.engine.ClrwlInstancerKey;
import dev.djefrey.colorwheel.engine.ClrwlMaterialRenderState;
import dev.djefrey.colorwheel.engine.ClrwlMeshPool;
import dev.djefrey.colorwheel.engine.ClrwlOitFramebuffers;
import dev.djefrey.colorwheel.engine.ClrwlProgramFramebuffers;
import dev.djefrey.colorwheel.engine.ClrwlRenderingPhase;
import dev.djefrey.colorwheel.engine.embed.EnvironmentStorage;
import dev.djefrey.colorwheel.engine.uniform.ClrwlUniforms;
import dev.djefrey.colorwheel.instancing.ClrwlInstancedDraw;
import dev.djefrey.colorwheel.instancing.ClrwlInstancedInstancer;
import dev.djefrey.colorwheel.shaderpack.ClrwlProgramId;
import dev.djefrey.colorwheel.shaderpack.ClrwlShaderProperties;
import dev.djefrey.colorwheel.util.GlCompat;
import dev.engine_room.flywheel.api.backend.Engine;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.material.Material;
import dev.engine_room.flywheel.api.material.Transparency;
import dev.engine_room.flywheel.api.model.Model;
import dev.engine_room.flywheel.backend.Samplers;
import dev.engine_room.flywheel.backend.compile.ContextShader;
import dev.engine_room.flywheel.backend.engine.CommonCrumbling;
import dev.engine_room.flywheel.backend.engine.GroupKey;
import dev.engine_room.flywheel.backend.engine.LightStorage;
import dev.engine_room.flywheel.backend.engine.MaterialRenderState;
import dev.engine_room.flywheel.backend.engine.TextureBinder;
import dev.engine_room.flywheel.backend.engine.embed.Environment;
import dev.engine_room.flywheel.backend.engine.instancing.InstancedLight;
import dev.engine_room.flywheel.backend.gl.TextureBuffer;
import dev.engine_room.flywheel.backend.gl.array.GlVertexArray;
import dev.engine_room.flywheel.lib.material.SimpleMaterial;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.gl.GLDebug;
import net.irisshaders.iris.gl.blending.BufferBlendInformation;
import net.irisshaders.iris.gl.framebuffer.GlFramebuffer;
import net.irisshaders.iris.pipeline.IrisRenderingPipeline;
import net.irisshaders.iris.shaderpack.ShaderPack;
import net.irisshaders.iris.shaderpack.materialmap.NamespacedId;
import net.irisshaders.iris.shaderpack.programs.ProgramSet;
import net.irisshaders.iris.shaderpack.programs.ProgramSource;
import net.irisshaders.iris.shaderpack.properties.ProgramDirectives;
import net.irisshaders.iris.shadows.ShadowRenderingState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.StringUtils;

public class ClrwlInstancedDrawManager
extends ClrwlDrawManager<ClrwlInstancedInstancer<?>> {
    private static final Comparator<ClrwlInstancedDraw> DRAW_COMPARATOR = Comparator.comparing(ClrwlInstancedDraw::bias).thenComparing(ClrwlInstancedDraw::indexOfMeshInModel).thenComparing(ClrwlInstancedDraw::material, MaterialRenderState.COMPARATOR);
    private final List<ClrwlInstancedDraw> allDraws = new ArrayList<ClrwlInstancedDraw>();
    private boolean needSort = false;
    private final List<ClrwlInstancedDraw> solidDraws = new ArrayList<ClrwlInstancedDraw>();
    private final List<ClrwlInstancedDraw> translucentDraws = new ArrayList<ClrwlInstancedDraw>();
    private final List<ClrwlInstancedDraw> oitDraws = new ArrayList<ClrwlInstancedDraw>();
    private final ClrwlPrograms programs;
    private final ClrwlProgramFramebuffers framebuffers;
    private final ClrwlMeshPool meshPool;
    private final GlVertexArray vao;
    private final TextureBuffer instanceTexture;
    private final InstancedLight light;
    private final NamespacedId dimension;
    private final IrisRenderingPipeline irisPipeline;
    private final ShaderPack pack;
    private final ProgramSet programSet;
    private final Set<ClrwlShaderKey> brokenShaders = new HashSet<ClrwlShaderKey>();
    private ClrwlRenderingPhase currentRenderPhase = ClrwlRenderingPhase.SOLID;

    public ClrwlInstancedDrawManager(NamespacedId dimension, IrisRenderingPipeline irisPipeline, ShaderPack pack, ClrwlPrograms programs) {
        this.dimension = dimension;
        this.irisPipeline = irisPipeline;
        this.pack = pack;
        this.programSet = pack.getProgramSet(dimension);
        this.programs = programs;
        this.framebuffers = new ClrwlProgramFramebuffers();
        this.meshPool = new ClrwlMeshPool();
        this.vao = GlVertexArray.create();
        this.instanceTexture = new TextureBuffer();
        this.light = new InstancedLight();
        this.meshPool.bind(this.vao);
    }

    @Override
    public void prepareFrame(LightStorage lightStorage, EnvironmentStorage environmentStorage) {
        super.prepareFrame(lightStorage, environmentStorage);
        this.instancers.values().removeIf(instancer -> {
            if (instancer.instanceCount() == 0) {
                instancer.delete();
                return true;
            }
            instancer.updateBuffer();
            return false;
        });
        this.needSort |= this.allDraws.removeIf(ClrwlInstancedDraw::deleted);
        if (this.needSort) {
            this.allDraws.sort(DRAW_COMPARATOR);
            this.solidDraws.clear();
            this.translucentDraws.clear();
            this.oitDraws.clear();
            for (ClrwlInstancedDraw draw : this.allDraws) {
                if (draw.material().transparency() == Transparency.TRANSLUCENT) {
                    this.translucentDraws.add(draw);
                    continue;
                }
                if (draw.material().transparency() == Transparency.ORDER_INDEPENDENT) {
                    this.oitDraws.add(draw);
                    continue;
                }
                this.solidDraws.add(draw);
            }
            this.needSort = false;
        }
        this.meshPool.flush();
        this.light.flush(lightStorage);
    }

    @Override
    public void renderSolid() {
        if (this.solidDraws.isEmpty()) {
            return;
        }
        boolean isShadow = ShadowRenderingState.areShadowsCurrentlyBeingRendered();
        if (isShadow && ((ProgramSetAccessor)this.programSet).colorwheel$getClrwlProgramSource(ClrwlProgramId.SHADOW).isEmpty()) {
            return;
        }
        this.setPhase(ClrwlRenderingPhase.SOLID, isShadow);
        ClrwlUniforms.bind(isShadow);
        this.vao.bindForDraw();
        TextureBinder.bindLightAndOverlay();
        this.light.bind();
        this.submitDraws(this.solidDraws, isShadow);
        ClrwlMaterialRenderState.reset();
        TextureBinder.resetLightAndOverlay();
    }

    @Override
    public void renderTranslucent() {
        if (this.translucentDraws.isEmpty() && this.oitDraws.isEmpty()) {
            return;
        }
        boolean isShadow = ShadowRenderingState.areShadowsCurrentlyBeingRendered();
        this.setPhase(ClrwlRenderingPhase.TRANSLUCENT, isShadow);
        ClrwlUniforms.bind(isShadow);
        this.vao.bindForDraw();
        TextureBinder.bindLightAndOverlay();
        this.light.bind();
        if (!this.translucentDraws.isEmpty()) {
            this.submitDraws(this.translucentDraws, isShadow);
        }
        if (!this.oitDraws.isEmpty()) {
            boolean isOitEnabled;
            ClrwlProgramId program = !isShadow ? ClrwlProgramId.GBUFFERS_TRANSLUCENT : ClrwlProgramId.SHADOW_TRANSLUCENT;
            boolean bl = isOitEnabled = GlCompat.SUPPORTS_OIT && ((ShaderPackAccessor)this.pack).colorwheel$getProperties().isOitEnabled(program.group());
            if (isOitEnabled) {
                Optional<ProgramSource> maybeSrc = ((ProgramSetAccessor)this.programSet).colorwheel$getClrwlProgramSource(program);
                if (maybeSrc.isEmpty()) {
                    return;
                }
                ClrwlShaderProperties properties = ((ShaderPackAccessor)this.pack).colorwheel$getProperties();
                ProgramDirectives directives = maybeSrc.get().getDirectives();
                GlFramebuffer framebuffer = this.framebuffers.getFramebuffer(program, this.irisPipeline, this.programSet);
                ClrwlOitFramebuffers oitFramebuffer = this.framebuffers.getOitFramebuffers(program.group(), this.programs.getOitPrograms(), this.irisPipeline, properties, directives);
                ClrwlBlendModeOverride blendOverride = this.framebuffers.getBlendModeOverride(program, this.pack, this.programSet).orElse(null);
                List<BufferBlendInformation> bufferBlendOverrides = this.framebuffers.getBufferBlendModeOverrides(program, this.pack, this.programSet);
                if (framebuffer == null || oitFramebuffer == null) {
                    return;
                }
                this.setPhase(ClrwlRenderingPhase.OIT_DEPTH_RANGE, isShadow);
                oitFramebuffer.prepare();
                oitFramebuffer.prepareDepthRange();
                this.submitOitDraws(isShadow, ClrwlPipelineCompiler.OitMode.DEPTH_RANGE);
                if (oitFramebuffer.prepareRenderTransmittance()) {
                    this.setPhase(ClrwlRenderingPhase.OIT_COEFFICIENTS, isShadow);
                    this.submitOitDraws(isShadow, ClrwlPipelineCompiler.OitMode.GENERATE_COEFFICIENTS);
                }
                this.setPhase(ClrwlRenderingPhase.OIT_ACCUMULATE, isShadow);
                oitFramebuffer.prepareAccumulate();
                this.submitOitDraws(isShadow, ClrwlPipelineCompiler.OitMode.EVALUATE);
                this.setPhase(ClrwlRenderingPhase.OIT_COMPOSITE, isShadow);
                oitFramebuffer.composite(framebuffer, blendOverride, bufferBlendOverrides);
            } else {
                this.setPhase(ClrwlRenderingPhase.TRANSLUCENT, isShadow);
                this.submitDraws(this.oitDraws, isShadow);
            }
        }
        ClrwlMaterialRenderState.reset();
        TextureBinder.resetLightAndOverlay();
    }

    private void submitDraws(List<ClrwlInstancedDraw> draws, boolean isShadow) {
        GlFramebuffer prevFramebuffer = null;
        for (ClrwlInstancedDraw drawCall : draws) {
            ClrwlProgram program;
            ClrwlShaderKey key;
            Material material = drawCall.material();
            GroupKey<?> groupKey = drawCall.groupKey;
            Environment environment = groupKey.environment();
            ClrwlProgramId programId = ClrwlProgramId.fromTransparency(material.transparency(), isShadow);
            GlFramebuffer framebuffer = this.framebuffers.getFramebuffer(programId, this.irisPipeline, this.programSet);
            if (framebuffer == null || this.brokenShaders.contains(key = ClrwlShaderKey.fromMaterial(groupKey.instanceType(), material, environment.contextShader(), isShadow, ClrwlPipelineCompiler.OitMode.OFF))) continue;
            try {
                program = this.programs.get(key);
            }
            catch (Exception e) {
                this.handleBrokenShader(key, programId, e);
                continue;
            }
            ClrwlBlendModeOverride blendOverride = this.framebuffers.getBlendModeOverride(programId, this.pack, this.programSet).orElse(null);
            List<BufferBlendInformation> bufferBlendOverrides = this.framebuffers.getBufferBlendModeOverrides(programId, this.pack, this.programSet);
            program.bind(drawCall.mesh().baseVertex(), 0, material, drawCall.visual(), drawCall.mesh().meshCenter(), this.currentRenderPhase, blendOverride);
            environment.setupDraw(program.getProgram());
            ClrwlMaterialRenderState.setup(material, blendOverride, bufferBlendOverrides);
            ClrwlSamplers.INSTANCE_BUFFER.makeActive();
            if (prevFramebuffer != framebuffer) {
                prevFramebuffer = framebuffer;
                framebuffer.bind();
            }
            drawCall.render(this.instanceTexture);
            program.unbind();
        }
    }

    private void submitOitDraws(boolean isShadow, ClrwlPipelineCompiler.OitMode oit) {
        ClrwlProgramId programId = isShadow ? ClrwlProgramId.SHADOW_TRANSLUCENT : ClrwlProgramId.GBUFFERS_TRANSLUCENT;
        ClrwlBlendModeOverride blendOverride = this.framebuffers.getBlendModeOverride(programId, this.pack, this.programSet).orElse(null);
        for (ClrwlInstancedDraw drawCall : this.oitDraws) {
            ClrwlProgram program;
            Material material = drawCall.material();
            GroupKey<?> groupKey = drawCall.groupKey;
            Environment environment = groupKey.environment();
            ClrwlShaderKey key = ClrwlShaderKey.fromMaterial(groupKey.instanceType(), material, environment.contextShader(), isShadow, oit);
            if (this.brokenShaders.contains(key)) continue;
            try {
                program = this.programs.get(key);
            }
            catch (Exception e) {
                this.handleBrokenShader(key, programId, e);
                continue;
            }
            program.bind(drawCall.mesh().baseVertex(), 0, material, drawCall.visual(), drawCall.mesh().meshCenter(), this.currentRenderPhase, blendOverride);
            environment.setupDraw(program.getProgram());
            ClrwlMaterialRenderState.setupOit(material);
            Samplers.INSTANCE_BUFFER.makeActive();
            drawCall.render(this.instanceTexture);
            program.unbind();
        }
    }

    @Override
    public void renderCrumbling(List<Engine.CrumblingBlock> crumblingBlocks) {
        boolean isShadow = ShadowRenderingState.areShadowsCurrentlyBeingRendered();
        if (isShadow) {
            return;
        }
        Map<GroupKey<?>, Int2ObjectMap<List<Pair<ClrwlInstancedInstancer, ClrwlInstanceHandle<?>>>>> byType = ClrwlInstancedDrawManager.doCrumblingSort(crumblingBlocks, handle -> {
            if (handle instanceof ClrwlInstancedInstancer) {
                ClrwlInstancedInstancer instancer = (ClrwlInstancedInstancer)handle;
                return instancer;
            }
            return null;
        });
        if (byType.isEmpty()) {
            return;
        }
        GlFramebuffer framebuffer = this.framebuffers.getFramebuffer(ClrwlProgramId.GBUFFERS_DAMAGEDBLOCK, this.irisPipeline, this.programSet);
        if (framebuffer == null) {
            return;
        }
        this.setPhase(ClrwlRenderingPhase.CRUMBLING, false);
        framebuffer.bind();
        ClrwlUniforms.bind(false);
        this.vao.bindForDraw();
        TextureBinder.bindLightAndOverlay();
        ClrwlBlendModeOverride blendOverride = this.framebuffers.getBlendModeOverride(ClrwlProgramId.GBUFFERS_DAMAGEDBLOCK, this.pack, this.programSet).orElse(null);
        List<BufferBlendInformation> bufferBlendOverrides = this.framebuffers.getBufferBlendModeOverrides(ClrwlProgramId.GBUFFERS_DAMAGEDBLOCK, this.pack, this.programSet);
        SimpleMaterial.Builder crumblingMaterial = SimpleMaterial.builder();
        for (Map.Entry<GroupKey<?>, Int2ObjectMap<List<Pair<ClrwlInstancedInstancer, ClrwlInstanceHandle<?>>>>> groupEntry : byType.entrySet()) {
            Int2ObjectMap<List<Pair<ClrwlInstancedInstancer, ClrwlInstanceHandle<?>>>> byProgress = groupEntry.getValue();
            GroupKey<?> key = groupEntry.getKey();
            for (Int2ObjectMap.Entry progressEntry : byProgress.int2ObjectEntrySet()) {
                Samplers.CRUMBLING.makeActive();
                TextureBinder.bind((ResourceLocation)((ResourceLocation)ModelBakery.f_119228_.get(progressEntry.getIntKey())));
                for (Pair instanceHandlePair : (List)progressEntry.getValue()) {
                    ClrwlInstancedInstancer instancer = (ClrwlInstancedInstancer)instanceHandlePair.getFirst();
                    int index = ((ClrwlInstanceHandle)instanceHandlePair.getSecond()).index;
                    for (ClrwlInstancedDraw draw : instancer.draws()) {
                        ClrwlProgram program;
                        CommonCrumbling.applyCrumblingProperties((SimpleMaterial.Builder)crumblingMaterial, (Material)draw.material());
                        ClrwlShaderKey shaderKey = ClrwlShaderKey.fromMaterial(key.instanceType(), (Material)crumblingMaterial, ContextShader.CRUMBLING, false, ClrwlPipelineCompiler.OitMode.OFF);
                        if (this.brokenShaders.contains(shaderKey)) continue;
                        try {
                            program = this.programs.get(shaderKey);
                        }
                        catch (Exception e) {
                            this.handleBrokenShader(shaderKey, ClrwlProgramId.GBUFFERS_DAMAGEDBLOCK, e);
                            continue;
                        }
                        program.bind(0, index, (Material)crumblingMaterial, draw.visual(), draw.mesh().meshCenter(), this.currentRenderPhase, blendOverride);
                        ClrwlMaterialRenderState.setup((Material)crumblingMaterial, blendOverride, bufferBlendOverrides);
                        Samplers.INSTANCE_BUFFER.makeActive();
                        draw.renderOne(this.instanceTexture);
                    }
                }
            }
        }
        ClrwlMaterialRenderState.reset();
        TextureBinder.resetLightAndOverlay();
    }

    private void handleBrokenShader(ClrwlShaderKey key, ClrwlProgramId baseProgramId, Exception e) {
        if (this.brokenShaders.isEmpty() && Colorwheel.CONFIG.shouldAlertBrokenPack()) {
            Colorwheel.sendWarnMessage(Component.m_237115_((String)"colorwheel.alert.broken_pack"), true);
            MutableComponent disableComp = Component.m_237115_((String)"colorwheel.alert.ask_disable").m_130948_(Style.f_131099_.m_131162_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/colorwheel alertBrokenPack off")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"colorwheel.alert.broken_pack.disable"))));
            Colorwheel.sendWarnMessage(disableComp, false);
        }
        this.brokenShaders.add(key);
        ClrwlProgramId realProgramId = ((ProgramSetAccessor)this.programSet).colorwheel$getRealClrwlProgram(baseProgramId).orElse(baseProgramId);
        String shaderPath = realProgramId.programName() + "/" + key.getPath();
        Colorwheel.LOGGER.error("Could not compile shader: " + shaderPath, (Throwable)e);
    }

    @Override
    public void delete() {
        this.brokenShaders.clear();
        this.instancers.values().forEach(ClrwlInstancedInstancer::delete);
        this.solidDraws.clear();
        this.translucentDraws.clear();
        this.oitDraws.clear();
        this.allDraws.forEach(ClrwlInstancedDraw::delete);
        this.allDraws.clear();
        this.meshPool.delete();
        this.instanceTexture.delete();
        this.programs.delete();
        this.vao.delete();
        this.light.delete();
        this.framebuffers.delete(this.irisPipeline);
        super.delete();
    }

    @Override
    protected <I extends Instance> ClrwlInstancedInstancer<I> create(ClrwlInstancerKey<I> key) {
        return new ClrwlInstancedInstancer<I>(key, new ClrwlAbstractInstancer.Recreate<I>(key, this));
    }

    @Override
    protected <I extends Instance> void initialize(ClrwlInstancerKey<I> key, ClrwlInstancedInstancer<?> instancer) {
        instancer.init();
        List meshes = key.model().meshes();
        for (int i = 0; i < meshes.size(); ++i) {
            Model.ConfiguredMesh entry = (Model.ConfiguredMesh)meshes.get(i);
            ClrwlMeshPool.PooledMesh mesh = this.meshPool.alloc(entry.mesh());
            GroupKey groupKey = new GroupKey(key.type(), key.environment());
            ClrwlInstancedDraw instancedDraw = new ClrwlInstancedDraw(instancer, mesh, groupKey, entry.material(), key.bias(), i);
            this.allDraws.add(instancedDraw);
            this.needSort = true;
            instancer.addDrawCall(instancedDraw);
        }
    }

    @Override
    public void triggerFallback() {
        Minecraft.m_91087_().f_91060_.m_109818_();
    }

    private String getShaderPackName() {
        return Iris.getCurrentPackName();
    }

    private void setPhase(ClrwlRenderingPhase phase, boolean shadow) {
        String name = "Clrwl " + (shadow ? "Shadow " : "") + StringUtils.capitalize((String)phase.name().toLowerCase(Locale.ROOT).replace("_", " "));
        GLDebug.popGroup();
        GLDebug.pushGroup((int)phase.getValue(), (String)name);
        this.currentRenderPhase = phase;
    }
}

