/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.block;

import com.stevekung.fishofthieves.FOTPlatform;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTItems;
import com.stevekung.fishofthieves.registry.FOTSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TallPomegranatePlantBlock
extends DoublePlantBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.AGE_3;
    public static final BooleanProperty PERSISTENT = BlockStateProperties.PERSISTENT;
    private static final VoxelShape LOWER_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape UPPER_SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public TallPomegranatePlantBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(false)));
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Boolean)state.getValue((Property)PERSISTENT) == false && state.getValue((Property)HALF) == DoubleBlockHalf.LOWER && (Integer)state.getValue((Property)AGE) <= 2;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return state.getValue((Property)HALF) == DoubleBlockHalf.UPPER ? UPPER_SHAPE : Shapes.empty();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{AGE, PERSISTENT}));
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return state.getValue((Property)HALF) == DoubleBlockHalf.UPPER ? UPPER_SHAPE : LOWER_SHAPE;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos blockPos = context.getClickedPos();
        BlockState blockState = super.getStateForPlacement(context);
        boolean isUnobstructed = UPPER_SHAPE.isEmpty() || this.isUnobstructed(level, blockPos);
        return blockState != null && isUnobstructed ? blockState : null;
    }

    private boolean isUnobstructed(Level level, BlockPos pos) {
        return level.isUnobstructed(null, UPPER_SHAPE.move((double)pos.getX(), (double)pos.getY(), (double)pos.getZ())) && level.isUnobstructed(null, UPPER_SHAPE.move((double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ()));
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof Ravager && level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING)) {
            level.destroyBlock(pos, true, entity);
        }
        super.entityInside(state, level, pos, entity);
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return false;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        float growthSpeed = FOTPlatform.getGrowthSpeedFromCropBlock(this.defaultBlockState(), level, pos);
        if (random.nextInt((int)(25.0f / growthSpeed) + 1) == 0) {
            this.grow(level, state, pos);
        }
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        boolean canHarvest;
        ItemStack itemStack = player.getItemInHand(hand);
        int age = (Integer)state.getValue((Property)AGE);
        boolean bl = canHarvest = age == 3;
        if (!((Boolean)state.getValue((Property)PERSISTENT)).booleanValue() && itemStack.is(Items.SHEARS)) {
            if (!level.isClientSide()) {
                level.playSound(null, pos, SoundEvents.GROWING_PLANT_CROP, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.setBlock(pos, (BlockState)state.setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(true)), 11);
                if (state.getValue((Property)HALF) == DoubleBlockHalf.LOWER) {
                    level.setBlock(pos.above(), (BlockState)((BlockState)state.setValue((Property)HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(true)), 11);
                } else {
                    level.setBlock(pos.below(), (BlockState)((BlockState)state.setValue((Property)HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(true)), 11);
                }
                itemStack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                level.gameEvent((Entity)player, (Holder)GameEvent.SHEAR, pos);
                player.awardStat(Stats.ITEM_USED.get((Object)Items.SHEARS));
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        if (!canHarvest && player.getItemInHand(hand).is(Items.BONE_MEAL)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (canHarvest) {
            int count = 1 + level.random.nextInt(2);
            TallPomegranatePlantBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)FOTItems.POMEGRANATE, count + 1));
            level.playSound(null, pos, FOTSoundEvents.POMEGRANATE_PLANT_PICK, SoundSource.BLOCKS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
            BlockState blockState = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(0));
            level.setBlock(pos, blockState, 2);
            if (state.getValue((Property)HALF) == DoubleBlockHalf.LOWER) {
                level.setBlock(pos.above(), (BlockState)blockState.setValue((Property)HALF, (Comparable)DoubleBlockHalf.UPPER), 2);
            } else {
                level.setBlock(pos.below(), (BlockState)blockState.setValue((Property)HALF, (Comparable)DoubleBlockHalf.LOWER), 2);
            }
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)blockState));
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    private void grow(ServerLevel level, BlockState state, BlockPos pos) {
        int i = Math.min((Integer)state.getValue((Property)AGE) + 1, 3);
        Boolean persistent = (Boolean)state.getValue((Property)PERSISTENT);
        if (this.canGrow((LevelReader)level, pos, state)) {
            level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(i))).setValue((Property)PERSISTENT, (Comparable)persistent), 2);
            level.setBlock(pos.above(), TallPomegranatePlantBlock.copyWaterloggedFrom((LevelReader)level, (BlockPos)pos.above(), (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)AGE, (Comparable)Integer.valueOf(i))).setValue((Property)PERSISTENT, (Comparable)persistent))), 3);
        }
    }

    private static boolean sufficientLight(LevelReader level, BlockPos pos) {
        return level.getRawBrightness(pos, 0) >= 8 || level.canSeeSky(pos);
    }

    private static boolean isLower(BlockState state) {
        return state.is(FOTBlocks.TALL_POMEGRANATE_PLANT) && state.getValue((Property)HALF) == DoubleBlockHalf.LOWER;
    }

    private boolean canGrow(LevelReader reader, BlockPos pos, BlockState state) {
        return (Integer)state.getValue((Property)AGE) <= 2 && TallPomegranatePlantBlock.sufficientLight(reader, pos);
    }

    @Nullable
    private PosAndState getLowerHalf(LevelReader level, BlockPos pos, BlockState state) {
        if (TallPomegranatePlantBlock.isLower(state)) {
            return new PosAndState(pos, state);
        }
        BlockPos blockPos = pos.below();
        BlockState blockState = level.getBlockState(blockPos);
        return TallPomegranatePlantBlock.isLower(blockState) ? new PosAndState(blockPos, blockState) : null;
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        PosAndState posAndState = this.getLowerHalf(level, pos, state);
        return posAndState != null && this.canGrow(level, posAndState.pos, posAndState.state);
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        PosAndState posAndState = this.getLowerHalf((LevelReader)level, pos, state);
        if (posAndState != null) {
            this.grow(level, posAndState.state, posAndState.pos);
        }
    }

    record PosAndState(BlockPos pos, BlockState state) {
    }
}

