/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.client.model.HeadphoneModel;
import com.stevekung.fishofthieves.client.model.ModelPartGetter;
import com.stevekung.fishofthieves.entity.AbstractThievesFish;
import com.stevekung.fishofthieves.entity.animal.Islehopper;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;

public class IslehopperModel<T extends Islehopper>
extends EntityModel<T>
implements HeadphoneModel.Scaleable<T>,
ModelPartGetter {
    public static final ModelLayerLocation LAYER = new ModelLayerLocation(FishOfThieves.id("islehopper"), "main");
    private final ModelPart main;
    private final ModelPart body_back;
    private final ModelPart body_back_2;

    public IslehopperModel(ModelPart part) {
        super(RenderType::entityCutout);
        this.main = part.getChild("main");
        this.body_back = this.main.getChild("body_back");
        this.body_back_2 = this.body_back.getChild("body_back_2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition main = partDefinition.addOrReplaceChild("main", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition head = main.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("head_r1", CubeListBuilder.create().texOffs(18, 10).addBox(-2.0f, -3.15f, -0.775f, 4.0f, 3.0f, 1.0f, new CubeDeformation(0.025f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.1f, (float)-2.475f, (float)1.1781f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("head_r2", CubeListBuilder.create().texOffs(0, 10).addBox(-2.0f, -2.32f, 0.425f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.02f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.98f, (float)-3.475f, (float)1.0908f, (float)0.0f, (float)0.0f));
        PartDefinition body_main = main.addOrReplaceChild("body_main", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -6.0f, -3.5f, 4.0f, 5.0f, 5.0f, CubeDeformation.NONE).texOffs(18, 0).addBox(-2.5f, -5.25f, -3.75f, 5.0f, 2.0f, 2.0f, CubeDeformation.NONE).texOffs(0, 14).addBox(0.0f, -7.0f, -3.5f, 0.0f, 1.0f, 5.0f, CubeDeformation.NONE).texOffs(0, 17).addBox(0.0f, -1.0f, -3.5f, 0.0f, 1.0f, 5.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        body_main.addOrReplaceChild("right_fin_r1", CubeListBuilder.create().texOffs(6, 25).addBox(-2.35f, -3.5f, -0.75f, 3.0f, 2.0f, 0.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        body_main.addOrReplaceChild("left_fin_r1", CubeListBuilder.create().texOffs(6, 27).addBox(-0.65f, -3.5f, -0.75f, 3.0f, 2.0f, 0.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        body_main.addOrReplaceChild("bottom_right_fin_r1", CubeListBuilder.create().texOffs(0, 16).addBox(0.0f, 0.0f, -3.5f, 0.0f, 1.0f, 5.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-2.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        body_main.addOrReplaceChild("bottom_left_fin_r1", CubeListBuilder.create().texOffs(0, 18).addBox(0.0f, 0.0f, -3.5f, 0.0f, 1.0f, 5.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)2.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        body_main.addOrReplaceChild("top_left_fin_r1", CubeListBuilder.create().texOffs(0, 15).addBox(0.0f, -1.0f, -3.5f, 0.0f, 1.0f, 5.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)2.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        body_main.addOrReplaceChild("top_right_fin_r1", CubeListBuilder.create().texOffs(0, 13).addBox(0.0f, -1.0f, -3.5f, 0.0f, 1.0f, 5.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-2.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition body_back = main.addOrReplaceChild("body_back", CubeListBuilder.create().texOffs(18, 4).addBox(-1.5f, -2.0f, 0.0f, 3.0f, 4.0f, 2.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)-3.75f, (float)1.5f));
        body_back.addOrReplaceChild("bottom_right_fin_r2", CubeListBuilder.create().texOffs(11, 18).addBox(0.0f, 0.0f, 1.5f, 0.0f, 1.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-1.5f, (float)2.0f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)0.7854f));
        body_back.addOrReplaceChild("bottom_left_fin_r2", CubeListBuilder.create().texOffs(11, 19).addBox(0.0f, 0.0f, 1.5f, 0.0f, 1.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)1.5f, (float)2.0f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        body_back.addOrReplaceChild("top_right_fin_r2", CubeListBuilder.create().texOffs(11, 16).addBox(0.0f, -1.0f, 1.5f, 0.0f, 1.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-1.5f, (float)-2.0f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        body_back.addOrReplaceChild("top_left_fin_r2", CubeListBuilder.create().texOffs(11, 17).addBox(0.0f, -1.0f, 1.5f, 0.0f, 1.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)1.5f, (float)-2.0f, (float)-1.5f, (float)0.0f, (float)0.0f, (float)0.7854f));
        body_back.addOrReplaceChild("body_back_2", CubeListBuilder.create().texOffs(18, 14).addBox(-1.0f, -1.5f, -0.5f, 2.0f, 3.0f, 2.0f, CubeDeformation.NONE).texOffs(0, 22).addBox(0.0f, -2.5f, 1.5f, 0.0f, 5.0f, 3.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)-0.25f, (float)2.0f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)32, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float backRotation = 1.0f;
        float backRotSpeed = 1.0f;
        if (!entity.isInWater() && !((AbstractThievesFish)entity).isNoFlip()) {
            backRotation = 1.5f;
            backRotSpeed = 1.7f;
        }
        this.body_back.yRot = -backRotation * 0.05f * Mth.sin((float)(backRotSpeed * 0.6f * ageInTicks));
        this.body_back_2.yRot = -backRotation * 0.1f * Mth.sin((float)(backRotSpeed * 0.6f * ageInTicks));
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int packedColor) {
        this.main.render(poseStack, buffer, packedLight, packedOverlay, packedColor);
    }

    @Override
    public void scale(T entity, PoseStack poseStack) {
        float scale = 2.0f;
        poseStack.scale(scale, scale - 0.5f, scale - 0.5f);
        poseStack.translate(0.0f, -0.265f, -0.06f);
    }

    @Override
    public ModelPart main() {
        return this.main;
    }
}

