/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.client.model.HeadphoneModel;
import com.stevekung.fishofthieves.client.model.ModelPartGetter;
import com.stevekung.fishofthieves.entity.AbstractSchoolingThievesFish;
import com.stevekung.fishofthieves.entity.animal.Pondie;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;

public class PondieModel<T extends Pondie>
extends EntityModel<T>
implements HeadphoneModel.Scaleable<T>,
ModelPartGetter {
    public static final ModelLayerLocation LAYER = new ModelLayerLocation(FishOfThieves.id("pondie"), "main");
    private final ModelPart main;
    private final ModelPart mouth;
    private final ModelPart body_back;

    public PondieModel(ModelPart part) {
        super(RenderType::entityCutout);
        this.main = part.getChild("main");
        this.mouth = this.main.getChild("head").getChild("mouth_r1");
        this.body_back = this.main.getChild("body_back");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        PartDefinition main = partDefinition.addOrReplaceChild("main", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition head = main.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("mouth_r1", CubeListBuilder.create().texOffs(0, 20).addBox(-2.5f, 0.025f, -5.05f, 5.0f, 1.0f, 5.0f, new CubeDeformation(0.02f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.15f, (float)-3.0f, (float)-0.8727f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("head_r1", CubeListBuilder.create().texOffs(0, 11).addBox(-2.5f, -2.19f, -2.3f, 5.0f, 5.0f, 4.0f, new CubeDeformation(0.01f)), PartPose.offsetAndRotation((float)0.0f, (float)-4.26f, (float)-3.0f, (float)0.48f, (float)0.0f, (float)0.0f));
        PartDefinition body_main = main.addOrReplaceChild("body_main", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -7.0f, -2.5f, 5.0f, 6.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(15, 0).addBox(-2.5f, -2.0f, -3.5f, 5.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(18, 18).addBox(0.0f, -8.5f, -2.0f, 0.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(15, 1).addBox(0.0f, -1.0f, -2.0f, 0.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        body_main.addOrReplaceChild("right_fin_r1", CubeListBuilder.create().texOffs(24, 17).addBox(-3.5f, -5.0f, 0.5f, 3.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-2.25f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        body_main.addOrReplaceChild("left_fin_r1", CubeListBuilder.create().texOffs(18, 17).addBox(0.5f, -5.0f, 0.5f, 3.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.25f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition body_back = main.addOrReplaceChild("body_back", CubeListBuilder.create().texOffs(20, 4).addBox(-1.5f, -2.0f, 0.0f, 3.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(20, 10).addBox(-1.0f, -1.5f, 1.5f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 23).addBox(0.0f, -2.5f, 3.5f, 0.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-4.5f, (float)2.5f));
        body_back.addOrReplaceChild("right_fin_r2", CubeListBuilder.create().texOffs(24, 17).addBox(0.75f, 1.3f, 3.0f, 0.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)-2.5f, (float)0.0f, (float)0.0f, (float)0.5236f));
        body_back.addOrReplaceChild("left_fin_r2", CubeListBuilder.create().texOffs(18, 17).addBox(-0.75f, 1.3f, 3.0f, 0.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)-2.5f, (float)0.0f, (float)0.0f, (float)-0.5236f));
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)32, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float backRotation = 1.0f;
        float backRotSpeed = 1.0f;
        float mouthSpeed = 0.15f;
        if (!entity.isInWater() && !((AbstractSchoolingThievesFish)entity).isNoFlip()) {
            backRotation = 1.5f;
            backRotSpeed = 1.7f;
            mouthSpeed = 2.1f;
        }
        this.body_back.yRot = -backRotation * 0.15f * Mth.sin((float)(backRotSpeed * 0.65f * ageInTicks));
        this.mouth.xRot = -0.8727f + Mth.cos((float)(mouthSpeed * ageInTicks)) * (float)Math.PI * 0.02f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int packedColor) {
        this.main.render(poseStack, buffer, packedLight, packedOverlay, packedColor);
    }

    @Override
    public void scale(T entity, PoseStack poseStack) {
        float scale = 2.0f;
        poseStack.scale(scale, scale - 0.5f, scale - 0.5f);
        poseStack.translate(0.0f, -0.3f, -0.025f);
    }

    @Override
    public ModelPart main() {
        return this.main;
    }
}

