/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.stevekung.fishofthieves.client.model.HeadphoneModel;
import com.stevekung.fishofthieves.client.model.ModelPartGetter;
import com.stevekung.fishofthieves.client.renderer.entity.layers.GlowFishLayer;
import com.stevekung.fishofthieves.client.renderer.entity.layers.HeadphoneLayer;
import com.stevekung.fishofthieves.entity.ThievesFish;
import com.stevekung.fishofthieves.entity.variant.AbstractFishVariant;
import java.util.function.Consumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.animal.AbstractFish;

public abstract class ThievesFishRenderer<V extends AbstractFishVariant, T extends AbstractFish & VariantHolder<Holder<V>>, M extends EntityModel<T> & HeadphoneModel.Scaleable<T>>
extends MobRenderer<T, M> {
    protected ThievesFishRenderer(EntityRendererProvider.Context context, M entityModel) {
        super(context, entityModel, 0.15f);
        this.addLayer(new GlowFishLayer(this));
        this.addLayer(new HeadphoneLayer((LivingEntityRenderer<?, ?>)this, context.getModelSet(), (HeadphoneModel.Scaleable)entityModel));
    }

    public void render(T livingEntity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        this.shadowRadius = ((ThievesFish)livingEntity).isTrophy() ? 0.25f : 0.15f;
        super.render(livingEntity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    protected void setupRotations(T entity, PoseStack poseStack, float bob, float rotationYaw, float partialTicks, float scale) {
        super.setupRotations(entity, poseStack, bob, rotationYaw, partialTicks, scale);
        boolean inWater = entity.isInWater() || ((ThievesFish)entity).isNoFlip();
        RotationRenderData rotationRenderData = this.setupRotations(entity, inWater);
        float degree = rotationRenderData.baseDegree * Mth.sin((float)(rotationRenderData.bodyRotBase * rotationRenderData.bodyRotSpeed * bob));
        poseStack.mulPose(Axis.YP.rotationDegrees(degree));
        if (!inWater) {
            rotationRenderData.translateConsumer.accept(poseStack);
            poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
        }
        this.doFishPitchYaw(entity, partialTicks);
    }

    public ResourceLocation getTextureLocation(T livingEntity) {
        return ((AbstractFishVariant)((Holder)((VariantHolder)livingEntity).getVariant()).value()).fullTexture();
    }

    protected void scale(T livingEntity, PoseStack poseStack, float partialTickTime) {
        float scale = ((ThievesFish)livingEntity).isTrophy() ? 1.0f : 0.5f;
        poseStack.scale(scale, scale, scale);
    }

    private void doFishPitchYaw(T entity, float partialTicks) {
        float headPitch = Mth.lerp((float)partialTicks, (float)((AbstractFish)entity).xRotO, (float)entity.getXRot());
        if (!((AbstractFish)entity).hasImpulse) {
            ((ModelPartGetter)this.getModel()).main().xRot = headPitch * ((float)Math.PI / 180);
        }
    }

    public abstract RotationRenderData setupRotations(T var1, boolean var2);

    public record RotationRenderData(float bodyRotBase, float bodyRotSpeed, float baseDegree, Consumer<PoseStack> translateConsumer) {
        public static RotationRenderData create(float bodyRotBase, float bodyRotSpeed, float baseDegree, Consumer<PoseStack> translateConsumer) {
            return new RotationRenderData(bodyRotBase, bodyRotSpeed, baseDegree, translateConsumer);
        }
    }
}

