/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.compatibility.terrablender;

import com.stevekung.fishofthieves.feature.surfacerules.BlockStateConditionSource;
import com.stevekung.fishofthieves.feature.surfacerules.WaterSurroundedConditionSource;
import com.stevekung.fishofthieves.registry.FOTBiomes;
import com.stevekung.fishofthieves.registry.FOTNoises;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.VerticalAnchor;

public class FOTSurfaceRuleData {
    private static final SurfaceRules.RuleSource SAND = FOTSurfaceRuleData.makeStateRule(Blocks.SAND);
    private static final SurfaceRules.RuleSource SANDSTONE = FOTSurfaceRuleData.makeStateRule(Blocks.SANDSTONE);

    public static SurfaceRules.RuleSource overworld() {
        return SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.abovePreliminarySurface(), (SurfaceRules.RuleSource)FOTSurfaceRuleData.makeRules())});
    }

    private static SurfaceRules.RuleSource makeRules() {
        SurfaceRules.ConditionSource waterAboveCheck = SurfaceRules.waterBlockCheck((int)1, (int)0);
        SurfaceRules.ConditionSource y62 = SurfaceRules.yBlockCheck((VerticalAnchor)VerticalAnchor.absolute((int)62), (int)0);
        SurfaceRules.ConditionSource airAboveCheck = FOTSurfaceRuleData.blockStateCheck(Blocks.AIR, 1);
        SurfaceRules.ConditionSource sixBelowWater = SurfaceRules.waterStartCheck((int)-6, (int)-1);
        SurfaceRules.RuleSource sandWithSandstone = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_CEILING, (SurfaceRules.RuleSource)SANDSTONE), SAND});
        SurfaceRules.ConditionSource surfaceBelow64 = SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.yStartCheck((VerticalAnchor)VerticalAnchor.absolute((int)64), (int)0));
        return SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)sixBelowWater, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.UNDER_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{FOTBiomes.TROPICAL_ISLAND}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)surfaceBelow64, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)waterAboveCheck), (SurfaceRules.RuleSource)sandWithSandstone), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)y62, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)FOTSurfaceRuleData.waterSurrounded(), (SurfaceRules.RuleSource)sandWithSandstone))}))}))}))})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{FOTBiomes.TROPICAL_ISLAND}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)airAboveCheck, (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition(FOTNoises.SAND_PATCHES, (double)-0.6, (double)-0.45), (SurfaceRules.RuleSource)SAND), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.noiseCondition(FOTNoises.SAND_PATCHES, (double)0.1, (double)0.2), (SurfaceRules.RuleSource)SAND)})))}))});
    }

    private static SurfaceRules.ConditionSource waterSurrounded() {
        return new WaterSurroundedConditionSource();
    }

    private static SurfaceRules.ConditionSource blockStateCheck(Block block, int offset) {
        return new BlockStateConditionSource(block.defaultBlockState(), offset);
    }

    private static SurfaceRules.RuleSource makeStateRule(Block block) {
        return SurfaceRules.state((BlockState)block.defaultBlockState());
    }
}

