/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.stevekung.fishofthieves.entity.AbstractFlockFish;
import com.stevekung.fishofthieves.entity.ai.AbstractThievesFishAi;
import com.stevekung.fishofthieves.entity.ai.behavior.CreateFishFlock;
import com.stevekung.fishofthieves.entity.ai.behavior.FishBreaching;
import com.stevekung.fishofthieves.entity.ai.behavior.FollowFlockLeader;
import com.stevekung.fishofthieves.entity.ai.behavior.MergeOtherFlock;
import com.stevekung.fishofthieves.registry.FOTMemoryModuleTypes;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.GateBehavior;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.schedule.Activity;

public class AbstractSchoolingThievesFishAi {
    private static final UniformInt TIME_BETWEEN_BREACH = UniformInt.of((int)900, (int)1600);

    public static void initMemories(AbstractFlockFish fish) {
        fish.getBrain().setMemory(FOTMemoryModuleTypes.SCHOOL_SIZE, (Object)1);
        fish.getBrain().setMemory(FOTMemoryModuleTypes.FOLLOW_FLOCK_COOLDOWN_TICKS, (Object)CreateFishFlock.nextStartTick(fish.getRandom()));
        fish.getBrain().setMemory(MemoryModuleType.LONG_JUMP_COOLDOWN_TICKS, (Object)TIME_BETWEEN_BREACH.sample(fish.getRandom()));
    }

    public static void resetMemories(AbstractFlockFish fish) {
        AbstractSchoolingThievesFishAi.initMemories(fish);
        fish.getBrain().eraseMemory(FOTMemoryModuleTypes.IS_FLOCK_LEADER);
        fish.getBrain().eraseMemory(FOTMemoryModuleTypes.IS_FLOCK_FOLLOWER);
        fish.getBrain().eraseMemory(FOTMemoryModuleTypes.FLOCK_LEADER);
        fish.getBrain().eraseMemory(FOTMemoryModuleTypes.MERGE_FROM_OTHER_FLOCK);
    }

    public static Brain<?> makeBrain(Brain<AbstractFlockFish> brain) {
        AbstractSchoolingThievesFishAi.initCoreActivity(brain);
        AbstractSchoolingThievesFishAi.initIdleActivity(brain);
        AbstractSchoolingThievesFishAi.initRetreatActivity(brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    public static void updateActivity(AbstractFlockFish fish) {
        fish.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.AVOID, (Object)Activity.IDLE));
    }

    public static <T extends AbstractFlockFish> void customServerAiStep(T fish, Brain<T> brain) {
        String name = BuiltInRegistries.ENTITY_TYPE.getKey((Object)fish.getType()).getPath();
        fish.level().getProfiler().push(name + "Brain");
        brain.tick((ServerLevel)fish.level(), fish);
        fish.level().getProfiler().popPush(name + "ActivityUpdate");
        AbstractSchoolingThievesFishAi.updateActivity(fish);
        fish.level().getProfiler().pop();
    }

    private static void initCoreActivity(Brain<AbstractFlockFish> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new AnimalPanic(2.0f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), AbstractThievesFishAi.avoidPlayer(), (Object)new CountDownCooldownTicks(MemoryModuleType.TEMPTATION_COOLDOWN_TICKS), (Object)new CountDownCooldownTicks(FOTMemoryModuleTypes.FOLLOW_FLOCK_COOLDOWN_TICKS), (Object)new CountDownCooldownTicks(MemoryModuleType.LONG_JUMP_COOLDOWN_TICKS), (Object)new CountDownCooldownTicks(FOTMemoryModuleTypes.BREACHED_TICK)));
    }

    private static void initIdleActivity(Brain<AbstractFlockFish> brain) {
        brain.addActivity(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, (Object)SetEntityLookTargetSometimes.create((EntityType)EntityType.PLAYER, (float)6.0f, (UniformInt)UniformInt.of((int)30, (int)60))), (Object)Pair.of((Object)1, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of(AbstractThievesFishAi.avoidRepellent(), (Object)1), (Object)Pair.of((Object)new FollowTemptation(livingEntity -> Float.valueOf(1.25f)), (Object)1), (Object)Pair.of((Object)((Object)new CreateFishFlock()), (Object)2), (Object)Pair.of((Object)((Object)new FollowFlockLeader(1.25f)), (Object)3), (Object)Pair.of(new FishBreaching(TIME_BETWEEN_BREACH, 0.3f, 0.16f), (Object)2)))), (Object)Pair.of((Object)2, (Object)((Object)new MergeOtherFlock())), (Object)Pair.of((Object)3, (Object)new GateBehavior((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), (Set)ImmutableSet.of(), GateBehavior.OrderPolicy.ORDERED, GateBehavior.RunningPolicy.TRY_ALL, (List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.swim((float)1.0f), (Object)2), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)0.5f, (int)3), (Object)3), (Object)Pair.of((Object)BehaviorBuilder.triggerIf(Entity::isInWaterOrBubble), (Object)5))))));
    }

    private static void initRetreatActivity(Brain<AbstractFlockFish> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.AVOID, 10, ImmutableList.of((Object)SetWalkTargetAwayFrom.entity((MemoryModuleType)MemoryModuleType.AVOID_TARGET, (float)5.0f, (int)12, (boolean)true), AbstractSchoolingThievesFishAi.createIdleLookBehaviors(), AbstractSchoolingThievesFishAi.createIdleMovementBehaviors(), (Object)EraseMemoryIf.create(AbstractThievesFishAi::wantsToStopFleeing, (MemoryModuleType)MemoryModuleType.AVOID_TARGET)), MemoryModuleType.AVOID_TARGET);
    }

    private static RunOne<AbstractFlockFish> createIdleLookBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)SetEntityLookTarget.create((EntityType)EntityType.PLAYER, (float)6.0f), (Object)1), (Object)Pair.of((Object)SetEntityLookTarget.create((float)8.0f), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    private static RunOne<AbstractFlockFish> createIdleMovementBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.swim((float)1.0f), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    public static void wasHurtBy(AbstractFlockFish livingEntity) {
        Brain brain = livingEntity.getBrain();
        if (livingEntity.isFollower()) {
            livingEntity.getLeader().removeFollower();
            brain.setMemory(FOTMemoryModuleTypes.FOLLOW_FLOCK_COOLDOWN_TICKS, (Object)CreateFishFlock.nextStartTick(livingEntity.getRandom(), 1200));
            brain.eraseMemory(FOTMemoryModuleTypes.IS_FLOCK_FOLLOWER);
            brain.eraseMemory(FOTMemoryModuleTypes.FLOCK_LEADER);
        }
    }
}

