/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.ai.AbstractThievesFishAi;
import com.stevekung.fishofthieves.entity.ai.behavior.CreateFishFlock;
import com.stevekung.fishofthieves.entity.ai.behavior.FishBreaching;
import com.stevekung.fishofthieves.entity.ai.behavior.FollowFlockLeader;
import com.stevekung.fishofthieves.entity.ai.behavior.StartAttackingIgnoreFlockLeader;
import com.stevekung.fishofthieves.entity.animal.Battlegill;
import com.stevekung.fishofthieves.registry.FOTMemoryModuleTypes;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.GateBehavior;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.schedule.Activity;

public class BattlegillAi {
    public static Brain<?> makeBrain(Brain<Battlegill> brain) {
        BattlegillAi.initCoreActivity(brain);
        BattlegillAi.initIdleActivity(brain);
        BattlegillAi.initFightActivity(brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    public static void updateActivity(Battlegill fish) {
        if (FishOfThieves.CONFIG.general.neutralFishBehavior) {
            fish.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.FIGHT, (Object)Activity.IDLE));
        } else {
            fish.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.IDLE));
        }
    }

    public static void initMemories(Battlegill fish) {
        fish.getBrain().setMemory(MemoryModuleType.LONG_JUMP_COOLDOWN_TICKS, (Object)AbstractThievesFishAi.TIME_BETWEEN_BREACH.sample(fish.getRandom()));
    }

    private static void initCoreActivity(Brain<Battlegill> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new AnimalPanic(2.0f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks(MemoryModuleType.TEMPTATION_COOLDOWN_TICKS), (Object)new CountDownCooldownTicks(FOTMemoryModuleTypes.FOLLOW_FLOCK_COOLDOWN_TICKS), (Object)new CountDownCooldownTicks(MemoryModuleType.LONG_JUMP_COOLDOWN_TICKS), (Object)new CountDownCooldownTicks(FOTMemoryModuleTypes.BREACHED_TICK)));
    }

    private static void initIdleActivity(Brain<Battlegill> brain) {
        brain.addActivity(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, (Object)SetEntityLookTargetSometimes.create((EntityType)EntityType.PLAYER, (float)6.0f, (UniformInt)UniformInt.of((int)30, (int)60))), (Object)Pair.of((Object)1, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of(AbstractThievesFishAi.avoidRepellent(), (Object)1), (Object)Pair.of((Object)new FollowTemptation(livingEntity -> Float.valueOf(1.25f)), (Object)1), (Object)Pair.of((Object)((Object)new CreateFishFlock()), (Object)2), (Object)Pair.of((Object)((Object)new FollowFlockLeader(1.25f)), (Object)3), (Object)Pair.of(new FishBreaching(AbstractThievesFishAi.TIME_BETWEEN_BREACH, 0.2f, 0.12f), (Object)4)))), (Object)Pair.of((Object)2, new StartAttackingIgnoreFlockLeader<Battlegill>(BattlegillAi::findNearestValidAttackTarget)), (Object)Pair.of((Object)3, (Object)new GateBehavior((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), (Set)ImmutableSet.of(), GateBehavior.OrderPolicy.ORDERED, GateBehavior.RunningPolicy.TRY_ALL, (List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.swim((float)1.0f), (Object)2), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)0.5f, (int)3), (Object)3), (Object)Pair.of((Object)BehaviorBuilder.triggerIf(Entity::isInWaterOrBubble), (Object)5))))));
    }

    private static void initFightActivity(Brain<Battlegill> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.FIGHT, 0, ImmutableList.of((Object)StopAttackingIfTargetInvalid.create(livingEntity -> false, (mob, livingEntity) -> livingEntity.getBrain().setMemory(FOTMemoryModuleTypes.FOLLOW_FLOCK_COOLDOWN_TICKS, (Object)CreateFishFlock.nextStartTick(livingEntity.getRandom(), 200)), (boolean)true), (Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.create((float)1.25f), (Object)MeleeAttack.create((int)20)), MemoryModuleType.ATTACK_TARGET);
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(Battlegill fish) {
        return fish.getBrain().getMemory(MemoryModuleType.NEAREST_ATTACKABLE);
    }
}

