/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.animal;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Dynamic;
import com.stevekung.fishofthieves.entity.AbstractFlockFish;
import com.stevekung.fishofthieves.entity.AbstractSchoolingThievesFish;
import com.stevekung.fishofthieves.entity.ai.AbstractSchoolingThievesFishAi;
import com.stevekung.fishofthieves.entity.variant.AncientscaleVariant;
import com.stevekung.fishofthieves.registry.FOTDataSerializers;
import com.stevekung.fishofthieves.registry.FOTItems;
import com.stevekung.fishofthieves.registry.FOTRegistries;
import com.stevekung.fishofthieves.registry.FOTSensorTypes;
import com.stevekung.fishofthieves.registry.FOTSoundEvents;
import com.stevekung.fishofthieves.registry.FOTTags;
import com.stevekung.fishofthieves.registry.variant.AncientscaleVariants;
import com.stevekung.fishofthieves.utils.TerrainUtils;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;

public class Ancientscale
extends AbstractSchoolingThievesFish<AncientscaleVariant> {
    private static final EntityDataAccessor<Holder<AncientscaleVariant>> VARIANT = SynchedEntityData.defineId(Ancientscale.class, FOTDataSerializers.ANCIENTSCALE_VARIANT);
    public static final BiMap<String, Integer> VARIANT_TO_INT = (BiMap)Util.make((Object)HashBiMap.create(), map -> {
        map.put((Object)"fishofthieves:almond", (Object)0);
        map.put((Object)"fishofthieves:sapphire", (Object)1);
        map.put((Object)"fishofthieves:smoke", (Object)2);
        map.put((Object)"fishofthieves:bone", (Object)3);
        map.put((Object)"fishofthieves:starshine", (Object)4);
    });

    public Ancientscale(EntityType<? extends Ancientscale> entityType, Level level) {
        super(entityType, level, FOTRegistries.ANCIENTSCALE_VARIANT, AncientscaleVariants.ALMOND);
    }

    protected Brain.Provider<AbstractFlockFish> brainProvider() {
        return Brain.provider((Collection)MEMORY_TYPES, Stream.of(SENSOR_TYPES, List.of(FOTSensorTypes.LEECHES_THIEVES_FISH_TEMPTATIONS)).flatMap(Collection::stream).toList());
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return AbstractSchoolingThievesFishAi.makeBrain((Brain<AbstractFlockFish>)this.brainProvider().makeBrain(dynamic));
    }

    public Brain<Ancientscale> getBrain() {
        return super.getBrain();
    }

    @Override
    protected void customServerAiStep() {
        AbstractSchoolingThievesFishAi.customServerAiStep(this, this.getBrain());
        super.customServerAiStep();
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)this.registryAccess().registryOrThrow(FOTRegistries.ANCIENTSCALE_VARIANT).getHolderOrThrow(AncientscaleVariants.ALMOND));
    }

    public Holder<AncientscaleVariant> getVariant() {
        return (Holder)this.entityData.get(VARIANT);
    }

    public void setVariant(Holder<AncientscaleVariant> variant) {
        this.entityData.set(VARIANT, variant);
    }

    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)FOTItems.ANCIENTSCALE_BUCKET);
    }

    protected SoundEvent getDeathSound() {
        return FOTSoundEvents.ANCIENTSCALE_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return FOTSoundEvents.ANCIENTSCALE_HURT;
    }

    protected SoundEvent getFlopSound() {
        return FOTSoundEvents.ANCIENTSCALE_FLOP;
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return this.isTrophy() ? super.getDefaultDimensions(pose).withEyeHeight(0.35f) : EntityDimensions.fixed((float)0.3f, (float)0.25f).withEyeHeight(0.17f);
    }

    @Override
    public boolean isFood(ItemStack itemStack) {
        return LEECHES_FOOD.test(itemStack);
    }

    public static boolean checkSpawnRules(EntityType<? extends WaterAnimal> entityType, ServerLevelAccessor level, MobSpawnType mobSpawnType, BlockPos blockPos, RandomSource random) {
        boolean isSurfaceWater = WaterAnimal.checkSurfaceWaterAnimalSpawnRules(entityType, (LevelAccessor)level, (MobSpawnType)mobSpawnType, (BlockPos)blockPos, (RandomSource)random);
        boolean isWater = level.getFluidState(blockPos.below()).is(FluidTags.WATER) && level.getBlockState(blockPos.above()).is(Blocks.WATER);
        return isSurfaceWater || isWater && TerrainUtils.isInFeature(level.getLevel(), blockPos, FOTTags.Structures.ANCIENTSCALES_SPAWN_IN);
    }
}

