/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.animal;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Dynamic;
import com.stevekung.fishofthieves.entity.AbstractFlockFish;
import com.stevekung.fishofthieves.entity.AbstractSchoolingThievesFish;
import com.stevekung.fishofthieves.entity.ai.AbstractSchoolingThievesFishAi;
import com.stevekung.fishofthieves.entity.variant.SplashtailVariant;
import com.stevekung.fishofthieves.registry.FOTDataSerializers;
import com.stevekung.fishofthieves.registry.FOTItems;
import com.stevekung.fishofthieves.registry.FOTRegistries;
import com.stevekung.fishofthieves.registry.FOTSensorTypes;
import com.stevekung.fishofthieves.registry.FOTSoundEvents;
import com.stevekung.fishofthieves.registry.variant.SplashtailVariants;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class Splashtail
extends AbstractSchoolingThievesFish<SplashtailVariant> {
    private static final EntityDataAccessor<Holder<SplashtailVariant>> VARIANT = SynchedEntityData.defineId(Splashtail.class, FOTDataSerializers.SPLASHTAIL_VARIANT);
    public static final BiMap<String, Integer> VARIANT_TO_INT = (BiMap)Util.make((Object)HashBiMap.create(), map -> {
        map.put((Object)"fishofthieves:ruby", (Object)0);
        map.put((Object)"fishofthieves:sunny", (Object)1);
        map.put((Object)"fishofthieves:indigo", (Object)2);
        map.put((Object)"fishofthieves:umber", (Object)3);
        map.put((Object)"fishofthieves:seafoam", (Object)4);
    });

    public Splashtail(EntityType<? extends Splashtail> entityType, Level level) {
        super(entityType, level, FOTRegistries.SPLASHTAIL_VARIANT, SplashtailVariants.RUBY);
    }

    protected Brain.Provider<AbstractFlockFish> brainProvider() {
        return Brain.provider((Collection)MEMORY_TYPES, Stream.of(SENSOR_TYPES, List.of(FOTSensorTypes.COMMON_THIEVES_FISH_TEMPTATIONS)).flatMap(Collection::stream).toList());
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return AbstractSchoolingThievesFishAi.makeBrain((Brain<AbstractFlockFish>)this.brainProvider().makeBrain(dynamic));
    }

    public Brain<Splashtail> getBrain() {
        return super.getBrain();
    }

    @Override
    protected void customServerAiStep() {
        AbstractSchoolingThievesFishAi.customServerAiStep(this, this.getBrain());
        super.customServerAiStep();
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)this.registryAccess().registryOrThrow(FOTRegistries.SPLASHTAIL_VARIANT).getHolderOrThrow(SplashtailVariants.RUBY));
    }

    public Holder<SplashtailVariant> getVariant() {
        return (Holder)this.entityData.get(VARIANT);
    }

    public void setVariant(Holder<SplashtailVariant> variant) {
        this.entityData.set(VARIANT, variant);
    }

    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)FOTItems.SPLASHTAIL_BUCKET);
    }

    protected SoundEvent getDeathSound() {
        return FOTSoundEvents.SPLASHTAIL_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return FOTSoundEvents.SPLASHTAIL_HURT;
    }

    protected SoundEvent getFlopSound() {
        return FOTSoundEvents.SPLASHTAIL_FLOP;
    }

    public int getMaxSchoolSize() {
        return 5;
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return this.isTrophy() ? super.getDefaultDimensions(pose).withEyeHeight(0.3f) : EntityDimensions.fixed((float)0.45f, (float)0.25f).withEyeHeight(0.15f);
    }

    @Override
    public boolean isFood(ItemStack itemStack) {
        return WORMS.test(itemStack);
    }
}

