/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.item;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.condition.SpawnConditionContext;
import com.stevekung.fishofthieves.entity.variant.AbstractFishVariant;
import java.util.Comparator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FOTItem
extends Item {
    private final EntityType<?> entityType;
    private final ResourceLocation registryKey;

    public FOTItem(Item.Properties properties, EntityType<?> entityType, ResourceKey<?> registryKey) {
        super(properties);
        this.entityType = entityType;
        this.registryKey = registryKey.location();
    }

    public static void addFishVariants(CreativeModeTab.ItemDisplayParameters itemDisplayParameters, CreativeModeTab.Output output, Item item) {
        if (FishOfThieves.CONFIG.general.displayAllFishVariantInCreativeTab) {
            if (item instanceof FOTItem) {
                FOTItem fotItem = (FOTItem)item;
                Comparator<Holder> comparator = Comparator.comparing(Holder::value, Comparator.comparingInt(AbstractFishVariant::customModelData));
                ResourceKey registryKey = ResourceKey.createRegistryKey((ResourceLocation)fotItem.getRegistryKey());
                itemDisplayParameters.holders().lookup(registryKey).ifPresent(lookup -> lookup.listElements().sorted(comparator).mapToInt(holder -> ((AbstractFishVariant)holder.value()).customModelData()).forEach(customModelData -> output.accept(FOTItem.create(item, customModelData))));
            }
        } else {
            output.accept((ItemLike)item);
        }
    }

    public void verifyComponentsAfterLoad(ItemStack itemStack) {
        if (FishOfThieves.CONFIG.general.displayAllFishVariantInCreativeTab && !itemStack.has(DataComponents.CUSTOM_MODEL_DATA)) {
            itemStack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(0));
        }
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        Item item;
        if (FishOfThieves.CONFIG.general.displayAllFishVariantInCreativeTab && context.registries() != null && (item = itemStack.getItem()) instanceof FOTItem) {
            FOTItem fotItem = (FOTItem)item;
            ResourceKey registryKey = ResourceKey.createRegistryKey((ResourceLocation)fotItem.getRegistryKey());
            context.registries().lookup(registryKey).ifPresent(lookup -> lookup.listElements().map(Holder.Reference::value).forEach(variant -> {
                int customModelData = variant.customModelData();
                if (itemStack.has(DataComponents.CUSTOM_MODEL_DATA) && ((CustomModelData)itemStack.get(DataComponents.CUSTOM_MODEL_DATA)).value() == customModelData) {
                    tooltipComponents.add((Component)Component.translatable((String)(this.entityType.getDescriptionId() + "." + variant.name())).withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
                }
            }));
        }
    }

    public ResourceLocation getRegistryKey() {
        return this.registryKey;
    }

    public static ItemStack generateRandomFishVariantLootItem(ItemStack itemStack, ServerLevel level, @Nullable Vec3 vec3, RandomSource randomSource) {
        Item item;
        if (FishOfThieves.CONFIG.general.enableFishItemWithAllVariant && (item = itemStack.getItem()) instanceof FOTItem) {
            FOTItem fotItem = (FOTItem)item;
            ResourceKey registryKey = ResourceKey.createRegistryKey((ResourceLocation)fotItem.getRegistryKey());
            if (vec3 != null) {
                SpawnConditionContext context = new SpawnConditionContext(level, level.registryAccess(), BlockPos.containing((double)vec3.x, (double)vec3.y, (double)vec3.z), randomSource);
                Util.getRandomSafe(level.registryAccess().registryOrThrow(registryKey).holders().map(Holder.Reference::value).filter(variant -> variant.spawnSettings().fishing().isPresent() ? Util.allOf(variant.spawnSettings().fishing().get()).test(context) : Util.allOf(variant.spawnSettings().entity()).test(context)).toList(), (RandomSource)randomSource).ifPresent(variant -> itemStack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(variant.customModelData())));
            }
        }
        return itemStack;
    }

    private static ItemStack create(Item item, int index) {
        ItemStack itemStack = new ItemStack((ItemLike)item);
        itemStack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(index));
        return itemStack;
    }
}

