/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.item;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public abstract class ReturnedOnConsumeItem
extends Item {
    public ReturnedOnConsumeItem(Item.Properties properties) {
        super(properties);
    }

    public ItemStack finishUsingItem(ItemStack itemStack, Level level, LivingEntity livingEntity) {
        super.finishUsingItem(itemStack, level, livingEntity);
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            CriteriaTriggers.CONSUME_ITEM.trigger(serverPlayer, itemStack);
            serverPlayer.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        if (itemStack.isEmpty()) {
            return new ItemStack((ItemLike)this.getReturnedItem());
        }
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.getAbilities().instabuild) {
                ItemStack itemStack1 = new ItemStack((ItemLike)this.getReturnedItem());
                if (!player.getInventory().add(itemStack1)) {
                    player.drop(itemStack1, false);
                }
            }
        }
        return itemStack;
    }

    protected abstract Item getReturnedItem();
}

