/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.loot.function;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.loot.predicate.FOTLocationPredicate;
import com.stevekung.fishofthieves.registry.FOTLootItemConditions;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.phys.Vec3;

public record FOTLocationCheck(Optional<FOTLocationPredicate> predicate, BlockPos offset) implements LootItemCondition
{
    private static final MapCodec<BlockPos> OFFSET_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.optionalFieldOf("offsetX", (Object)0).forGetter(Vec3i::getX), (App)Codec.INT.optionalFieldOf("offsetY", (Object)0).forGetter(Vec3i::getY), (App)Codec.INT.optionalFieldOf("offsetZ", (Object)0).forGetter(Vec3i::getZ)).apply((Applicative)instance, BlockPos::new));
    public static final MapCodec<FOTLocationCheck> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)FOTLocationPredicate.CODEC.optionalFieldOf("predicate").forGetter(FOTLocationCheck::predicate), (App)OFFSET_CODEC.forGetter(FOTLocationCheck::offset)).apply((Applicative)instance, FOTLocationCheck::new));

    public LootItemConditionType getType() {
        return FOTLootItemConditions.FOT_LOCATION_CHECK;
    }

    public boolean test(LootContext context) {
        Vec3 vec3 = (Vec3)context.getParamOrNull(LootContextParams.ORIGIN);
        Entity entity = (Entity)context.getParamOrNull(LootContextParams.THIS_ENTITY);
        return vec3 != null && (this.predicate.isEmpty() || this.predicate.get().matches(context.getLevel(), entity, vec3.x() + (double)this.offset.getX(), vec3.y() + (double)this.offset.getY(), vec3.z() + (double)this.offset.getZ()));
    }

    public static LootItemCondition.Builder checkLocation(FOTLocationPredicate.Builder locationPredicateBuilder) {
        return () -> new FOTLocationCheck(Optional.of(locationPredicateBuilder.build()), BlockPos.ZERO);
    }
}

