/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.loot.predicate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.loot.predicate.StructureRangeCondition;
import com.stevekung.fishofthieves.utils.Continentalness;
import com.stevekung.fishofthieves.utils.PeakTypes;
import com.stevekung.fishofthieves.utils.TerrainUtils;
import java.util.Iterator;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import org.jetbrains.annotations.Nullable;

public record FOTLocationPredicate(Optional<Continentalness> continentalness, Optional<PeakTypes> peakType, Optional<Boolean> hasRaids, Optional<StructureRangeCondition> structureRangeCondition) {
    public static final Codec<FOTLocationPredicate> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Continentalness.CODEC.optionalFieldOf("continentalness").forGetter(FOTLocationPredicate::continentalness), (App)PeakTypes.CODEC.optionalFieldOf("peak_type").forGetter(FOTLocationPredicate::peakType), (App)Codec.BOOL.optionalFieldOf("has_raids").forGetter(FOTLocationPredicate::hasRaids), (App)StructureRangeCondition.CODEC.optionalFieldOf("structure_range").forGetter(FOTLocationPredicate::structureRangeCondition)).apply((Applicative)instance, FOTLocationPredicate::new));

    public boolean matches(ServerLevel level, @Nullable Entity entity, double x, double y, double z) {
        BlockPos blockPos = BlockPos.containing((double)x, (double)y, (double)z);
        boolean loaded = level.isLoaded(blockPos);
        boolean isRaided = level.isRaided(blockPos);
        return (this.structureRangeCondition.isEmpty() || loaded && this.isInRangeOfStructures(level, blockPos, entity, this.structureRangeCondition.get())) && (this.continentalness.isEmpty() || loaded && this.continentalness.get() == TerrainUtils.getContinentalness(level, blockPos)) && (this.hasRaids.isEmpty() || loaded && this.hasRaids.get() == isRaided);
    }

    private boolean isInRangeOfStructures(ServerLevel level, BlockPos blockPos, @Nullable Entity entity, StructureRangeCondition structureRangeCondition) {
        for (Holder structureHolder : structureRangeCondition.structures().stream().toList()) {
            Structure structure = (Structure)structureHolder.value();
            boolean isInsideStructure = level.structureManager().getStructureWithPieceAt(blockPos, structure).isValid();
            if (entity == null) {
                return isInsideStructure;
            }
            if (isInsideStructure) {
                return true;
            }
            Iterator iterator = level.structureManager().startsForStructure(SectionPos.of((BlockPos)blockPos), structure).iterator();
            if (!iterator.hasNext()) continue;
            StructureStart structureStart = (StructureStart)iterator.next();
            Integer entityDist = structureStart.getPieces().stream().map(structurePiece -> structurePiece.getBoundingBox().getCenter().distManhattan((Vec3i)entity.blockPosition())).findAny().orElse(Integer.MAX_VALUE);
            return entityDist < structureRangeCondition.range().getValue();
        }
        return false;
    }

    public static class Builder {
        private Optional<Continentalness> continentalness = Optional.empty();
        private Optional<PeakTypes> peakType = Optional.empty();
        private Optional<Boolean> hasRaids = Optional.empty();
        private Optional<StructureRangeCondition> structureRangeCondition = Optional.empty();

        public static Builder location() {
            return new Builder();
        }

        public Builder setContinentalness(Continentalness continentalness) {
            this.continentalness = Optional.of(continentalness);
            return this;
        }

        public Builder setPeakType(PeakTypes peakType) {
            this.peakType = Optional.of(peakType);
            return this;
        }

        public Builder hasRaids() {
            this.hasRaids = Optional.of(true);
            return this;
        }

        public Builder setStructureInRange(HolderSet<Structure> structure, int range) {
            this.structureRangeCondition = Optional.of(new StructureRangeCondition(structure, ConstantInt.of((int)range)));
            return this;
        }

        public FOTLocationPredicate build() {
            return new FOTLocationPredicate(this.continentalness, this.peakType, this.hasRaids, this.structureRangeCondition);
        }
    }
}

