/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.neoforge;

import com.stevekung.fishofthieves.neoforge.CompostableList;
import com.stevekung.fishofthieves.neoforge.FishOfThievesNeoForge;
import com.stevekung.fishofthieves.neoforge.mixin.accessor.CropBlockAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.ModList;

public class FOTPlatformImpl {
    public static boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    public static void addComposting(ItemLike item, float value) {
        CompostableList.COMPOSTABLES.put((Object)item, value);
    }

    public static void addFlammableBlock(Block block, int encouragement, int flammability) {
        FireBlock fireBlock = (FireBlock)Blocks.FIRE;
        fireBlock.setFlammable(block, encouragement, flammability);
    }

    public static <T extends BlockEntity> BlockEntityType<T> createBlockEntityType(BlockEntityType.BlockEntitySupplier<? extends T> factory, Block ... validBlocks) {
        return BlockEntityType.Builder.of(factory, (Block[])validBlocks).build(null);
    }

    public static <T extends Entity> EntityType<T> createEntityType(EntityType.EntityFactory<T> entityFactory, EntityDimensions dimensions) {
        return EntityType.Builder.of(entityFactory, (MobCategory)MobCategory.WATER_AMBIENT).sized(dimensions.width(), dimensions.height()).clientTrackingRange(4).build("");
    }

    public static float getGrowthSpeedFromCropBlock(BlockState state, ServerLevel level, BlockPos pos) {
        return CropBlockAccessor.callGetGrowthSpeed(state, (BlockGetter)level, pos);
    }

    public static void registerSerializer(String name, EntityDataSerializer<?> serializer) {
        FishOfThievesNeoForge.ENTITY_DATA_SERIALIZERS.register(name, () -> serializer);
    }
}

