/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.registry.variant;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.condition.AllOfCondition;
import com.stevekung.fishofthieves.entity.condition.MatchBlocksInRangeCondition;
import com.stevekung.fishofthieves.entity.condition.NightCondition;
import com.stevekung.fishofthieves.entity.condition.ProbabilityCondition;
import com.stevekung.fishofthieves.entity.condition.SeeSkyCondition;
import com.stevekung.fishofthieves.entity.condition.SpawnCondition;
import com.stevekung.fishofthieves.entity.variant.AbstractFishVariant;
import com.stevekung.fishofthieves.entity.variant.DevilfishVariant;
import com.stevekung.fishofthieves.registry.FOTRegistries;
import com.stevekung.fishofthieves.registry.FOTTags;
import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;

public class DevilfishVariants {
    public static final ResourceKey<DevilfishVariant> ASHEN = DevilfishVariants.createKey("ashen");
    public static final ResourceKey<DevilfishVariant> SEASHELL = DevilfishVariants.createKey("seashell");
    public static final ResourceKey<DevilfishVariant> LAVA = DevilfishVariants.createKey("lava");
    public static final ResourceKey<DevilfishVariant> FORSAKEN = DevilfishVariants.createKey("forsaken");
    public static final ResourceKey<DevilfishVariant> FIRELIGHT = DevilfishVariants.createKey("firelight");

    public static void bootstrap(BootstrapContext<DevilfishVariant> context) {
        AbstractFishVariant.RegisterContext<DevilfishVariant> registerContext = AbstractFishVariant.RegisterContext.create("devilfish", DevilfishVariant::new);
        registerContext.register(context, ASHEN, "ashen", 0, new SpawnCondition[0]);
        registerContext.register(context, SEASHELL, "seashell", 1, new SpawnCondition[0]);
        registerContext.register(context, LAVA, "lava", 2, MatchBlocksInRangeCondition.blocksInRange(Optional.empty(), Optional.of(context.lookup(Registries.FLUID).getOrThrow(FluidTags.LAVA)), 4).build());
        registerContext.register(context, FORSAKEN, "forsaken", 3, ProbabilityCondition.defaultRareProbablity().build());
        registerContext.register(context, FIRELIGHT, "firelight", 4, true, AllOfCondition.allOf(NightCondition.night(), MatchBlocksInRangeCondition.blocksInRange(Optional.of(context.lookup(Registries.BLOCK).getOrThrow(FOTTags.Blocks.FIRELIGHT_DEVILFISH_WARM_BLOCKS)), Optional.of(context.lookup(Registries.FLUID).getOrThrow(FluidTags.LAVA)), 4)).build());
    }

    public static void bootstrapSimple(BootstrapContext<DevilfishVariant> context) {
        AbstractFishVariant.RegisterContext<DevilfishVariant> registerContext = AbstractFishVariant.RegisterContext.create("devilfish", DevilfishVariant::new);
        registerContext.register(context, ASHEN, "ashen", 0, new SpawnCondition[0]);
        registerContext.register(context, SEASHELL, "seashell", 1, new SpawnCondition[0]);
        registerContext.register(context, LAVA, "lava", 2, new SpawnCondition[0]);
        registerContext.register(context, FORSAKEN, "forsaken", 3, ProbabilityCondition.defaultRareProbablity().build());
        registerContext.register(context, FIRELIGHT, "firelight", 4, true, AllOfCondition.allOf(NightCondition.night(), SeeSkyCondition.seeSky()).build());
    }

    private static ResourceKey<DevilfishVariant> createKey(String name) {
        return ResourceKey.create(FOTRegistries.DEVILFISH_VARIANT, (ResourceLocation)FishOfThieves.id(name));
    }
}

