/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.stevekung.fishofthieves.FOTPlatform;
import com.stevekung.fishofthieves.config.FishOfThievesConfig;
import com.stevekung.fishofthieves.entity.AbstractSchoolingThievesFish;
import com.stevekung.fishofthieves.entity.animal.Ancientscale;
import com.stevekung.fishofthieves.entity.animal.Battlegill;
import com.stevekung.fishofthieves.entity.animal.Devilfish;
import com.stevekung.fishofthieves.entity.animal.Islehopper;
import com.stevekung.fishofthieves.entity.animal.Plentifin;
import com.stevekung.fishofthieves.entity.animal.Pondie;
import com.stevekung.fishofthieves.entity.animal.Splashtail;
import com.stevekung.fishofthieves.entity.animal.Stormfish;
import com.stevekung.fishofthieves.entity.animal.Wildsplash;
import com.stevekung.fishofthieves.entity.animal.Wrecker;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTDisplayItems;
import com.stevekung.fishofthieves.registry.FOTEntities;
import com.stevekung.fishofthieves.registry.FOTItems;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.IntStream;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1317;
import net.minecraft.class_1480;
import net.minecraft.class_156;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2315;
import net.minecraft.class_2357;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_2967;
import net.minecraft.class_3853;
import net.minecraft.class_5132;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.slf4j.Logger;

public class FishOfThieves {
    public static final String MOD_ID = "fishofthieves";
    public static final String MOD_RESOURCES = "fishofthieves:";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final FishOfThievesConfig CONFIG = (FishOfThievesConfig)AutoConfig.register(FishOfThievesConfig.class, GsonConfigSerializer::new).getConfig();
    public static final class_5321<class_1761> FOT_MAIN = class_5321.method_29179((class_5321)class_7924.field_44688, (class_2960)FishOfThieves.id("fot_main"));
    public static final class_5321<class_1761> FOT_FISH = class_5321.method_29179((class_5321)class_7924.field_44688, (class_2960)FishOfThieves.id("fot"));

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    public static void initCommon() {
        class_2357 bucket = (class_2357)class_2315.field_10919.get(class_1802.field_8705);
        class_2315.method_10009((class_1935)FOTItems.SPLASHTAIL_BUCKET, (class_2357)bucket);
        class_2315.method_10009((class_1935)FOTItems.PONDIE_BUCKET, (class_2357)bucket);
        class_2315.method_10009((class_1935)FOTItems.ISLEHOPPER_BUCKET, (class_2357)bucket);
        class_2315.method_10009((class_1935)FOTItems.ANCIENTSCALE_BUCKET, (class_2357)bucket);
        class_2315.method_10009((class_1935)FOTItems.PLENTIFIN_BUCKET, (class_2357)bucket);
        class_2315.method_10009((class_1935)FOTItems.WILDSPLASH_BUCKET, (class_2357)bucket);
        class_2315.method_10009((class_1935)FOTItems.DEVILFISH_BUCKET, (class_2357)bucket);
        class_2315.method_10009((class_1935)FOTItems.BATTLEGILL_BUCKET, (class_2357)bucket);
        class_2315.method_10009((class_1935)FOTItems.WRECKER_BUCKET, (class_2357)bucket);
        class_2315.method_10009((class_1935)FOTItems.STORMFISH_BUCKET, (class_2357)bucket);
        class_2315.method_10009((class_1935)FOTItems.COCONUT_BOAT, (class_2357)new class_2967(FOTEntities.COCONUT_BOAT));
        class_2315.method_10009((class_1935)FOTItems.COCONUT_CHEST_BOAT, (class_2357)new class_2967(FOTEntities.COCONUT_CHEST_BOAT));
        FOTPlatform.addFlammableBlock(FOTBlocks.COCONUT_FRONDS, 30, 60);
        FOTPlatform.addFlammableBlock(FOTBlocks.BANANA_LEAVES, 30, 60);
        FOTPlatform.addFlammableBlock(FOTBlocks.VERTICAL_COCONUT_FRONDS, 30, 60);
        FOTPlatform.addFlammableBlock(FOTBlocks.VERTICAL_BANANA_LEAVES, 30, 60);
        FOTPlatform.addFlammableBlock(FOTBlocks.PINK_PLUMERIA, 60, 100);
        FOTPlatform.addFlammableBlock(FOTBlocks.LIGHT_BLUE_PLUMERIA, 60, 100);
        FOTPlatform.addFlammableBlock(FOTBlocks.WHITE_PLUMERIA, 60, 100);
        FOTPlatform.addFlammableBlock(FOTBlocks.COCONUT_SAPLING, 60, 100);
        FOTPlatform.addFlammableBlock(FOTBlocks.COCONUT_PLANKS, 5, 20);
        FOTPlatform.addFlammableBlock(FOTBlocks.COCONUT_FENCE, 5, 20);
        FOTPlatform.addFlammableBlock(FOTBlocks.COCONUT_FENCE_GATE, 5, 20);
        FOTPlatform.addFlammableBlock(FOTBlocks.COCONUT_SLAB, 5, 20);
        FOTPlatform.addFlammableBlock(FOTBlocks.COCONUT_STAIRS, 5, 20);
        FOTPlatform.addFlammableBlock(FOTBlocks.COCONUT_FRUIT, 5, 20);
        FOTPlatform.addFlammableBlock(FOTBlocks.COCONUT_LOG, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.SMALL_COCONUT_LOG, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.COCONUT_FRUIT_GROWABLE_LOG, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.SMALL_TOP_COCONUT_LOG, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.SMALL_COCONUT_WOOD, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.MEDIUM_COCONUT_LOG, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.MEDIUM_COCONUT_WOOD, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.COCONUT_WOOD, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.STRIPPED_COCONUT_LOG, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.STRIPPED_COCONUT_WOOD, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.STRIPPED_MEDIUM_COCONUT_LOG, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.STRIPPED_MEDIUM_COCONUT_WOOD, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.STRIPPED_SMALL_COCONUT_LOG, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.STRIPPED_SMALL_COCONUT_WOOD, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.BANANA_STEM, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.BANANA_CLUSTER_GROWABLE_STEM, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.PRISMARIZED_LOG, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.BUDDING_PRISMARIZED_LOG, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.MANGO_LEAVES, 30, 60);
        FOTPlatform.addFlammableBlock(FOTBlocks.BANANA_SHOOTS_PLANT, 60, 100);
        FOTPlatform.addFlammableBlock(FOTBlocks.BANANA_SHOOTS, 60, 100);
        FOTPlatform.addFlammableBlock(FOTBlocks.MANGO_SAPLING, 60, 100);
        FOTPlatform.addFlammableBlock(FOTBlocks.MANGO_PIT, 60, 100);
        FOTPlatform.addFlammableBlock(FOTBlocks.MANGO_FRUIT, 30, 20);
        FOTPlatform.addFlammableBlock(FOTBlocks.POMEGRANATE_PLANT, 60, 100);
        FOTPlatform.addFlammableBlock(FOTBlocks.TALL_POMEGRANATE_PLANT, 60, 100);
        FOTPlatform.addFlammableBlock(FOTBlocks.BANANA_BLOSSOM, 60, 100);
        FOTPlatform.addFlammableBlock(FOTBlocks.BANANA_BLOSSOM_PLANT, 60, 100);
        FOTPlatform.addFlammableBlock(FOTBlocks.POMEGRANATE_SAPLING, 60, 100);
        FOTPlatform.addFlammableBlock(FOTBlocks.TROPICAL_RED_FERN, 60, 100);
        FOTPlatform.addFlammableBlock(FOTBlocks.TROPICAL_MONSTERA, 60, 100);
        FOTPlatform.addFlammableBlock(FOTBlocks.UNDERRIPE_BANANA_CLUSTER_PLANT, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.BARELY_RIPE_BANANA_CLUSTER_PLANT, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.RIPE_BANANA_CLUSTER_PLANT, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.UNDERRIPE_BANANA_CLUSTER, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.BARELY_RIPE_BANANA_CLUSTER, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.RIPE_BANANA_CLUSTER, 5, 5);
        FOTPlatform.addFlammableBlock(FOTBlocks.UNDERRIPE_PINEAPPLE_BLOCK, 30, 20);
        FOTPlatform.addFlammableBlock(FOTBlocks.CROWNLESS_RIPE_PINEAPPLE_BLOCK, 30, 20);
        FOTPlatform.addFlammableBlock(FOTBlocks.RIPE_PINEAPPLE_BLOCK, 30, 20);
    }

    public static void initCompostables() {
        FOTPlatform.addComposting((class_1935)FOTItems.EARTHWORMS, 0.4f);
        FOTPlatform.addComposting((class_1935)FOTItems.GRUBS, 0.4f);
        FOTPlatform.addComposting((class_1935)FOTItems.LEECHES, 0.4f);
        FOTPlatform.addComposting((class_1935)FOTItems.COCONUT, 0.5f);
        FOTPlatform.addComposting((class_1935)FOTItems.BANANA, 0.3f);
        FOTPlatform.addComposting((class_1935)FOTItems.PINEAPPLE, 0.7f);
        FOTPlatform.addComposting((class_1935)FOTItems.CROWNLESS_PINEAPPLE, 0.65f);
        FOTPlatform.addComposting((class_1935)FOTItems.HALF_PINEAPPLE, 0.35f);
        FOTPlatform.addComposting((class_1935)FOTItems.PINEAPPLE_SEEDS, 0.1f);
        FOTPlatform.addComposting((class_1935)FOTItems.PINEAPPLE_CROWN, 0.15f);
        FOTPlatform.addComposting((class_1935)FOTItems.MANGO, 0.3f);
        FOTPlatform.addComposting((class_1935)FOTItems.RAW_MANGO, 0.3f);
        FOTPlatform.addComposting((class_1935)FOTItems.MANGO_PIT, 0.2f);
        FOTPlatform.addComposting((class_1935)FOTItems.POMEGRANATE, 0.2f);
        FOTPlatform.addComposting((class_1935)FOTItems.POMEGRANATE_SEEDS, 0.1f);
        FOTPlatform.addComposting((class_1935)FOTBlocks.PINK_PLUMERIA, 0.6f);
        FOTPlatform.addComposting((class_1935)FOTBlocks.LIGHT_BLUE_PLUMERIA, 0.6f);
        FOTPlatform.addComposting((class_1935)FOTBlocks.WHITE_PLUMERIA, 0.6f);
        FOTPlatform.addComposting((class_1935)FOTBlocks.COCONUT_FRONDS, 0.8f);
        FOTPlatform.addComposting((class_1935)FOTBlocks.BANANA_LEAVES, 0.8f);
        FOTPlatform.addComposting((class_1935)FOTBlocks.BANANA_BLOSSOM, 0.3f);
        FOTPlatform.addComposting((class_1935)FOTBlocks.BANANA_SHOOTS, 0.25f);
        FOTPlatform.addComposting((class_1935)FOTBlocks.UNDERRIPE_BANANA_CLUSTER, 0.5f);
        FOTPlatform.addComposting((class_1935)FOTBlocks.BARELY_RIPE_BANANA_CLUSTER, 0.85f);
        FOTPlatform.addComposting((class_1935)FOTBlocks.RIPE_BANANA_CLUSTER, 0.85f);
        FOTPlatform.addComposting((class_1935)FOTBlocks.BANANA_STEM, 0.8f);
        FOTPlatform.addComposting((class_1935)FOTBlocks.UNDERRIPE_PINEAPPLE_BLOCK, 0.6f);
        FOTPlatform.addComposting((class_1935)FOTBlocks.RIPE_PINEAPPLE_BLOCK, 0.75f);
        FOTPlatform.addComposting((class_1935)FOTBlocks.CROWNLESS_RIPE_PINEAPPLE_BLOCK, 0.7f);
        FOTPlatform.addComposting((class_1935)FOTBlocks.MANGO_LEAVES, 0.3f);
        FOTPlatform.addComposting((class_1935)FOTBlocks.MANGO_SAPLING, 0.25f);
        FOTPlatform.addComposting((class_1935)FOTBlocks.POMEGRANATE_PLANT, 0.25f);
        FOTPlatform.addComposting((class_1935)FOTBlocks.TALL_POMEGRANATE_PLANT, 0.4f);
        FOTPlatform.addComposting((class_1935)FOTBlocks.TROPICAL_RED_FERN, 0.4f);
        FOTPlatform.addComposting((class_1935)FOTBlocks.TROPICAL_MONSTERA, 0.3f);
        FOTPlatform.addComposting((class_1935)FOTItems.GUARDIAN_FRUIT, 0.3f);
    }

    private static List<class_3853.class_1652> getFishermanTradesByLevel(int level, List<class_3853.class_1652> list) {
        switch (level) {
            case 1: {
                list.add((class_3853.class_1652)new class_3853.class_4164((class_1935)FOTItems.SPLASHTAIL, 6, 1, FOTItems.COOKED_SPLASHTAIL, 6, 8, 1, 0.05f));
                list.add((class_3853.class_1652)new class_3853.class_4164((class_1935)FOTItems.PONDIE, 6, 1, FOTItems.COOKED_PONDIE, 6, 8, 1, 0.05f));
                list.add((class_3853.class_1652)new class_3853.class_4164((class_1935)FOTItems.ISLEHOPPER, 2, 2, FOTItems.COOKED_ISLEHOPPER, 2, 8, 2, 0.05f));
                list.add((class_3853.class_1652)new class_3853.class_4164((class_1935)FOTItems.ANCIENTSCALE, 3, 1, FOTItems.COOKED_ANCIENTSCALE, 3, 5, 3, 0.05f));
                list.add((class_3853.class_1652)new class_3853.class_4161((class_1935)FOTItems.EARTHWORMS, 48, 8, 10));
                list.add((class_3853.class_1652)new class_3853.class_4161((class_1935)FOTItems.GRUBS, 32, 8, 12));
                list.add((class_3853.class_1652)new class_3853.class_4161((class_1935)FOTItems.LEECHES, 24, 8, 14));
                list.add((class_3853.class_1652)new class_3853.class_4165(FOTItems.SPLASHTAIL_BUCKET, 3, 1, 16, 1));
                list.add((class_3853.class_1652)new class_3853.class_4165(FOTItems.PONDIE_BUCKET, 3, 1, 16, 1));
                list.add((class_3853.class_1652)new class_3853.class_4165(FOTItems.ISLEHOPPER_BUCKET, 3, 1, 16, 1));
                list.add((class_3853.class_1652)new class_3853.class_4165(FOTItems.ANCIENTSCALE_BUCKET, 3, 1, 16, 1));
                break;
            }
            case 2: {
                list.add((class_3853.class_1652)new class_3853.class_4161((class_1935)FOTItems.SPLASHTAIL, 12, 8, 12));
                list.add((class_3853.class_1652)new class_3853.class_4161((class_1935)FOTItems.PONDIE, 12, 8, 12));
                list.add((class_3853.class_1652)new class_3853.class_4161((class_1935)FOTItems.ISLEHOPPER, 8, 8, 15));
                list.add((class_3853.class_1652)new class_3853.class_4161((class_1935)FOTItems.ANCIENTSCALE, 8, 9, 15));
                list.add((class_3853.class_1652)new class_3853.class_4164((class_1935)FOTItems.PLENTIFIN, 3, 2, FOTItems.COOKED_PLENTIFIN, 3, 5, 3, 0.05f));
                list.add((class_3853.class_1652)new class_3853.class_4164((class_1935)FOTItems.WILDSPLASH, 4, 2, FOTItems.COOKED_WILDSPLASH, 4, 6, 3, 0.05f));
                list.add((class_3853.class_1652)new class_3853.class_4164((class_1935)FOTItems.DEVILFISH, 4, 3, FOTItems.COOKED_DEVILFISH, 4, 6, 4, 0.05f));
                list.add((class_3853.class_1652)new class_3853.class_4165(FOTItems.PLENTIFIN_BUCKET, 3, 1, 16, 1));
                list.add((class_3853.class_1652)new class_3853.class_4165(FOTItems.WILDSPLASH_BUCKET, 3, 1, 16, 1));
                list.add((class_3853.class_1652)new class_3853.class_4165(FOTItems.DEVILFISH_BUCKET, 3, 1, 16, 1));
                break;
            }
            case 3: {
                list.add((class_3853.class_1652)new class_3853.class_4161((class_1935)FOTItems.PLENTIFIN, 8, 9, 17));
                list.add((class_3853.class_1652)new class_3853.class_4161((class_1935)FOTItems.WILDSPLASH, 8, 9, 17));
                list.add((class_3853.class_1652)new class_3853.class_4161((class_1935)FOTItems.DEVILFISH, 6, 10, 20));
                break;
            }
            case 4: {
                list.add((class_3853.class_1652)new class_3853.class_4161((class_1935)FOTItems.BATTLEGILL, 6, 10, 20));
                list.add((class_3853.class_1652)new class_3853.class_4161((class_1935)FOTItems.WRECKER, 5, 12, 25));
                list.add((class_3853.class_1652)new class_3853.class_4161((class_1935)FOTItems.STORMFISH, 5, 12, 25));
                break;
            }
            case 5: {
                list.add((class_3853.class_1652)new class_3853.class_4164((class_1935)FOTItems.BATTLEGILL, 4, 3, FOTItems.COOKED_BATTLEGILL, 4, 6, 4, 0.05f));
                list.add((class_3853.class_1652)new class_3853.class_4164((class_1935)FOTItems.WRECKER, 5, 5, FOTItems.COOKED_WRECKER, 5, 8, 5, 0.05f));
                list.add((class_3853.class_1652)new class_3853.class_4164((class_1935)FOTItems.STORMFISH, 5, 5, FOTItems.COOKED_STORMFISH, 5, 8, 8, 0.05f));
                list.add((class_3853.class_1652)new class_3853.class_4165(FOTItems.BATTLEGILL_BUCKET, 6, 1, 8, 2));
                list.add((class_3853.class_1652)new class_3853.class_4165(FOTItems.WRECKER_BUCKET, 6, 1, 8, 2));
                list.add((class_3853.class_1652)new class_3853.class_4165(FOTItems.STORMFISH_BUCKET, 6, 1, 8, 2));
            }
        }
        return list;
    }

    public static class_1761.class_7913 getFishCreativeTabBuilder(class_1761.class_7913 builder) {
        return builder.method_47321((class_2561)class_2561.method_43471((String)"itemGroup.fishofthieves.fish")).method_47320(() -> new class_1799((class_1935)FOTItems.SPLASHTAIL)).method_47317(FOTDisplayItems::displayFishItems);
    }

    public static class_1761.class_7913 getMainCreativeTabBuilder(class_1761.class_7913 builder) {
        return builder.method_47321((class_2561)class_2561.method_43471((String)"itemGroup.fishofthieves.main")).method_47320(() -> new class_1799((class_1935)FOTBlocks.COCONUT_LOG)).method_47317(FOTDisplayItems::displayMainItems);
    }

    public static Int2ObjectOpenHashMap<Function<List<class_3853.class_1652>, List<class_3853.class_1652>>> getFishermanTrades() {
        return (Int2ObjectOpenHashMap)class_156.method_654((Object)new Int2ObjectOpenHashMap(), map -> IntStream.rangeClosed(1, 5).boxed().forEach(level -> map.put(level.intValue(), list -> FishOfThieves.getFishermanTradesByLevel(level, list))));
    }

    public static Map<class_1299<? extends class_1309>, class_5132.class_5133> getEntityAttributes() {
        return (Map)class_156.method_654((Object)Maps.newHashMap(), map -> {
            map.put(FOTEntities.SPLASHTAIL, AbstractSchoolingThievesFish.createAttributes());
            map.put(FOTEntities.PONDIE, AbstractSchoolingThievesFish.createAttributes());
            map.put(FOTEntities.ISLEHOPPER, AbstractSchoolingThievesFish.createAttributes());
            map.put(FOTEntities.ANCIENTSCALE, AbstractSchoolingThievesFish.createAttributes());
            map.put(FOTEntities.PLENTIFIN, AbstractSchoolingThievesFish.createAttributes());
            map.put(FOTEntities.WILDSPLASH, AbstractSchoolingThievesFish.createAttributes());
            map.put(FOTEntities.DEVILFISH, Devilfish.createAttributes());
            map.put(FOTEntities.BATTLEGILL, Battlegill.createAttributes());
            map.put(FOTEntities.WRECKER, Wrecker.createAttributes());
            map.put(FOTEntities.STORMFISH, AbstractSchoolingThievesFish.createAttributes());
        });
    }

    public static List<SpawnPlacementEntry<class_1308>> getSpawnPlacements() {
        return ((ArrayList)class_156.method_654((Object)Lists.newArrayList(), list -> {
            list.add(new SpawnPlacementEntry<Splashtail>(FOTEntities.SPLASHTAIL, class_1480::method_38986));
            list.add(new SpawnPlacementEntry<Pondie>(FOTEntities.PONDIE, class_1480::method_38986));
            list.add(new SpawnPlacementEntry<Islehopper>(FOTEntities.ISLEHOPPER, Islehopper::checkSpawnRules));
            list.add(new SpawnPlacementEntry<Ancientscale>(FOTEntities.ANCIENTSCALE, Ancientscale::checkSpawnRules));
            list.add(new SpawnPlacementEntry<Plentifin>(FOTEntities.PLENTIFIN, Plentifin::checkSpawnRules));
            list.add(new SpawnPlacementEntry<Wildsplash>(FOTEntities.WILDSPLASH, Wildsplash::checkSpawnRules));
            list.add(new SpawnPlacementEntry<Devilfish>(FOTEntities.DEVILFISH, Devilfish::checkSpawnRules));
            list.add(new SpawnPlacementEntry<Battlegill>(FOTEntities.BATTLEGILL, Battlegill::checkSpawnRules));
            list.add(new SpawnPlacementEntry<Wrecker>(FOTEntities.WRECKER, Wrecker::checkSpawnRules));
            list.add(new SpawnPlacementEntry<Stormfish>(FOTEntities.STORMFISH, Stormfish::checkSpawnRules));
        })).stream().map(entry -> entry).toList();
    }

    public record SpawnPlacementEntry<T extends class_1308>(class_1299<T> type, class_1317.class_4306<T> spawnPredicate) {
    }
}

