/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.block;

import com.stevekung.fishofthieves.block.BananaBlossomPlantBlock;
import com.stevekung.fishofthieves.block.BananaClusterPlantBlock;
import com.stevekung.fishofthieves.block.BananaHangingType;
import com.stevekung.fishofthieves.block.BananaLeavesBlock;
import com.stevekung.fishofthieves.block.BananaStemBlock;
import com.stevekung.fishofthieves.block.UnderripeBananaClusterPlantBlock;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2256;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3612;
import net.minecraft.class_3746;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.apache.logging.log4j.util.TriConsumer;

public class BananaClusterGrowableStemBlock
extends BananaStemBlock
implements class_2256 {
    public BananaClusterGrowableStemBlock(class_4970.class_2251 properties) {
        super(properties);
    }

    @Override
    public void method_9514(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        if (level.method_8419() && level.method_8311(pos) && random.method_43048(8) == 0) {
            this.growRandomBananaCluster(level, random, pos);
        }
    }

    @Override
    public class_1799 method_9574(class_4538 level, class_2338 pos, class_2680 state, boolean includeData) {
        return new class_1799((class_1935)FOTBlocks.BANANA_STEM);
    }

    @Override
    public boolean method_9651(class_4538 level, class_2338 pos, class_2680 state) {
        return class_2350.class_2353.field_11062.method_29716().anyMatch(direction -> this.canGrowBananaBunch((class_1922)level, pos, (class_2350)direction));
    }

    @Override
    public boolean method_9650(class_1937 level, class_5819 random, class_2338 pos, class_2680 state) {
        return random.method_43048(level.method_8419() ? 3 : 4) == 0;
    }

    @Override
    public void method_9652(class_3218 level, class_5819 random, class_2338 pos, class_2680 state) {
        this.growRandomBananaCluster(level, random, pos);
    }

    private boolean canGrowBananaBunch(class_1922 level, class_2338 pos, class_2350 direction) {
        class_2680 leavesState = level.method_8320(pos.method_10093(direction));
        if (leavesState.method_27852(FOTBlocks.BANANA_LEAVES)) {
            return leavesState.method_11654(BananaLeavesBlock.TYPE) == BananaLeavesBlock.Type.UPPER && level.method_8320(pos.method_10074().method_10093(direction)).method_26215();
        }
        return false;
    }

    private void growRandomBananaCluster(class_3218 level, class_5819 random, class_2338 pos) {
        class_2350.class_2353.field_11062.method_43342(random).stream().filter(direction -> this.canGrowBananaBunch((class_1922)level, pos, (class_2350)direction)).findFirst().ifPresent(direction -> BananaClusterGrowableStemBlock.growBananaBlossomOrCluster(direction, (class_3746)level, (TriConsumer<class_2338, class_2680, Integer>)((TriConsumer)(arg_0, arg_1, arg_2) -> ((class_3218)level).method_8652(arg_0, arg_1, arg_2)), blockPos -> level.method_8316(blockPos).method_15772() == class_3612.field_15910, random, pos.method_10074().method_10093(direction)));
    }

    public static void growBananaBlossomOrCluster(class_2350 direction, class_3746 level, TriConsumer<class_2338, class_2680, Integer> setBlock, Function<class_2338, Boolean> isWater, class_5819 random, class_2338 pos) {
        int maxY = BananaClusterGrowableStemBlock.findMaxYBelow(level, pos);
        boolean isSmallCluster = false;
        if (maxY == 1) {
            setBlock.accept((Object)pos, (Object)BananaClusterGrowableStemBlock.createBlossomState(direction, isWater.apply(pos), BananaHangingType.STEM), (Object)3);
        } else {
            int yBottom = 0;
            int randHeight = 1 + random.method_43048(maxY);
            for (int i = 0; i < randHeight; ++i) {
                class_2338 blockPos = pos.method_10087(i);
                Predicate<class_2680> stateAbove = state -> level.method_16358(blockPos.method_10084(), blockState -> blockState.method_27852(state.method_26204()));
                class_2680 banana = BananaClusterGrowableStemBlock.selectBananaState(random);
                banana = BananaClusterGrowableStemBlock.updateBananaHangingState(banana, stateAbove, i);
                isSmallCluster |= banana.method_28498(UnderripeBananaClusterPlantBlock.HANGING);
                setBlock.accept((Object)blockPos, (Object)((class_2680)((class_2680)banana.method_11657((class_2769)BananaClusterPlantBlock.field_11177, (Comparable)direction.method_10153())).method_11657((class_2769)BananaClusterPlantBlock.WATERLOGGED, (Comparable)isWater.apply(blockPos))), (Object)3);
                yBottom = Math.max(yBottom, i);
            }
            setBlock.accept((Object)pos.method_10087(yBottom), (Object)BananaClusterGrowableStemBlock.createBlossomState(direction, isWater.apply(pos.method_10087(yBottom)), BananaClusterGrowableStemBlock.determineHangingType(yBottom, isSmallCluster)), (Object)3);
        }
    }

    private static class_2680 createBlossomState(class_2350 direction, boolean isWaterlogged, BananaHangingType hangingType) {
        return (class_2680)((class_2680)((class_2680)FOTBlocks.BANANA_BLOSSOM_PLANT.method_9564().method_11657(BananaBlossomPlantBlock.FACING, (Comparable)direction.method_10153())).method_11657(BananaBlossomPlantBlock.HANGING, (Comparable)((Object)hangingType))).method_11657((class_2769)BananaBlossomPlantBlock.WATERLOGGED, (Comparable)Boolean.valueOf(isWaterlogged));
    }

    private static class_2680 selectBananaState(class_5819 random) {
        return random.method_43057() < 0.2f ? FOTBlocks.RIPE_BANANA_CLUSTER_PLANT.method_9564() : (random.method_43057() < 0.4f ? FOTBlocks.BARELY_RIPE_BANANA_CLUSTER_PLANT.method_9564() : FOTBlocks.UNDERRIPE_BANANA_CLUSTER_PLANT.method_9564());
    }

    private static class_2680 updateBananaHangingState(class_2680 banana, Predicate<class_2680> stateAbove, int i) {
        if (banana.method_28498(BananaClusterPlantBlock.HANGING)) {
            banana = (class_2680)banana.method_11657(BananaClusterPlantBlock.HANGING, (Comparable)((Object)(i == 0 ? BananaClusterPlantBlock.HangingType.STEM : BananaClusterPlantBlock.HangingType.NONE)));
            if (stateAbove.test(FOTBlocks.UNDERRIPE_BANANA_CLUSTER_PLANT.method_9564())) {
                banana = (class_2680)banana.method_11657(BananaClusterPlantBlock.HANGING, (Comparable)((Object)BananaClusterPlantBlock.HangingType.SMALL_CLUSTER));
            }
        } else if (banana.method_28498(UnderripeBananaClusterPlantBlock.HANGING)) {
            boolean isLargeCluster;
            boolean bl = isLargeCluster = stateAbove.test(FOTBlocks.RIPE_BANANA_CLUSTER_PLANT.method_9564()) || stateAbove.test(FOTBlocks.BARELY_RIPE_BANANA_CLUSTER_PLANT.method_9564());
            banana = (class_2680)banana.method_11657(UnderripeBananaClusterPlantBlock.HANGING, (Comparable)((Object)(i == 0 ? BananaHangingType.STEM : (isLargeCluster ? BananaHangingType.CLUSTER : BananaHangingType.SMALL_CLUSTER))));
        }
        return banana;
    }

    private static BananaHangingType determineHangingType(int yBottom, boolean isSmallCluster) {
        return yBottom == 0 ? BananaHangingType.STEM : (isSmallCluster ? BananaHangingType.SMALL_CLUSTER : BananaHangingType.CLUSTER);
    }

    private static int findMaxYBelow(class_3746 level, class_2338 pos) {
        int maxY;
        for (maxY = 0; level.method_16358(pos.method_10087(maxY), class_4970.class_4971::method_45474) && maxY < 6; ++maxY) {
        }
        return maxY;
    }
}

