/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.block;

import com.stevekung.fishofthieves.FOTPlatform;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTItems;
import com.stevekung.fishofthieves.registry.FOTTags;
import java.util.stream.Stream;
import net.minecraft.class_10774;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1584;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_247;
import net.minecraft.class_2498;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2756;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class PineappleCropBlock
extends class_2320
implements class_2256 {
    public static final class_2758 AGE = class_2758.method_11867((String)"age", (int)0, (int)5);
    private static final class_265 BASE_SHAPE = class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0);
    private static final class_265 STAGE_3_SHAPE = class_259.method_1072((class_265)class_2248.method_9541((double)6.5, (double)9.0, (double)6.5, (double)9.5, (double)12.0, (double)9.5), (class_265)BASE_SHAPE, (class_247)class_247.field_1366);
    private static final class_265 STAGE_4_COLLISION_SHAPE = class_2248.method_9541((double)5.0, (double)-7.0, (double)5.0, (double)11.0, (double)1.0, (double)11.0);
    private static final class_265 STAGE_4_LOWER_SHAPE = class_259.method_1072((class_265)class_2248.method_9541((double)5.0, (double)9.0, (double)5.0, (double)11.0, (double)17.0, (double)11.0), (class_265)BASE_SHAPE, (class_247)class_247.field_1366);
    private static final class_265 STAGE_4_SHAPE = class_259.method_1072((class_265)STAGE_4_COLLISION_SHAPE, (class_265)class_2248.method_9541((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)5.0, (double)11.0), (class_247)class_247.field_1366);
    private static final class_265 STAGE_5_COLLISION_SHAPE = class_259.method_1072((class_265)class_2248.method_9541((double)6.0, (double)-7.0, (double)6.0, (double)10.0, (double)-6.0, (double)10.0), (class_265)class_2248.method_9541((double)4.0, (double)-6.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0), (class_247)class_247.field_1366);
    private static final class_265 STAGE_5_LOWER_SHAPE = Stream.of(class_2248.method_9541((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0), class_2248.method_9541((double)4.0, (double)10.0, (double)4.0, (double)12.0, (double)20.0, (double)12.0), BASE_SHAPE).reduce((v1, v2) -> class_259.method_1072((class_265)v1, (class_265)v2, (class_247)class_247.field_1366)).get();
    private static final class_265 STAGE_5_SHAPE = Stream.of(STAGE_5_COLLISION_SHAPE, class_2248.method_9541((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)11.0, (double)12.0)).reduce((v1, v2) -> class_259.method_1072((class_265)v1, (class_265)v2, (class_247)class_247.field_1366)).get();

    public PineappleCropBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)AGE, (Comparable)Integer.valueOf(0))).method_11657((class_2769)field_10929, (Comparable)class_2756.field_12607));
    }

    private int getMaxAge() {
        return 5;
    }

    private boolean isLowerAge(class_2680 state) {
        return (Integer)state.method_11654((class_2769)AGE) < this.getMaxAge();
    }

    public boolean method_9542(class_2680 state) {
        return state.method_11654((class_2769)field_10929) == class_2756.field_12607 && this.isLowerAge(state);
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        return this.method_9564();
    }

    public class_265 method_9549(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        int age = (Integer)state.method_11654((class_2769)AGE);
        if (state.method_11654((class_2769)field_10929) == class_2756.field_12609) {
            if (age == 4) {
                return STAGE_4_COLLISION_SHAPE;
            }
            if (age == 5) {
                return STAGE_5_COLLISION_SHAPE;
            }
        }
        return super.method_9549(state, level, pos, context);
    }

    public float method_9594(class_2680 state, class_1657 player, class_1922 level, class_2338 pos) {
        if (!PineappleCropBlock.isLower(state) && (Integer)state.method_11654((class_2769)AGE) >= 4) {
            float destroySpeed = 0.6f;
            int i = player.method_7305(state) ? 30 : 100;
            return player.method_7351(state) / destroySpeed / (float)i;
        }
        return super.method_9594(state, player, level, pos);
    }

    public class_2498 method_9573(class_2680 state) {
        Integer age;
        if (state.method_11654((class_2769)field_10929) == class_2756.field_12609 && (age = (Integer)state.method_11654((class_2769)AGE)) >= 4) {
            return class_2498.field_11547;
        }
        return super.method_9573(state);
    }

    public boolean method_9558(class_2680 state, class_4538 level, class_2338 pos) {
        if (!PineappleCropBlock.sufficientLight(level, pos)) {
            return false;
        }
        return super.method_9558(state, level, pos);
    }

    protected boolean method_9695(class_2680 state, class_1922 level, class_2338 pos) {
        return state.method_27852(class_2246.field_10362) || state.method_26164(class_3481.field_29822);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder.method_11667(new class_2769[]{AGE}));
    }

    public class_2680 method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        Integer age = (Integer)state.method_11654((class_2769)AGE);
        if (!level.method_8608() && age >= 4 && class_1890.method_60138((class_1799)player.method_6047(), FOTTags.Enchantments.DROP_PINEAPPLE_BLOCK_WHEN_MINING)) {
            PineappleCropBlock.method_30036((class_1937)level, (class_2338)pos, (class_2680)state, (class_1657)player);
        }
        return super.method_9576(level, pos, state, player);
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        int age = (Integer)state.method_11654((class_2769)AGE);
        if (age == 3) {
            return STAGE_3_SHAPE;
        }
        if (age == 4) {
            return state.method_11654((class_2769)field_10929) == class_2756.field_12609 ? STAGE_4_SHAPE : STAGE_4_LOWER_SHAPE;
        }
        if (age == 5) {
            return state.method_11654((class_2769)field_10929) == class_2756.field_12609 ? STAGE_5_SHAPE : STAGE_5_LOWER_SHAPE;
        }
        return BASE_SHAPE;
    }

    public void method_9548(class_2680 state, class_1937 level, class_2338 pos, class_1297 entity, class_10774 insideBlockEffectApplier) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            if (entity instanceof class_1584 && serverLevel.method_64395().method_8355(class_1928.field_19388)) {
                serverLevel.method_8651(pos, true, entity);
            }
        }
        super.method_9548(state, level, pos, entity, insideBlockEffectApplier);
    }

    public boolean method_9616(class_2680 state, class_1750 useContext) {
        return false;
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, class_1309 placer, class_1799 stack) {
    }

    public void method_9514(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        float growthSpeed = FOTPlatform.getGrowthSpeedFromCropBlock(this.method_9564(), level, pos);
        if (random.method_43048((int)(25.0f / growthSpeed) + 1) == 0) {
            this.grow(level, state, pos, 1);
        }
    }

    private void grow(class_3218 level, class_2680 state, class_2338 pos, int growthAge) {
        int age = Math.min((Integer)state.method_11654((class_2769)AGE) + growthAge, this.getMaxAge());
        if (this.canGrow((class_4538)level, pos, state, age)) {
            level.method_8652(pos, (class_2680)state.method_11657((class_2769)AGE, (Comparable)Integer.valueOf(age)), 2);
            if (age >= 4) {
                class_2338 blockPos = pos.method_10084();
                level.method_8652(blockPos, PineappleCropBlock.method_37458((class_4538)level, (class_2338)pos, (class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)AGE, (Comparable)Integer.valueOf(age))).method_11657((class_2769)field_10929, (Comparable)class_2756.field_12609))), 3);
            }
        }
    }

    private static boolean canGrowInto(class_4538 level, class_2338 pos) {
        class_2680 blockState = level.method_8320(pos);
        return blockState.method_26215() || blockState.method_27852(FOTBlocks.PINEAPPLE_CROP);
    }

    private static boolean sufficientLight(class_4538 level, class_2338 pos) {
        return level.method_22335(pos, 0) >= 8 || level.method_8311(pos);
    }

    private static boolean isLower(class_2680 state) {
        return state.method_27852(FOTBlocks.PINEAPPLE_CROP) && state.method_11654((class_2769)field_10929) == class_2756.field_12607;
    }

    private boolean canGrow(class_4538 reader, class_2338 pos, class_2680 state, int age) {
        return this.isLowerAge(state) && PineappleCropBlock.sufficientLight(reader, pos) && (age < 4 || PineappleCropBlock.canGrowInto(reader, pos.method_10084()));
    }

    @Nullable
    private PosAndState getLowerHalf(class_4538 level, class_2338 pos, class_2680 state) {
        if (PineappleCropBlock.isLower(state)) {
            return new PosAndState(pos, state);
        }
        class_2338 blockPos = pos.method_10074();
        class_2680 blockState = level.method_8320(blockPos);
        return PineappleCropBlock.isLower(blockState) ? new PosAndState(blockPos, blockState) : null;
    }

    public boolean method_9651(class_4538 level, class_2338 pos, class_2680 state) {
        PosAndState posAndState = this.getLowerHalf(level, pos, state);
        return posAndState != null && this.canGrow(level, posAndState.pos, posAndState.state, (Integer)posAndState.state.method_11654((class_2769)AGE) + 1);
    }

    public boolean method_9650(class_1937 level, class_5819 random, class_2338 pos, class_2680 state) {
        return true;
    }

    public void method_9652(class_3218 level, class_5819 random, class_2338 pos, class_2680 state) {
        PosAndState posAndState = this.getLowerHalf((class_4538)level, pos, state);
        if (posAndState != null) {
            this.grow(level, posAndState.state, posAndState.pos, class_3532.method_15395((class_5819)random, (int)1, (int)2));
        }
    }

    public class_1799 method_9574(class_4538 level, class_2338 pos, class_2680 state, boolean includeData) {
        if (state.method_11654((class_2769)field_10929) == class_2756.field_12609) {
            return (Integer)state.method_11654((class_2769)AGE) == 5 ? new class_1799((class_1935)FOTBlocks.RIPE_PINEAPPLE_BLOCK) : ((Integer)state.method_11654((class_2769)AGE) == 4 ? new class_1799((class_1935)FOTBlocks.UNDERRIPE_PINEAPPLE_BLOCK) : new class_1799((class_1935)FOTItems.PINEAPPLE_CROWN));
        }
        return (Integer)state.method_11654((class_2769)AGE) == 0 ? new class_1799((class_1935)FOTItems.PINEAPPLE_SEEDS) : new class_1799((class_1935)FOTItems.PINEAPPLE_CROWN);
    }

    record PosAndState(class_2338 pos, class_2680 state) {
    }
}

