/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.PartyFish;
import com.stevekung.fishofthieves.entity.VariantHolder;
import com.stevekung.fishofthieves.entity.variant.AbstractFishVariant;
import com.stevekung.fishofthieves.item.FOTItem;
import com.stevekung.fishofthieves.registry.FOTMemoryModuleTypes;
import com.stevekung.fishofthieves.registry.FOTTags;
import java.util.Optional;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_3730;
import net.minecraft.class_4095;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_9279;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public interface ThievesFish<T extends AbstractFishVariant>
extends PartyFish,
VariantHolder<class_6880<T>> {
    public static final class_6862<class_1792> WORMS = FOTTags.Items.WORMS;
    public static final class_6862<class_1792> EARTHWORMS_FOOD = FOTTags.Items.EARTHWORMS_FOOD;
    public static final class_6862<class_1792> GRUBS_FOOD = FOTTags.Items.GRUBS_FOOD;
    public static final class_6862<class_1792> LEECHES_FOOD = FOTTags.Items.LEECHES_FOOD;
    public static final String VARIANT_TAG = "variant";
    public static final String TROPHY_TAG = "Trophy";
    public static final String HAS_FED_TAG = "HasFed";
    public static final String NO_FLIP_TAG = "NoFlip";

    public class_5321<? extends class_2378<T>> getRegistryKey();

    public class_5321<T> getDefaultKey();

    public boolean isTrophy();

    public void setTrophy(boolean var1);

    public boolean hasFed();

    public void setHasFed(boolean var1);

    public boolean isFood(class_1799 var1);

    public void setNoFlip(boolean var1);

    public boolean isNoFlip();

    default public float getGlowBrightness(float ageInTicks) {
        return 1.0f;
    }

    default public boolean isFishBreached(class_4095<?> brain) {
        return brain.method_18896(FOTMemoryModuleTypes.BREACHED_TICK) && (Integer)brain.method_18904(FOTMemoryModuleTypes.BREACHED_TICK).get() > 0;
    }

    default public void saveToBucket(class_1799 bucket) {
        if (FishOfThieves.CONFIG.general.enableFishItemWithAllVariant) {
            bucket.method_57379(class_9334.field_49637, (Object)FOTItem.createCustomModelData(((AbstractFishVariant)((class_6880)this.getVariant()).comp_349()).customModelData()));
        }
        class_9279.method_57452((class_9331)class_9334.field_49610, (class_1799)bucket, compoundTag -> {
            if (this.isTrophy()) {
                compoundTag.method_10556(HAS_FED_TAG, this.hasFed());
                compoundTag.method_10556(TROPHY_TAG, this.isTrophy());
            }
            if (this.isNoFlip()) {
                compoundTag.method_10556(NO_FLIP_TAG, this.isNoFlip());
            }
        });
    }

    default public void loadFromBucket(class_2487 compound) {
        compound.method_10577(TROPHY_TAG).ifPresent(this::setTrophy);
        compound.method_10577(HAS_FED_TAG).ifPresent(this::setHasFed);
        compound.method_10577(NO_FLIP_TAG).ifPresent(this::setNoFlip);
    }

    default public class_1315 defaultFinalizeSpawn(class_5425 accessor, class_1309 livingEntity, class_3730 entitySpawnReason, @Nullable class_1315 spawnData) {
        class_6880<T> holder = AbstractFishVariant.getSpawnVariant(accessor.method_8410(), accessor.method_30349(), this.getRegistryKey(), this.getDefaultKey(), livingEntity, entitySpawnReason == class_3730.field_16473);
        this.setVariant(holder);
        if (livingEntity.method_59922().method_43057() < FishOfThieves.CONFIG.spawnRate.trophyProbability) {
            this.setTrophy(true);
            livingEntity.method_6033(FishOfThieves.CONFIG.general.trophyMaxHealth);
        }
        return spawnData;
    }

    default public void setRandomVariant(class_5455 registryAccess, class_5819 randomSource) {
        class_2378 registry = registryAccess.method_30530(this.getRegistryKey());
        Optional muha = class_156.method_40083(registry.method_42017().toList(), (class_5819)randomSource);
        this.setVariant((class_6880)muha.orElseGet(() -> registry.method_46747(this.getDefaultKey())));
        this.setTrophy(randomSource.method_43056());
    }
}

