/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.feature.stateproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.registry.FOTBlockStateProviderTypes;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_4651;
import net.minecraft.class_4652;
import net.minecraft.class_5819;
import net.minecraft.class_5862;
import net.minecraft.class_6017;
import org.jetbrains.annotations.Nullable;

public class RandomizedIntBooleanStateProvider
extends class_4651 {
    public static final MapCodec<RandomizedIntBooleanStateProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_4651.field_24937.fieldOf("source").forGetter(provider -> provider.source), (App)Codec.STRING.fieldOf("integer_property").forGetter(provider -> provider.integerPropertyName), (App)class_6017.field_29946.fieldOf("integer_values").forGetter(provider -> provider.integerValues), (App)Codec.STRING.fieldOf("boolean_property").forGetter(provider -> provider.booleanPropertyName), (App)class_5862.field_29004.fieldOf("boolean_chance").forGetter(provider -> provider.booleanChance)).apply((Applicative)instance, RandomizedIntBooleanStateProvider::new));
    private final class_4651 source;
    private final String integerPropertyName;
    @Nullable
    private class_2758 integerProperty;
    private final class_6017 integerValues;
    private final String booleanPropertyName;
    @Nullable
    private class_2746 booleanProperty;
    private final class_5862 booleanChance;

    public RandomizedIntBooleanStateProvider(class_4651 source, class_2758 integerProperty, class_6017 integerValues, class_2746 booleanProperty, class_5862 booleanChance) {
        this.source = source;
        this.integerProperty = integerProperty;
        this.integerPropertyName = integerProperty.method_11899();
        this.integerValues = integerValues;
        this.booleanProperty = booleanProperty;
        this.booleanPropertyName = booleanProperty.method_11899();
        this.booleanChance = booleanChance;
        List collection = integerProperty.method_11898();
        for (int i = integerValues.method_35009(); i <= integerValues.method_35011(); ++i) {
            if (collection.contains(i)) continue;
            throw new IllegalArgumentException("Property value out of range: " + integerProperty.method_11899() + ": " + i);
        }
    }

    public RandomizedIntBooleanStateProvider(class_4651 source, String integerPropertyName, class_6017 integerValues, String booleanPropertyName, class_5862 booleanChance) {
        this.source = source;
        this.integerPropertyName = integerPropertyName;
        this.integerValues = integerValues;
        this.booleanPropertyName = booleanPropertyName;
        this.booleanChance = booleanChance;
    }

    protected class_4652<?> method_28862() {
        return FOTBlockStateProviderTypes.RANDOMIZED_INT_BOOLEAN_STATE_PROVIDER;
    }

    public class_2680 method_23455(class_5819 random, class_2338 pos) {
        class_2680 blockState = this.source.method_23455(random, pos);
        if (this.integerProperty == null || !blockState.method_28498((class_2769)this.integerProperty)) {
            this.integerProperty = RandomizedIntBooleanStateProvider.findProperty(blockState, this.integerPropertyName, class_2758.class);
        }
        if (this.booleanProperty == null || !blockState.method_28498((class_2769)this.booleanProperty)) {
            this.booleanProperty = RandomizedIntBooleanStateProvider.findProperty(blockState, this.booleanPropertyName, class_2746.class);
        }
        return (class_2680)((class_2680)blockState.method_11657((class_2769)this.integerProperty, (Comparable)Integer.valueOf(this.integerValues.method_35008(random)))).method_11657((class_2769)this.booleanProperty, (Comparable)Boolean.valueOf(random.method_43057() < this.booleanChance.method_33914()));
    }

    private static <T extends class_2769<?>> T findProperty(class_2680 state, String propertyName, Class<T> propertyClass) {
        Collection collection = state.method_28501();
        Optional<class_2769> optional = collection.stream().filter(property -> property.method_11899().equals(propertyName)).filter(propertyClass::isInstance).map(propertyClass::cast).findAny();
        return (T)optional.orElseThrow(() -> new IllegalArgumentException("Illegal property: " + propertyName));
    }
}

