/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.client.renderer;

import com.stevekung.fishofthieves.client.model.HeadphoneModel;
import com.stevekung.fishofthieves.client.renderer.entity.layers.GlowFishLayer;
import com.stevekung.fishofthieves.client.renderer.entity.layers.HeadphoneLayer;
import com.stevekung.fishofthieves.client.renderer.entity.state.ThievesFishRenderState;
import com.stevekung.fishofthieves.entity.ThievesFish;
import com.stevekung.fishofthieves.entity.VariantHolder;
import com.stevekung.fishofthieves.entity.variant.AbstractFishVariant;
import java.util.function.Consumer;
import net.minecraft.class_1422;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_6880;
import net.minecraft.class_7833;
import net.minecraft.class_922;
import net.minecraft.class_927;
import org.joml.Quaternionfc;

public abstract class ThievesFishRenderer<V extends AbstractFishVariant, S extends ThievesFishRenderState, T extends class_1422 & VariantHolder<class_6880<V>>, M extends class_583<S>>
extends class_927<T, S, M> {
    protected ThievesFishRenderer(class_5617.class_5618 context, M entityModel) {
        super(context, entityModel, 0.15f);
        this.method_4046(new GlowFishLayer(this));
        this.method_4046(new HeadphoneLayer((class_922<?, ?, ?>)this, context.method_32170(), (HeadphoneModel.Scaleable)entityModel));
    }

    public void render(S renderState, class_4587 poseStack, class_4597 buffer, int packedLight) {
        this.field_4673 = ((ThievesFishRenderState)((Object)renderState)).isTrophy ? 0.25f : 0.15f;
        super.method_4054(renderState, poseStack, buffer, packedLight);
    }

    public S createRenderState() {
        return (S)((Object)new ThievesFishRenderState());
    }

    public void extractRenderState(T entity, S renderState, float partialTicks) {
        super.method_62355(entity, renderState, partialTicks);
        AbstractFishVariant variant = (AbstractFishVariant)((class_6880)((VariantHolder)entity).getVariant()).comp_349();
        ((ThievesFishRenderState)((Object)renderState)).isTrophy = ((ThievesFish)entity).isTrophy();
        ((ThievesFishRenderState)((Object)renderState)).isNoFlip = ((ThievesFish)entity).isNoFlip();
        ((ThievesFishRenderState)((Object)renderState)).hasImpulse = ((class_1422)entity).field_6007;
        ((ThievesFishRenderState)((Object)renderState)).fullTexture = variant.fullTexture();
        ((ThievesFishRenderState)((Object)renderState)).fullGlowTexture = variant.fullGlowTexture().orElse(null);
        ((ThievesFishRenderState)((Object)renderState)).glowBrightness = ((ThievesFish)entity).getGlowBrightness(((ThievesFishRenderState)((Object)renderState)).field_53328);
    }

    protected void setupRotations(S renderState, class_4587 poseStack, float bodyRot, float scale) {
        super.method_4058(renderState, poseStack, bodyRot, scale);
        boolean inWater = ((ThievesFishRenderState)((Object)renderState)).field_53458 || ((ThievesFishRenderState)((Object)renderState)).isNoFlip;
        RotationRenderData rotationRenderData = this.setupRotations(renderState, inWater);
        float degree = rotationRenderData.baseDegree * class_3532.method_15374((float)(rotationRenderData.bodyRotBase * rotationRenderData.bodyRotSpeed * ((ThievesFishRenderState)((Object)renderState)).field_53328));
        poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(degree));
        if (!inWater) {
            rotationRenderData.translateConsumer.accept(poseStack);
            poseStack.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(90.0f));
        }
        this.doFishPitchYaw(renderState, poseStack);
    }

    public class_2960 getTextureLocation(S renderState) {
        return ((ThievesFishRenderState)((Object)renderState)).fullTexture;
    }

    protected void scale(S livingEntity, class_4587 poseStack) {
        float scale = ((ThievesFishRenderState)((Object)livingEntity)).isTrophy ? 1.0f : 0.5f;
        poseStack.method_22905(scale, scale, scale);
    }

    private void doFishPitchYaw(S renderState, class_4587 poseStack) {
        if (!((ThievesFishRenderState)((Object)renderState)).hasImpulse) {
            poseStack.method_22907((Quaternionfc)class_7833.field_40714.rotation(((ThievesFishRenderState)((Object)renderState)).field_53448 * ((float)(-Math.PI) / 180)));
        }
    }

    public abstract RotationRenderData setupRotations(S var1, boolean var2);

    public record RotationRenderData(float bodyRotBase, float bodyRotSpeed, float baseDegree, Consumer<class_4587> translateConsumer) {
        public static RotationRenderData create(float bodyRotBase, float bodyRotSpeed, float baseDegree, Consumer<class_4587> translateConsumer) {
            return new RotationRenderData(bodyRotBase, bodyRotSpeed, baseDegree, translateConsumer);
        }
    }
}

