/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity;

import com.google.common.collect.ImmutableList;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.ThievesFish;
import com.stevekung.fishofthieves.entity.ai.AbstractThievesFishAi;
import com.stevekung.fishofthieves.entity.variant.AbstractFishVariant;
import com.stevekung.fishofthieves.registry.FOTMemoryModuleTypes;
import com.stevekung.fishofthieves.registry.FOTSensorTypes;
import net.minecraft.class_10704;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1332;
import net.minecraft.class_1422;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4538;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5757;
import net.minecraft.class_6880;
import net.minecraft.class_9331;
import net.minecraft.class_9473;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractThievesFish<T extends AbstractFishVariant>
extends class_1422
implements ThievesFish<T> {
    private static final class_2940<Boolean> TROPHY = class_2945.method_12791(AbstractThievesFish.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> HAS_FED = class_2945.method_12791(AbstractThievesFish.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> NO_FLIP = class_2945.method_12791(AbstractThievesFish.class, (class_2941)class_2943.field_13323);
    protected static final ImmutableList<class_4149<? extends class_4148<? super AbstractThievesFish<?>>>> SENSOR_TYPES = ImmutableList.of((Object)class_4149.field_18466, FOTSensorTypes.NON_CREATIVE_NEAREST_PLAYERS, FOTSensorTypes.NEAREST_MAGMA_BLOCK, (Object)class_4149.field_18469);
    protected static final ImmutableList<class_4140<?>> MEMORY_TYPES = ImmutableList.of((Object)class_4140.field_18446, (Object)class_4140.field_18445, (Object)class_4140.field_18441, (Object)class_4140.field_18442, (Object)class_4140.field_19293, (Object)class_4140.field_18449, (Object)class_4140.field_22474, (Object)class_4140.field_18444, (Object)class_4140.field_22357, (Object)class_4140.field_28326, (Object)class_4140.field_28327, (Object)class_4140.field_28325, (Object[])new class_4140[]{class_4140.field_18448, class_4140.field_39408, class_4140.field_30244, FOTMemoryModuleTypes.BREACHED_TICK});
    private final class_5321<? extends class_2378<T>> registryKey;
    private final class_5321<T> resourceKey;
    private final class_9331<class_6880<T>> dataComponentType;

    public AbstractThievesFish(class_1299<? extends class_1422> entityType, class_1937 level, class_5321<? extends class_2378<T>> registryKey, class_5321<T> resourceKey, class_9331<class_6880<T>> dataComponentType) {
        super(entityType, level);
        this.method_18382();
        this.registryKey = registryKey;
        this.resourceKey = resourceKey;
        this.dataComponentType = dataComponentType;
        this.field_6207 = new class_5757((class_1308)this, 85, 10, 0.02f, 0.1f, true);
        this.field_6206 = new class_1332((class_1308)this, 10);
    }

    @Override
    public class_5321<? extends class_2378<T>> getRegistryKey() {
        return this.registryKey;
    }

    @Override
    public class_5321<T> getDefaultKey() {
        return this.resourceKey;
    }

    @Nullable
    public <T2> T2 method_58694(class_9331<? extends T2> dataComponentType) {
        return (T2)(dataComponentType == this.dataComponentType ? AbstractThievesFish.method_66651(dataComponentType, (Object)this.getVariant()) : super.method_58694(dataComponentType));
    }

    protected void method_66649(class_9473 dataComponentGetter) {
        class_6880 object = (class_6880)dataComponentGetter.method_58694(this.dataComponentType);
        if (object == null) {
            this.setRandomVariant(this.method_56673(), this.method_59922());
        } else {
            this.method_66650(dataComponentGetter, this.dataComponentType);
        }
        super.method_66649(dataComponentGetter);
    }

    protected <T2> boolean method_66654(class_9331<T2> dataComponentType, T2 object) {
        if (dataComponentType == this.dataComponentType) {
            this.setVariant((class_6880)AbstractThievesFish.method_66651(this.dataComponentType, object));
            return true;
        }
        return super.method_66654(dataComponentType, object);
    }

    protected void method_5959() {
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(TROPHY, (Object)false);
        builder.method_56912(HAS_FED, (Object)false);
        builder.method_56912(NO_FLIP, (Object)false);
    }

    public void method_5652(class_11372 valueOutput) {
        super.method_5652(valueOutput);
        class_10704.method_67177((class_11372)valueOutput, (class_6880)((class_6880)this.getVariant()));
        valueOutput.method_71472("Trophy", this.isTrophy());
        valueOutput.method_71472("HasFed", this.hasFed());
        valueOutput.method_71472("NoFlip", this.isNoFlip());
    }

    public void method_5749(class_11368 valueInput) {
        super.method_5749(valueInput);
        class_10704.method_67178((class_11368)valueInput, this.getRegistryKey()).ifPresent(this::setVariant);
        this.setTrophy(valueInput.method_71433("Trophy", false));
        this.setHasFed(valueInput.method_71433("HasFed", false));
        this.setNoFlip(valueInput.method_71433("NoFlip", false));
        AbstractThievesFishAi.initMemories(this);
    }

    public void method_6455(class_1799 itemStack) {
        super.method_6455(itemStack);
        itemStack.method_66697(this.dataComponentType, (class_9473)this);
        this.saveToBucket(itemStack);
    }

    public void method_35170(class_2487 compound) {
        super.method_35170(compound);
        this.loadFromBucket(compound);
    }

    public float method_6144(class_2338 blockPos, class_4538 level) {
        if (AbstractThievesFishAi.isPosNearNearestRepellent(this, blockPos)) {
            return -1.0f;
        }
        return super.method_6144(blockPos, level);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (this.isFood(itemStack) && !this.isTrophy() && !this.hasFed()) {
            if (!this.method_37908().method_8608()) {
                this.growUp(player, itemStack);
            }
            this.method_37908().method_8406((class_2394)class_2398.field_11211, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), 0.0, 0.0, 0.0);
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    @Nullable
    public class_1315 method_5943(class_5425 accessor, class_1266 difficulty, class_3730 entitySpawnReason, @Nullable class_1315 spawnGroupData) {
        if (entitySpawnReason == class_3730.field_16473) {
            return spawnGroupData;
        }
        spawnGroupData = super.method_5943(accessor, difficulty, entitySpawnReason, spawnGroupData);
        return this.defaultFinalizeSpawn(accessor, (class_1309)this, entitySpawnReason, spawnGroupData);
    }

    public void method_5674(class_2940<?> key) {
        if (TROPHY.equals(key)) {
            this.method_18382();
        }
        super.method_5674(key);
    }

    protected void method_5958(class_3218 level) {
        super.method_5958(level);
        this.setNoFlip(!this.field_6007 && this.isFishBreached(this.method_18868()));
    }

    @Override
    public boolean isTrophy() {
        return (Boolean)this.field_6011.method_12789(TROPHY);
    }

    @Override
    public void setTrophy(boolean trophy) {
        if (trophy) {
            this.method_5996(class_5134.field_23716).method_6192((double)FishOfThieves.CONFIG.general.trophyMaxHealth);
        }
        this.field_6011.method_12778(TROPHY, (Object)trophy);
    }

    @Override
    public boolean hasFed() {
        return (Boolean)this.field_6011.method_12789(HAS_FED);
    }

    @Override
    public void setHasFed(boolean hasFed) {
        this.field_6011.method_12778(HAS_FED, (Object)hasFed);
    }

    @Override
    public void setNoFlip(boolean noFlip) {
        this.field_6011.method_12778(NO_FLIP, (Object)noFlip);
    }

    @Override
    public boolean isNoFlip() {
        return (Boolean)this.field_6011.method_12789(NO_FLIP);
    }

    private void growUp(class_1657 player, class_1799 itemStack) {
        if (!player.method_31549().field_7477) {
            itemStack.method_7934(1);
        }
        if (this.field_5974.method_43048(10) == 0) {
            this.setTrophy(true);
            this.setHasFed(true);
            this.method_6033(FishOfThieves.CONFIG.general.trophyMaxHealth);
        }
    }
}

