/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.loot.predicate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.loot.predicate.StructureRangeCondition;
import com.stevekung.fishofthieves.utils.Continentalness;
import com.stevekung.fishofthieves.utils.PeakTypes;
import com.stevekung.fishofthieves.utils.TerrainUtils;
import java.util.Iterator;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3449;
import net.minecraft.class_4076;
import net.minecraft.class_6016;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import org.jetbrains.annotations.Nullable;

public record FOTLocationPredicate(Optional<Continentalness> continentalness, Optional<PeakTypes> peakType, Optional<Boolean> hasRaids, Optional<StructureRangeCondition> structureRangeCondition) {
    public static final Codec<FOTLocationPredicate> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Continentalness.CODEC.optionalFieldOf("continentalness").forGetter(FOTLocationPredicate::continentalness), (App)PeakTypes.CODEC.optionalFieldOf("peak_type").forGetter(FOTLocationPredicate::peakType), (App)Codec.BOOL.optionalFieldOf("has_raids").forGetter(FOTLocationPredicate::hasRaids), (App)StructureRangeCondition.CODEC.optionalFieldOf("structure_range").forGetter(FOTLocationPredicate::structureRangeCondition)).apply((Applicative)instance, FOTLocationPredicate::new));

    public boolean matches(class_3218 level, @Nullable class_1297 entity, double x, double y, double z) {
        class_2338 blockPos = class_2338.method_49637((double)x, (double)y, (double)z);
        boolean loaded = level.method_8477(blockPos);
        boolean isRaided = level.method_19503(blockPos);
        return (this.structureRangeCondition.isEmpty() || loaded && this.isInRangeOfStructures(level, blockPos, entity, this.structureRangeCondition.get())) && (this.continentalness.isEmpty() || loaded && this.continentalness.get() == TerrainUtils.getContinentalness(level, blockPos)) && (this.hasRaids.isEmpty() || loaded && this.hasRaids.get() == isRaided);
    }

    private boolean isInRangeOfStructures(class_3218 level, class_2338 blockPos, @Nullable class_1297 entity, StructureRangeCondition structureRangeCondition) {
        for (class_6880 structureHolder : structureRangeCondition.structures().method_40239().toList()) {
            class_3195 structure = (class_3195)structureHolder.comp_349();
            boolean isInsideStructure = level.method_27056().method_38854(blockPos, structure).method_16657();
            if (entity == null) {
                return isInsideStructure;
            }
            if (isInsideStructure) {
                return true;
            }
            Iterator iterator = level.method_27056().method_38853(class_4076.method_18682((class_2338)blockPos), structure).iterator();
            if (!iterator.hasNext()) continue;
            class_3449 structureStart = (class_3449)iterator.next();
            Integer entityDist = structureStart.method_14963().stream().map(structurePiece -> structurePiece.method_14935().method_22874().method_19455((class_2382)entity.method_24515())).findAny().orElse(Integer.MAX_VALUE);
            return entityDist < structureRangeCondition.range().method_34997();
        }
        return false;
    }

    public static class Builder {
        private Optional<Continentalness> continentalness = Optional.empty();
        private Optional<PeakTypes> peakType = Optional.empty();
        private Optional<Boolean> hasRaids = Optional.empty();
        private Optional<StructureRangeCondition> structureRangeCondition = Optional.empty();

        public static Builder location() {
            return new Builder();
        }

        public Builder setContinentalness(Continentalness continentalness) {
            this.continentalness = Optional.of(continentalness);
            return this;
        }

        public Builder setPeakType(PeakTypes peakType) {
            this.peakType = Optional.of(peakType);
            return this;
        }

        public Builder hasRaids() {
            this.hasRaids = Optional.of(true);
            return this;
        }

        public Builder setStructureInRange(class_6885<class_3195> structure, int range) {
            this.structureRangeCondition = Optional.of(new StructureRangeCondition(structure, class_6016.method_34998((int)range)));
            return this;
        }

        public FOTLocationPredicate build() {
            return new FOTLocationPredicate(this.continentalness, this.peakType, this.hasRaids, this.structureRangeCondition);
        }
    }
}

