/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.client.FOTModelLayers;
import com.stevekung.fishofthieves.client.model.AncientscaleModel;
import com.stevekung.fishofthieves.client.model.BattlegillModel;
import com.stevekung.fishofthieves.client.model.DevilfishModel;
import com.stevekung.fishofthieves.client.model.HeadphoneModel;
import com.stevekung.fishofthieves.client.model.IslehopperModel;
import com.stevekung.fishofthieves.client.model.PlentifinModel;
import com.stevekung.fishofthieves.client.model.PondieModel;
import com.stevekung.fishofthieves.client.model.SplashtailModel;
import com.stevekung.fishofthieves.client.model.StormfishModel;
import com.stevekung.fishofthieves.client.model.WildsplashModel;
import com.stevekung.fishofthieves.client.model.WreckerModel;
import com.stevekung.fishofthieves.client.renderer.blockentity.FishPlaqueRenderer;
import com.stevekung.fishofthieves.client.renderer.entity.AncientscaleRenderer;
import com.stevekung.fishofthieves.client.renderer.entity.BattlegillRenderer;
import com.stevekung.fishofthieves.client.renderer.entity.DevilfishRenderer;
import com.stevekung.fishofthieves.client.renderer.entity.IslehopperRenderer;
import com.stevekung.fishofthieves.client.renderer.entity.PlentifinRenderer;
import com.stevekung.fishofthieves.client.renderer.entity.PondieRenderer;
import com.stevekung.fishofthieves.client.renderer.entity.SplashtailRenderer;
import com.stevekung.fishofthieves.client.renderer.entity.StormfishRenderer;
import com.stevekung.fishofthieves.client.renderer.entity.WildsplashRenderer;
import com.stevekung.fishofthieves.client.renderer.entity.WreckerRenderer;
import com.stevekung.fishofthieves.config.FishOfThievesConfig;
import com.stevekung.fishofthieves.entity.animal.Ancientscale;
import com.stevekung.fishofthieves.entity.animal.Battlegill;
import com.stevekung.fishofthieves.entity.animal.Devilfish;
import com.stevekung.fishofthieves.entity.animal.Islehopper;
import com.stevekung.fishofthieves.entity.animal.Plentifin;
import com.stevekung.fishofthieves.entity.animal.Pondie;
import com.stevekung.fishofthieves.entity.animal.Splashtail;
import com.stevekung.fishofthieves.entity.animal.Stormfish;
import com.stevekung.fishofthieves.entity.animal.Wildsplash;
import com.stevekung.fishofthieves.entity.animal.Wrecker;
import com.stevekung.fishofthieves.mixin.client.MixinCreativeModeTabs;
import com.stevekung.fishofthieves.registry.FOTBlockEntityTypes;
import com.stevekung.fishofthieves.registry.FOTEntities;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.class_10042;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1690;
import net.minecraft.class_1761;
import net.minecraft.class_310;
import net.minecraft.class_554;
import net.minecraft.class_5601;
import net.minecraft.class_5607;
import net.minecraft.class_5616;
import net.minecraft.class_5617;
import net.minecraft.class_7225;
import net.minecraft.class_7264;
import net.minecraft.class_746;
import net.minecraft.class_7761;
import net.minecraft.class_837;
import net.minecraft.class_881;

public class FishOfThievesClient {
    private static final Map<String, Object> PREVIOUS_CONFIG_VALUES = Maps.newHashMap();

    public static void init() {
        FishOfThievesClient.onConfigLoad();
        AutoConfig.getConfigHolder(FishOfThievesConfig.class).registerSaveListener((holder, config) -> FishOfThievesClient.onConfigChanged(config));
    }

    public static List<ModelLayerEntry> getModelLayers() {
        return List.of(new ModelLayerEntry(SplashtailModel.LAYER, SplashtailModel::createBodyLayer), new ModelLayerEntry(PondieModel.LAYER, PondieModel::createBodyLayer), new ModelLayerEntry(IslehopperModel.LAYER, IslehopperModel::createBodyLayer), new ModelLayerEntry(AncientscaleModel.LAYER, AncientscaleModel::createBodyLayer), new ModelLayerEntry(PlentifinModel.LAYER, PlentifinModel::createBodyLayer), new ModelLayerEntry(WildsplashModel.LAYER, WildsplashModel::createBodyLayer), new ModelLayerEntry(DevilfishModel.LAYER, DevilfishModel::createBodyLayer), new ModelLayerEntry(BattlegillModel.LAYER, BattlegillModel::createBodyLayer), new ModelLayerEntry(WreckerModel.LAYER, WreckerModel::createBodyLayer), new ModelLayerEntry(StormfishModel.LAYER, StormfishModel::createBodyLayer), new ModelLayerEntry(FOTModelLayers.COCONUT_BOAT, class_554::method_31985), new ModelLayerEntry(FOTModelLayers.COCONUT_CHEST_BOAT, class_554::method_62066), new ModelLayerEntry(HeadphoneModel.LAYER, HeadphoneModel::createBodyLayer));
    }

    public static List<EntityRendererEntry<class_1297>> getEntityRenderers() {
        return ((ArrayList)class_156.method_654((Object)Lists.newArrayList(), list -> {
            list.add(new EntityRendererEntry<Splashtail>(FOTEntities.SPLASHTAIL, SplashtailRenderer::new));
            list.add(new EntityRendererEntry<Pondie>(FOTEntities.PONDIE, PondieRenderer::new));
            list.add(new EntityRendererEntry<Islehopper>(FOTEntities.ISLEHOPPER, IslehopperRenderer::new));
            list.add(new EntityRendererEntry<Ancientscale>(FOTEntities.ANCIENTSCALE, AncientscaleRenderer::new));
            list.add(new EntityRendererEntry<Plentifin>(FOTEntities.PLENTIFIN, PlentifinRenderer::new));
            list.add(new EntityRendererEntry<Wildsplash>(FOTEntities.WILDSPLASH, WildsplashRenderer::new));
            list.add(new EntityRendererEntry<Devilfish>(FOTEntities.DEVILFISH, DevilfishRenderer::new));
            list.add(new EntityRendererEntry<Battlegill>(FOTEntities.BATTLEGILL, BattlegillRenderer::new));
            list.add(new EntityRendererEntry<Wrecker>(FOTEntities.WRECKER, WreckerRenderer::new));
            list.add(new EntityRendererEntry<Stormfish>(FOTEntities.STORMFISH, StormfishRenderer::new));
            list.add(new EntityRendererEntry<class_1690>(FOTEntities.COCONUT_BOAT, context -> new class_881(context, FOTModelLayers.COCONUT_BOAT)));
            list.add(new EntityRendererEntry<class_7264>(FOTEntities.COCONUT_CHEST_BOAT, context -> new class_881(context, FOTModelLayers.COCONUT_CHEST_BOAT)));
        })).stream().map(entry -> entry).toList();
    }

    public static void registerBlockEntityRenderers() {
        class_5616.method_32144(FOTBlockEntityTypes.FISH_PLAQUE, FishPlaqueRenderer::new);
        class_5616.method_32144(FOTBlockEntityTypes.SIGN, class_837::new);
        class_5616.method_32144(FOTBlockEntityTypes.HANGING_SIGN, class_7761::new);
    }

    public static List<HeadphoneEntry<class_1309, class_10042>> getHeadphone() {
        return ((ArrayList)class_156.method_654((Object)Lists.newArrayList(), list -> {
            list.add(new HeadphoneEntry(class_1299.field_6070, HeadphoneModel.Scaleable.COD));
            list.add(new HeadphoneEntry(class_1299.field_6073, HeadphoneModel.Scaleable.SALMON));
            list.add(new HeadphoneEntry(class_1299.field_6062, HeadphoneModel.Scaleable.PUFFERFISH));
            list.add(new HeadphoneEntry(class_1299.field_6111, HeadphoneModel.Scaleable.TROPICAL_FISH));
            list.add(new HeadphoneEntry(class_1299.field_37420, HeadphoneModel.Scaleable.TADPOLE));
        })).stream().map(entry -> entry).toList();
    }

    private static void onConfigLoad() {
        PREVIOUS_CONFIG_VALUES.put("displayAllFishVariantInCreativeTab", FishOfThieves.CONFIG.general.displayAllFishVariantInCreativeTab);
        PREVIOUS_CONFIG_VALUES.put("displayTrophySpawnEggInCreativeTab", FishOfThieves.CONFIG.general.displayTrophySpawnEggInCreativeTab);
    }

    private static class_1269 onConfigChanged(FishOfThievesConfig config) {
        class_310 minecraft = class_310.method_1551();
        class_746 player = minecraft.field_1724;
        if (player != null && (FishOfThievesClient.isConfigChanged(config, "displayAllFishVariantInCreativeTab") || FishOfThievesClient.isConfigChanged(config, "displayTrophySpawnEggInCreativeTab"))) {
            MixinCreativeModeTabs.setCACHED_PARAMETERS(new class_1761.class_8128(player.field_3944.method_45735(), player.method_7338(), (class_7225.class_7874)player.method_56673()));
            MixinCreativeModeTabs.invokeBuildAllTabContents(MixinCreativeModeTabs.getCACHED_PARAMETERS());
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private static boolean isConfigChanged(FishOfThievesConfig config, String configName) {
        Boolean currentValue;
        Object previousValue = PREVIOUS_CONFIG_VALUES.get(configName);
        switch (configName) {
            case "displayAllFishVariantInCreativeTab": {
                Boolean bl = config.general.displayAllFishVariantInCreativeTab;
                break;
            }
            case "displayTrophySpawnEggInCreativeTab": {
                Boolean bl = config.general.displayTrophySpawnEggInCreativeTab;
                break;
            }
            default: {
                FishOfThieves.LOGGER.error("Unknown configuration parameter: {}", (Object)configName);
                Boolean bl = currentValue = Boolean.valueOf(false);
            }
        }
        if (previousValue == null || previousValue != currentValue) {
            PREVIOUS_CONFIG_VALUES.put(configName, currentValue);
            return true;
        }
        return false;
    }

    public record ModelLayerEntry(class_5601 layerLocation, Supplier<class_5607> supplier) {
    }

    public record HeadphoneEntry<E extends class_1309, S extends class_10042>(class_1299<? extends E> entityType, HeadphoneModel.Scaleable<S> scaleable) {
    }

    public record EntityRendererEntry<E extends class_1297>(class_1299<? extends E> entityType, class_5617<E> factory) {
    }
}

