/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.variant;

import com.google.common.collect.Lists;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function4;
import com.mojang.datafixers.util.Function5;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.stevekung.fishofthieves.FishOfThieves;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_10695;
import net.minecraft.class_10699;
import net.minecraft.class_10701;
import net.minecraft.class_10702;
import net.minecraft.class_12079;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5455;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7891;

public interface AbstractFishVariant
extends class_10695<class_10701, class_10699> {
    public int customModelData();

    public String name();

    public class_12079.class_10726 texture();

    public class_2960 fullTexture();

    public Optional<class_2960> fullGlowTexture();

    public Optional<class_12079.class_10726> glowTexture();

    public SpawnSettings spawnSettings();

    default public List<class_10695.class_10696<class_10701, class_10699>> method_67126() {
        return this.spawnSettings().entity().comp_3583();
    }

    public static <T> Stream<T> select(Stream<T> stream, Function<T, AbstractFishVariant> function, class_10701 object) {
        ArrayList list = Lists.newArrayList();
        stream.forEach(objectx -> {
            AbstractFishVariant priorityProvider = (AbstractFishVariant)function.apply(objectx);
            List listx = priorityProvider.spawnSettings().fishing().isPresent() ? priorityProvider.spawnSettings().fishing().get().comp_3583() : priorityProvider.method_67126();
            for (class_10695.class_10696<class_10701, class_10699> selector : listx) {
                list.add(new class_10695.class_10698(objectx, selector.comp_3576(), (class_10695.class_10697)DataFixUtils.orElseGet((Optional)selector.comp_3575(), class_10695.class_10697::alwaysTrue)));
            }
        });
        list.sort(class_10695.class_10698.field_56283);
        Iterator iterator = list.iterator();
        int i = Integer.MIN_VALUE;
        while (iterator.hasNext()) {
            class_10695.class_10698 unpackedEntry = (class_10695.class_10698)iterator.next();
            if (unpackedEntry.comp_3578() < i) {
                iterator.remove();
                continue;
            }
            if (unpackedEntry.comp_3579().test((Object)object)) {
                i = unpackedEntry.comp_3578();
                continue;
            }
            iterator.remove();
        }
        return list.stream().map(class_10695.class_10698::comp_3577);
    }

    public static <T> Optional<T> pick(Stream<T> stream, Function<T, AbstractFishVariant> function, class_5819 randomSource, class_10701 object) {
        List<T> list = AbstractFishVariant.select(stream, function, object).toList();
        return class_156.method_40083(list, (class_5819)randomSource);
    }

    public static <T extends AbstractFishVariant> Codec<T> simpleCodec(Function5<String, class_12079.class_10726, Optional<class_12079.class_10726>, SpawnSettings, Integer, T> factory) {
        return RecordCodecBuilder.create(instance -> instance.group((App)class_5699.field_41759.fieldOf("name").forGetter(AbstractFishVariant::name), (App)class_12079.class_10726.field_56393.fieldOf("texture").forGetter(AbstractFishVariant::texture), (App)class_12079.class_10726.field_56393.optionalFieldOf("glow_texture").forGetter(AbstractFishVariant::glowTexture), (App)SpawnSettings.CODEC.optionalFieldOf("spawn_settings", (Object)new SpawnSettings(class_10702.method_67170((int)0), Optional.empty())).forGetter(AbstractFishVariant::spawnSettings), (App)class_5699.field_33441.fieldOf("custom_model_data").forGetter(AbstractFishVariant::customModelData)).apply((Applicative)instance, factory));
    }

    public static <T extends AbstractFishVariant> Codec<T> networkCodec(Function4<String, class_12079.class_10726, Optional<class_12079.class_10726>, Integer, T> factory) {
        return RecordCodecBuilder.create(instance -> instance.group((App)class_5699.field_41759.fieldOf("name").forGetter(AbstractFishVariant::name), (App)class_12079.class_10726.field_56393.fieldOf("texture").forGetter(AbstractFishVariant::texture), (App)class_12079.class_10726.field_56393.optionalFieldOf("glow_texture").forGetter(AbstractFishVariant::glowTexture), (App)class_5699.field_33441.fieldOf("custom_model_data").forGetter(AbstractFishVariant::customModelData)).apply((Applicative)instance, factory));
    }

    public static <T extends AbstractFishVariant> class_6880<T> getSpawnVariant(class_3218 serverLevel, class_5455 registryAccess, class_5321<? extends class_2378<? extends T>> registryKey, class_5321<T> defaultKey, class_1309 livingEntity, boolean fromBucket) {
        class_2378 registry = registryAccess.method_30530(registryKey);
        class_10701 context = new class_10701(livingEntity.method_24515(), (class_5425)serverLevel, serverLevel.method_23753(livingEntity.method_24515()));
        if (fromBucket) {
            Optional muha = class_156.method_40083(registry.method_42017().toList(), (class_5819)livingEntity.method_59922());
            return (class_6880)muha.orElseGet(() -> registry.method_46747(defaultKey));
        }
        return (class_6880)class_10695.method_67162((Stream)registryAccess.method_30530(registryKey).method_42017(), class_6880::comp_349, (class_5819)livingEntity.method_59922(), (Object)context).orElseGet(() -> registry.method_46747(defaultKey));
    }

    public record SpawnSettings(class_10702 entity, Optional<class_10702> fishing) {
        public static final Codec<SpawnSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_10702.field_56286.optionalFieldOf("entity", (Object)class_10702.method_67170((int)0)).forGetter(SpawnSettings::entity), (App)class_10702.field_56286.optionalFieldOf("fishing").forGetter(SpawnSettings::fishing)).apply((Applicative)instance, SpawnSettings::new));
        public static final SpawnSettings EMPTY = new SpawnSettings(class_10702.field_56285, Optional.empty());
    }

    public record RegisterContext<T>(String entityName, Function5<String, class_12079.class_10726, Optional<class_12079.class_10726>, SpawnSettings, Integer, T> factory) {
        public static <T> RegisterContext<T> create(String entityName, Function5<String, class_12079.class_10726, Optional<class_12079.class_10726>, SpawnSettings, Integer, T> factory) {
            return new RegisterContext<T>(entityName, factory);
        }

        public <Context, Condition extends class_10695.class_10697<Context>> class_10695.class_10696<Context, Condition> select(Condition condition, int priority) {
            return new class_10695.class_10696(condition, priority);
        }

        public void register(class_7891<T> context, class_5321<T> key, String name, int customModelData) {
            this.register(context, key, name, customModelData, false, class_10695.method_67159((int)0), Optional.empty());
        }

        public void register(class_7891<T> context, class_5321<T> key, String name, int customModelData, boolean glow) {
            this.register(context, key, name, customModelData, glow, class_10695.method_67159((int)0), Optional.empty());
        }

        public void register(class_7891<T> context, class_5321<T> key, String name, int customModelData, class_10699 condition) {
            this.register(context, key, name, customModelData, false, List.of(this.select(condition, 0)), Optional.empty());
        }

        @SafeVarargs
        public final void register(class_7891<T> context, class_5321<T> key, String name, int customModelData, class_10695.class_10696<class_10701, class_10699> ... conditions) {
            this.register(context, key, name, customModelData, false, List.of(conditions), Optional.empty());
        }

        @SafeVarargs
        public final void register(class_7891<T> context, class_5321<T> key, String name, int customModelData, boolean glow, class_10695.class_10696<class_10701, class_10699> ... conditions) {
            this.register(context, key, name, customModelData, glow, List.of(conditions), Optional.empty());
        }

        public void register(class_7891<T> context, class_5321<T> key, String name, int customModelData, List<class_10695.class_10696<class_10701, class_10699>> conditions, List<class_10695.class_10696<class_10701, class_10699>> fishingOverride) {
            this.register(context, key, name, customModelData, false, conditions, Optional.of(fishingOverride));
        }

        public void register(class_7891<T> context, class_5321<T> key, String name, int customModelData, boolean glow, class_10695.class_10696<class_10701, class_10699> conditions) {
            this.register(context, key, name, customModelData, glow, List.of(conditions), Optional.empty());
        }

        public void register(class_7891<T> context, class_5321<T> key, String name, int customModelData, boolean glow, class_10699 condition) {
            this.register(context, key, name, customModelData, glow, List.of(this.select(condition, 0)), Optional.empty());
        }

        public void register(class_7891<T> context, class_5321<T> key, String name, int customModelData, boolean glow, class_10695.class_10696<class_10701, class_10699> conditions, List<class_10695.class_10696<class_10701, class_10699>> fishingOverride) {
            this.register(context, key, name, customModelData, glow, List.of(conditions), Optional.of(fishingOverride));
        }

        public void register(class_7891<T> context, class_5321<T> key, String name, int customModelData, boolean glow, List<class_10695.class_10696<class_10701, class_10699>> conditions, Optional<List<class_10695.class_10696<class_10701, class_10699>>> fishingOverride) {
            class_2960 texture = FishOfThieves.id("entity/" + this.entityName + "/" + name);
            class_2960 glowTexture = FishOfThieves.id("entity/" + this.entityName + "/" + name + "_glow");
            context.method_46838(key, this.factory.apply((Object)name, (Object)new class_12079.class_10726(texture), glow ? Optional.of(new class_12079.class_10726(glowTexture)) : Optional.empty(), (Object)new SpawnSettings(new class_10702(conditions), fishingOverride.map(class_10702::new)), (Object)customModelData));
        }
    }
}

