/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.block;

import com.mojang.serialization.MapCodec;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class AbstractMangoFruitBlock
extends Block
implements BonemealableBlock,
Fallable {
    public static final MapCodec<AbstractMangoFruitBlock> CODEC = AbstractMangoFruitBlock.simpleCodec(AbstractMangoFruitBlock::new);
    public static final IntegerProperty AGE = BlockStateProperties.AGE_2;
    public static final BooleanProperty FALLING = BlockStateProperties.FALLING;

    public AbstractMangoFruitBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 2 || (Boolean)state.getValue((Property)FALLING) != false;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int age = (Integer)state.getValue((Property)AGE);
        if (age < 2 && random.nextInt(5) == 0) {
            level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age + 1)), 2);
        }
        if (AbstractMangoFruitBlock.canMangoFall(level.getBlockState(pos.below())) && (age == 1 && random.nextFloat() > 0.9f || age == 2 && random.nextFloat() > 0.75f)) {
            level.scheduleTick(pos, (Block)this, 2);
        }
    }

    protected void falling(FallingBlockEntity entity) {
        entity.setHurtsEntities(1.0f, 1);
        entity.disableDrop();
    }

    public DamageSource getFallDamageSource(Entity entity) {
        return entity.damageSources().fishofthieves$fallingMango(entity);
    }

    public BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess scheduledTickAccess, BlockPos currentPos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource randomSource) {
        if (!state.canSurvive(level, currentPos)) {
            if (!AbstractMangoFruitBlock.canMangoFall(level.getBlockState(currentPos.below()))) {
                return Blocks.AIR.defaultBlockState();
            }
            scheduledTickAccess.scheduleTick(currentPos, (Block)this, 2);
        }
        return state;
    }

    public void onProjectileHit(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        ServerLevel serverLevel;
        BlockPos blockPos = hit.getBlockPos();
        if (level instanceof ServerLevel && projectile.mayInteract(serverLevel = (ServerLevel)level, blockPos) && projectile.getType().is(EntityTypeTags.IMPACT_PROJECTILES)) {
            if (!AbstractMangoFruitBlock.canMangoFall(level.getBlockState(blockPos.below()))) {
                level.destroyBlock(blockPos, true, (Entity)projectile);
            } else {
                serverLevel.scheduleTick(blockPos, (Block)this, 2);
            }
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (AbstractMangoFruitBlock.canMangoFall(level.getBlockState(pos.below())) && pos.getY() >= level.getMinY()) {
            FallingBlockEntity fallingBlockEntity = FallingBlockEntity.fall((Level)level, (BlockPos)pos, (BlockState)state);
            this.falling(fallingBlockEntity);
        }
    }

    public void onBrokenAfterFall(Level level, BlockPos pos, FallingBlockEntity fallingBlock) {
        Vec3 vec3 = fallingBlock.getBoundingBox().getCenter();
        BlockState blockState = fallingBlock.getBlockState();
        level.levelEvent(2001, BlockPos.containing((Position)vec3), Block.getId((BlockState)fallingBlock.getBlockState()));
        level.gameEvent((Entity)fallingBlock, (Holder)GameEvent.BLOCK_DESTROY, vec3);
        Block.dropResources((BlockState)blockState, (Level)level, (BlockPos)pos);
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 2;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf((Integer)state.getValue((Property)AGE) + 1)), 3);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE, FALLING});
    }

    public boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean includeData) {
        return (Integer)state.getValue((Property)AGE) == 1 ? new ItemStack((ItemLike)FOTItems.RAW_MANGO) : new ItemStack((ItemLike)FOTItems.MANGO);
    }

    public static boolean canMangoFall(BlockState state) {
        return state.is(FOTBlocks.MANGO_FRUIT) || FallingBlock.isFree((BlockState)state);
    }
}

