/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.block;

import com.stevekung.fishofthieves.block.BananaShootsPlantBlock;
import com.stevekung.fishofthieves.block.SmallRotatedPillarBlock;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BananaStemBlock
extends SmallRotatedPillarBlock
implements BonemealableBlock {
    private static final VoxelShape SHAPE_VERTICAL = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape SHAPE_HORIZONTAL_NS = Block.box((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)16.0);
    private static final VoxelShape SHAPE_HORIZONTAL_WE = Block.box((double)0.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0);

    public BananaStemBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)AXIS, (Comparable)Direction.Axis.Y)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public boolean skipRendering(BlockState state, BlockState adjacentState, Direction direction) {
        return (adjacentState.is((Block)this) || adjacentState.is(FOTTags.Blocks.NON_FULL_LOGS)) && state.getValue((Property)AXIS) == adjacentState.getValue((Property)AXIS);
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        switch ((Direction.Axis)state.getValue((Property)AXIS)) {
            case X: {
                return SHAPE_HORIZONTAL_WE;
            }
            case Z: {
                return SHAPE_HORIZONTAL_NS;
            }
        }
        return SHAPE_VERTICAL;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.isRaining() && random.nextInt(10) == 0) {
            this.growBananaShoots(level, random, pos);
        }
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return Direction.Plane.HORIZONTAL.stream().anyMatch(direction -> FOTBlocks.BANANA_SHOOTS_PLANT.defaultBlockState().canSurvive(level, pos.relative(direction)) && level.getBlockState(pos.relative(direction)).isAir());
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return random.nextInt(3) == 0;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        this.growBananaShoots(level, random, pos);
    }

    private void growBananaShoots(ServerLevel level, RandomSource random, BlockPos pos) {
        Direction.Plane.HORIZONTAL.shuffledCopy(random).stream().filter(direction -> level.getBlockState(pos.relative(direction)).isAir() && FOTBlocks.BANANA_SHOOTS_PLANT.defaultBlockState().canSurvive((LevelReader)level, pos.relative(direction))).findFirst().ifPresent(direction -> level.setBlock(pos.relative(direction), (BlockState)FOTBlocks.BANANA_SHOOTS_PLANT.defaultBlockState().setValue((Property)BananaShootsPlantBlock.FACING, (Comparable)direction.getOpposite()), 2));
    }
}

