/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.block;

import com.mojang.serialization.MapCodec;
import com.stevekung.fishofthieves.registry.FOTItems;
import com.stevekung.fishofthieves.registry.FOTTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CoconutFruitBlock
extends HorizontalDirectionalBlock
implements BonemealableBlock,
Fallable {
    public static final MapCodec<CoconutFruitBlock> CODEC = CoconutFruitBlock.simpleCodec(CoconutFruitBlock::new);
    private static final VoxelShape[] EAST_AABB = new VoxelShape[]{Block.box((double)12.0, (double)8.0, (double)5.0, (double)18.0, (double)14.0, (double)11.0), Block.box((double)10.0, (double)6.0, (double)4.0, (double)18.0, (double)14.0, (double)12.0), Block.box((double)7.0, (double)3.0, (double)2.5, (double)18.0, (double)14.0, (double)13.5)};
    private static final VoxelShape[] WEST_AABB = new VoxelShape[]{Block.box((double)-2.0, (double)8.0, (double)5.0, (double)4.0, (double)14.0, (double)11.0), Block.box((double)-2.0, (double)6.0, (double)4.0, (double)6.0, (double)14.0, (double)12.0), Block.box((double)-2.0, (double)3.0, (double)2.5, (double)9.0, (double)14.0, (double)13.5)};
    private static final VoxelShape[] NORTH_AABB = new VoxelShape[]{Block.box((double)5.0, (double)8.0, (double)-2.0, (double)11.0, (double)14.0, (double)4.0), Block.box((double)4.0, (double)6.0, (double)-2.0, (double)12.0, (double)14.0, (double)6.0), Block.box((double)2.5, (double)3.0, (double)-2.0, (double)13.5, (double)14.0, (double)9.0)};
    private static final VoxelShape[] SOUTH_AABB = new VoxelShape[]{Block.box((double)5.0, (double)8.0, (double)12.0, (double)11.0, (double)14.0, (double)18.0), Block.box((double)4.0, (double)6.0, (double)10.0, (double)12.0, (double)14.0, (double)18.0), Block.box((double)2.5, (double)3.0, (double)7.0, (double)13.5, (double)14.0, (double)18.0)};
    public static final IntegerProperty AGE = BlockStateProperties.AGE_2;

    public CoconutFruitBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public boolean isRandomlyTicking(BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 2;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int age = (Integer)state.getValue((Property)AGE);
        if (age < 2 && random.nextInt(5) == 0) {
            level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age + 1)), 2);
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (FallingBlock.isFree((BlockState)level.getBlockState(pos.below())) && pos.getY() >= level.getMinY()) {
            FallingBlockEntity fallingBlockEntity = FallingBlockEntity.fall((Level)level, (BlockPos)pos, (BlockState)state);
            fallingBlockEntity.setHurtsEntities(0.5f * (float)Math.max(1, (Integer)state.getValue((Property)AGE)), 20);
            fallingBlockEntity.disableDrop();
        }
    }

    public DamageSource getFallDamageSource(Entity entity) {
        return entity.damageSources().fishofthieves$fallingCoconut(entity);
    }

    public void onBrokenAfterFall(Level level, BlockPos pos, FallingBlockEntity fallingBlock) {
        Vec3 vec3 = fallingBlock.getBoundingBox().getCenter();
        BlockState blockState = fallingBlock.getBlockState();
        level.levelEvent(2001, BlockPos.containing((Position)vec3), Block.getId((BlockState)fallingBlock.getBlockState()));
        level.gameEvent((Entity)fallingBlock, (Holder)GameEvent.BLOCK_DESTROY, vec3);
        Block.dropResources((BlockState)blockState, (Level)level, (BlockPos)pos);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState blockState = level.getBlockState(pos.relative((Direction)state.getValue((Property)FACING)));
        return blockState.is(FOTTags.Blocks.SMALL_COCONUT_LOGS) && blockState.getValue((Property)BlockStateProperties.AXIS) == Direction.Axis.Y;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int i = (Integer)state.getValue((Property)AGE);
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.SOUTH -> SOUTH_AABB[i];
            case Direction.WEST -> WEST_AABB[i];
            case Direction.EAST -> EAST_AABB[i];
            default -> NORTH_AABB[i];
        };
    }

    public BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess scheduledTickAccess, BlockPos currentPos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource randomSource) {
        if (!state.canSurvive(level, currentPos)) {
            if (!FallingBlock.isFree((BlockState)level.getBlockState(currentPos.below()))) {
                return Blocks.AIR.defaultBlockState();
            }
            scheduledTickAccess.scheduleTick(currentPos, (Block)this, 2);
        }
        return state;
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return (Integer)state.getValue((Property)AGE) < 2;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf((Integer)state.getValue((Property)AGE) + 1)), 2);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, AGE});
    }

    public boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean includeData) {
        return new ItemStack((ItemLike)FOTItems.COCONUT);
    }

    public void onProjectileHit(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        ServerLevel serverLevel;
        BlockPos blockPos = hit.getBlockPos();
        if (level instanceof ServerLevel && projectile.mayInteract(serverLevel = (ServerLevel)level, blockPos) && projectile.getType().is(EntityTypeTags.IMPACT_PROJECTILES)) {
            if (!FallingBlock.isFree((BlockState)level.getBlockState(blockPos.below()))) {
                level.destroyBlock(blockPos, true, (Entity)projectile);
            } else {
                serverLevel.scheduleTick(blockPos, (Block)this, 2);
            }
        }
    }

    public boolean skipRendering(BlockState state, BlockState adjacentState, Direction direction) {
        return adjacentState.is(FOTTags.Blocks.SMALL_COCONUT_LOGS) && state.getValue((Property)FACING) == direction;
    }
}

