/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.PartyFish;
import com.stevekung.fishofthieves.entity.VariantHolder;
import com.stevekung.fishofthieves.entity.variant.AbstractFishVariant;
import com.stevekung.fishofthieves.item.FOTItem;
import com.stevekung.fishofthieves.registry.FOTMemoryModuleTypes;
import com.stevekung.fishofthieves.registry.FOTTags;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.Nullable;

public interface ThievesFish<T extends AbstractFishVariant>
extends PartyFish,
VariantHolder<Holder<T>> {
    public static final TagKey<Item> WORMS = FOTTags.Items.WORMS;
    public static final TagKey<Item> EARTHWORMS_FOOD = FOTTags.Items.EARTHWORMS_FOOD;
    public static final TagKey<Item> GRUBS_FOOD = FOTTags.Items.GRUBS_FOOD;
    public static final TagKey<Item> LEECHES_FOOD = FOTTags.Items.LEECHES_FOOD;
    public static final String VARIANT_TAG = "variant";
    public static final String TROPHY_TAG = "Trophy";
    public static final String HAS_FED_TAG = "HasFed";
    public static final String NO_FLIP_TAG = "NoFlip";

    public ResourceKey<? extends Registry<T>> getRegistryKey();

    public ResourceKey<T> getDefaultKey();

    public boolean isTrophy();

    public void setTrophy(boolean var1);

    public boolean hasFed();

    public void setHasFed(boolean var1);

    public boolean isFood(ItemStack var1);

    public void setNoFlip(boolean var1);

    public boolean isNoFlip();

    default public float getGlowBrightness(float ageInTicks) {
        return 1.0f;
    }

    default public boolean isFishBreached(Brain<?> brain) {
        return brain.hasMemoryValue(FOTMemoryModuleTypes.BREACHED_TICK) && (Integer)brain.getMemory(FOTMemoryModuleTypes.BREACHED_TICK).get() > 0;
    }

    default public void saveToBucket(ItemStack bucket) {
        if (FishOfThieves.CONFIG.general.enableFishItemWithAllVariant) {
            bucket.set(DataComponents.CUSTOM_MODEL_DATA, (Object)FOTItem.createCustomModelData(((AbstractFishVariant)((Holder)this.getVariant()).value()).customModelData()));
        }
        CustomData.update((DataComponentType)DataComponents.BUCKET_ENTITY_DATA, (ItemStack)bucket, compoundTag -> {
            if (this.isTrophy()) {
                compoundTag.putBoolean(HAS_FED_TAG, this.hasFed());
                compoundTag.putBoolean(TROPHY_TAG, this.isTrophy());
            }
            if (this.isNoFlip()) {
                compoundTag.putBoolean(NO_FLIP_TAG, this.isNoFlip());
            }
        });
    }

    default public void loadFromBucket(CompoundTag compound) {
        compound.getBoolean(TROPHY_TAG).ifPresent(this::setTrophy);
        compound.getBoolean(HAS_FED_TAG).ifPresent(this::setHasFed);
        compound.getBoolean(NO_FLIP_TAG).ifPresent(this::setNoFlip);
    }

    default public SpawnGroupData defaultFinalizeSpawn(ServerLevelAccessor accessor, LivingEntity livingEntity, EntitySpawnReason entitySpawnReason, @Nullable SpawnGroupData spawnData) {
        Holder<T> holder = AbstractFishVariant.getSpawnVariant(accessor.getLevel(), accessor.registryAccess(), this.getRegistryKey(), this.getDefaultKey(), livingEntity, entitySpawnReason == EntitySpawnReason.BUCKET);
        this.setVariant(holder);
        if (livingEntity.getRandom().nextFloat() < FishOfThieves.CONFIG.spawnRate.trophyProbability) {
            this.setTrophy(true);
            livingEntity.setHealth(FishOfThieves.CONFIG.general.trophyMaxHealth);
        }
        return spawnData;
    }

    default public void setRandomVariant(RegistryAccess registryAccess, RandomSource randomSource) {
        Registry registry = registryAccess.lookupOrThrow(this.getRegistryKey());
        Optional muha = Util.getRandomSafe(registry.listElements().toList(), (RandomSource)randomSource);
        this.setVariant((Holder)muha.orElseGet(() -> registry.getOrThrow(this.getDefaultKey())));
        this.setTrophy(randomSource.nextBoolean());
    }
}

