/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.stevekung.fishofthieves.entity.AbstractThievesFish;
import com.stevekung.fishofthieves.entity.ThievesFish;
import com.stevekung.fishofthieves.entity.ai.behavior.FishBreaching;
import com.stevekung.fishofthieves.registry.FOTMemoryModuleTypes;
import com.stevekung.fishofthieves.registry.FOTMobEffects;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.CopyMemoryWithExpiry;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.GateBehavior;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.Item;

public class AbstractThievesFishAi {
    public static final UniformInt TIME_BETWEEN_BREACH = UniformInt.of((int)1200, (int)2000);

    public static Brain<?> makeBrain(Brain<AbstractThievesFish<?>> brain) {
        AbstractThievesFishAi.initCoreActivity(brain);
        AbstractThievesFishAi.initIdleActivity(brain);
        AbstractThievesFishAi.initRetreatActivity(brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    public static void initMemories(AbstractThievesFish<?> fish) {
        fish.getBrain().setMemory(MemoryModuleType.LONG_JUMP_COOLDOWN_TICKS, (Object)TIME_BETWEEN_BREACH.sample(fish.getRandom()));
    }

    public static void updateActivity(AbstractThievesFish<?> fish) {
        fish.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.AVOID, (Object)Activity.IDLE));
    }

    public static TagKey<Item> getCommonTemptations() {
        return ThievesFish.WORMS;
    }

    public static TagKey<Item> getLeechesTemptations() {
        return ThievesFish.LEECHES_FOOD;
    }

    public static TagKey<Item> getEarthwormsTemptations() {
        return ThievesFish.EARTHWORMS_FOOD;
    }

    public static TagKey<Item> getGrubsTemptations() {
        return ThievesFish.GRUBS_FOOD;
    }

    public static <T extends AbstractThievesFish<?>> void customServerAiStep(T fish, Brain<T> brain) {
        String name = BuiltInRegistries.ENTITY_TYPE.getKey((Object)fish.getType()).getPath();
        ProfilerFiller profiler = Profiler.get();
        profiler.push(name + "Brain");
        brain.tick((ServerLevel)fish.level(), fish);
        profiler.popPush(name + "ActivityUpdate");
        AbstractThievesFishAi.updateActivity(fish);
        profiler.pop();
    }

    private static void initCoreActivity(Brain<AbstractThievesFish<?>> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new AnimalPanic(2.0f), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), AbstractThievesFishAi.avoidPlayer(), (Object)new CountDownCooldownTicks(MemoryModuleType.TEMPTATION_COOLDOWN_TICKS), (Object)new CountDownCooldownTicks(MemoryModuleType.LONG_JUMP_COOLDOWN_TICKS), (Object)new CountDownCooldownTicks(FOTMemoryModuleTypes.BREACHED_TICK)));
    }

    private static void initIdleActivity(Brain<AbstractThievesFish<?>> brain) {
        brain.addActivity(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, (Object)SetEntityLookTargetSometimes.create((EntityType)EntityType.PLAYER, (float)6.0f, (UniformInt)UniformInt.of((int)30, (int)60))), (Object)Pair.of((Object)1, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of(AbstractThievesFishAi.avoidRepellent(), (Object)1), (Object)Pair.of((Object)new FollowTemptation(livingEntity -> Float.valueOf(1.25f)), (Object)1), (Object)Pair.of(new FishBreaching(TIME_BETWEEN_BREACH, 0.3f, 0.16f), (Object)2)))), (Object)Pair.of((Object)2, (Object)new GateBehavior((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), (Set)ImmutableSet.of(), GateBehavior.OrderPolicy.ORDERED, GateBehavior.RunningPolicy.TRY_ALL, (List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.swim((float)1.0f), (Object)2), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)0.5f, (int)3), (Object)3), (Object)Pair.of((Object)BehaviorBuilder.triggerIf(Entity::isInWater), (Object)5))))));
    }

    private static void initRetreatActivity(Brain<AbstractThievesFish<?>> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.AVOID, 10, ImmutableList.of((Object)SetWalkTargetAwayFrom.entity((MemoryModuleType)MemoryModuleType.AVOID_TARGET, (float)5.0f, (int)12, (boolean)true), AbstractThievesFishAi.createIdleLookBehaviors(), AbstractThievesFishAi.createIdleMovementBehaviors(), (Object)EraseMemoryIf.create(AbstractThievesFishAi::wantsToStopFleeing, (MemoryModuleType)MemoryModuleType.AVOID_TARGET)), MemoryModuleType.AVOID_TARGET);
    }

    private static RunOne<AbstractThievesFish<?>> createIdleLookBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)SetEntityLookTarget.create((EntityType)EntityType.PLAYER, (float)6.0f), (Object)1), (Object)Pair.of((Object)SetEntityLookTarget.create((float)8.0f), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    private static RunOne<AbstractThievesFish<?>> createIdleMovementBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.swim((float)1.0f), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    public static BehaviorControl<PathfinderMob> avoidRepellent() {
        return SetWalkTargetAwayFrom.pos((MemoryModuleType)MemoryModuleType.NEAREST_REPELLENT, (float)5.0f, (int)10, (boolean)true);
    }

    public static <T extends AbstractFish> boolean isPosNearNearestRepellent(T fish, BlockPos pos) {
        Optional optional = fish.getBrain().getMemory(MemoryModuleType.NEAREST_REPELLENT);
        return optional.isPresent() && ((BlockPos)optional.get()).closerThan((Vec3i)pos, 10.0);
    }

    public static BehaviorControl<LivingEntity> avoidPlayer() {
        return CopyMemoryWithExpiry.create(AbstractThievesFishAi::isNearPlayerNotCrouching, (MemoryModuleType)MemoryModuleType.NEAREST_VISIBLE_PLAYER, (MemoryModuleType)MemoryModuleType.AVOID_TARGET, (UniformInt)TimeUtil.rangeOfSeconds((int)5, (int)7));
    }

    public static <T extends AbstractFish> boolean wantsToStopFleeing(T fish) {
        Brain brain = fish.getBrain();
        if (!brain.hasMemoryValue(MemoryModuleType.AVOID_TARGET)) {
            return true;
        }
        LivingEntity livingEntity = (LivingEntity)brain.getMemory(MemoryModuleType.AVOID_TARGET).get();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            return !brain.isMemoryValue(MemoryModuleType.NEAREST_VISIBLE_PLAYER, (Object)player);
        }
        return false;
    }

    public static <T extends LivingEntity> boolean isNearPlayerNotCrouching(T fish) {
        Brain brain = fish.getBrain();
        if (brain.hasMemoryValue(MemoryModuleType.NEAREST_VISIBLE_PLAYER)) {
            Player player = (Player)brain.getMemory(MemoryModuleType.NEAREST_VISIBLE_PLAYER).get();
            return !player.isCrouching() && !player.hasEffect(FOTMobEffects.GUARDIAN_STIFLE) && fish.closerThan((Entity)player, 6.0);
        }
        return false;
    }
}

