/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.entity.animal;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Dynamic;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.AbstractThievesFish;
import com.stevekung.fishofthieves.entity.ai.AbstractThievesFishAi;
import com.stevekung.fishofthieves.entity.variant.IslehopperVariant;
import com.stevekung.fishofthieves.registry.FOTBiomes;
import com.stevekung.fishofthieves.registry.FOTDataComponentTypes;
import com.stevekung.fishofthieves.registry.FOTDataSerializers;
import com.stevekung.fishofthieves.registry.FOTItems;
import com.stevekung.fishofthieves.registry.FOTRegistries;
import com.stevekung.fishofthieves.registry.FOTSensorTypes;
import com.stevekung.fishofthieves.registry.FOTSoundEvents;
import com.stevekung.fishofthieves.registry.variant.IslehopperVariants;
import com.stevekung.fishofthieves.utils.Continentalness;
import com.stevekung.fishofthieves.utils.PeakTypes;
import com.stevekung.fishofthieves.utils.TerrainUtils;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;

public class Islehopper
extends AbstractThievesFish<IslehopperVariant> {
    private static final EntityDataAccessor<Holder<IslehopperVariant>> VARIANT = SynchedEntityData.defineId(Islehopper.class, FOTDataSerializers.ISLEHOPPER_VARIANT);
    public static final BiMap<String, Integer> VARIANT_TO_INT = (BiMap)Util.make((Object)HashBiMap.create(), map -> {
        map.put((Object)"fishofthieves:stone", (Object)0);
        map.put((Object)"fishofthieves:moss", (Object)1);
        map.put((Object)"fishofthieves:honey", (Object)2);
        map.put((Object)"fishofthieves:raven", (Object)3);
        map.put((Object)"fishofthieves:amethyst", (Object)4);
    });

    public Islehopper(EntityType<? extends Islehopper> entityType, Level level) {
        super(entityType, level, FOTRegistries.ISLEHOPPER_VARIANT, IslehopperVariants.STONE, FOTDataComponentTypes.ISLEHOPPER_VARIANT);
    }

    protected Brain.Provider<AbstractThievesFish<?>> brainProvider() {
        return Brain.provider((Collection)MEMORY_TYPES, Stream.of(SENSOR_TYPES, List.of(FOTSensorTypes.COMMON_THIEVES_FISH_TEMPTATIONS)).flatMap(Collection::stream).toList());
    }

    protected Brain<?> makeBrain(Dynamic<?> dynamic) {
        return AbstractThievesFishAi.makeBrain(this.brainProvider().makeBrain(dynamic));
    }

    public Brain<Islehopper> getBrain() {
        return super.getBrain();
    }

    @Override
    protected void customServerAiStep(ServerLevel serverLevel) {
        AbstractThievesFishAi.customServerAiStep(this, this.getBrain());
        super.customServerAiStep(serverLevel);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)this.registryAccess().lookupOrThrow(FOTRegistries.ISLEHOPPER_VARIANT).getOrThrow(IslehopperVariants.STONE));
    }

    @Override
    public Holder<IslehopperVariant> getVariant() {
        return (Holder)this.entityData.get(VARIANT);
    }

    @Override
    public void setVariant(Holder<IslehopperVariant> variant) {
        this.entityData.set(VARIANT, variant);
    }

    public ItemStack getBucketItemStack() {
        return new ItemStack((ItemLike)FOTItems.ISLEHOPPER_BUCKET);
    }

    protected SoundEvent getDeathSound() {
        return FOTSoundEvents.ISLEHOPPER_DEATH;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return FOTSoundEvents.ISLEHOPPER_HURT;
    }

    protected SoundEvent getFlopSound() {
        return FOTSoundEvents.ISLEHOPPER_FLOP;
    }

    public boolean skipAttackInteraction(Entity entity) {
        if (FishOfThieves.CONFIG.general.neutralFishBehavior) {
            ServerPlayer serverPlayer;
            int multiplier;
            int n = multiplier = this.isTrophy() ? 2 : 1;
            if (entity instanceof ServerPlayer && entity.hurtServer((serverPlayer = (ServerPlayer)entity).level(), this.damageSources().mobAttack((LivingEntity)this), (float)multiplier)) {
                if (!this.isSilent()) {
                    serverPlayer.connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.PUFFER_FISH_STING, 0.0f));
                }
                serverPlayer.addEffect(new MobEffectInstance(MobEffects.POISON, 60 * multiplier, 0), (Entity)this);
            }
        }
        return false;
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return this.isTrophy() ? super.getDefaultDimensions(pose).withEyeHeight(0.29f) : EntityDimensions.fixed((float)0.3f, (float)0.2f).withEyeHeight(0.15f);
    }

    @Override
    public float getGlowBrightness(float ageInTicks) {
        return Mth.clamp((float)(1.0f + Mth.cos((float)(ageInTicks * 0.05f))), (float)0.5f, (float)1.0f);
    }

    @Override
    public boolean isFood(ItemStack itemStack) {
        return itemStack.is(WORMS);
    }

    public static boolean checkSpawnRules(EntityType<? extends WaterAnimal> entityType, ServerLevelAccessor level, EntitySpawnReason entitySpawnReason, BlockPos blockPos, RandomSource random) {
        boolean isSurfaceWater = WaterAnimal.checkSurfaceWaterAnimalSpawnRules(entityType, (LevelAccessor)level, (EntitySpawnReason)entitySpawnReason, (BlockPos)blockPos, (RandomSource)random);
        boolean isWater = level.getFluidState(blockPos.below()).is(FluidTags.WATER) && level.getBlockState(blockPos.above()).is(Blocks.WATER);
        Continentalness continentalness = TerrainUtils.getContinentalness(level.getLevel(), blockPos);
        PeakTypes peakTypes = TerrainUtils.getPeakTypes(level.getLevel(), blockPos);
        boolean isCoast = continentalness == Continentalness.COAST && (peakTypes == PeakTypes.LOW || peakTypes == PeakTypes.MID || peakTypes == PeakTypes.VALLEY);
        return isSurfaceWater && isCoast || isWater && (blockPos.getY() <= 0 || level.getBiome(blockPos).is(FOTBiomes.TROPICAL_ISLAND));
    }
}

