/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;

public class TropicalIslandBlockBlobFeature
extends Feature<BlockStateConfiguration> {
    public TropicalIslandBlockBlobFeature(Codec<BlockStateConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<BlockStateConfiguration> context) {
        BlockState blockState;
        BlockPos blockPos = context.origin();
        WorldGenLevel worldGenLevel = context.level();
        RandomSource randomSource = context.random();
        BlockStateConfiguration blockStateConfiguration = (BlockStateConfiguration)context.config();
        while (blockPos.getY() > worldGenLevel.getMinY() + 3 && (worldGenLevel.isEmptyBlock(blockPos.below()) || !TropicalIslandBlockBlobFeature.isDirt((BlockState)(blockState = worldGenLevel.getBlockState(blockPos.below()))) && !TropicalIslandBlockBlobFeature.isStone((BlockState)blockState))) {
            blockPos = blockPos.below();
        }
        if (blockPos.getY() <= worldGenLevel.getMinY() + 3) {
            return false;
        }
        for (int i = 0; i < 5; ++i) {
            int j = 1 + randomSource.nextInt(2);
            int k = 1 + randomSource.nextInt(2);
            int l = 1 + randomSource.nextInt(2);
            float f = (float)(j + k + l) * 0.333f + 0.75f;
            for (BlockPos blockPos2 : BlockPos.betweenClosed((BlockPos)blockPos.offset(-j, -k, -l), (BlockPos)blockPos.offset(j, k, l))) {
                if (!(blockPos2.distSqr((Vec3i)blockPos) <= (double)(f * f))) continue;
                worldGenLevel.setBlock(blockPos2, blockStateConfiguration.state, 3);
            }
            blockPos = blockPos.offset(-1 + randomSource.nextInt(2), -randomSource.nextInt(2), -1 + randomSource.nextInt(2));
        }
        return true;
    }
}

