/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.item;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.variant.AbstractFishVariant;
import com.stevekung.fishofthieves.item.FOTItem;
import com.stevekung.fishofthieves.registry.FOTTags;
import java.util.Comparator;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MobBucketItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;

public class FOTMobBucketItem
extends MobBucketItem {
    private final EntityType<? extends Mob> entityType;
    private final ResourceLocation registryKey;
    private final DataComponentType<?> dataComponentType;

    public FOTMobBucketItem(EntityType<? extends Mob> entityType, Fluid fluid, SoundEvent soundEvent, ResourceKey<?> registryKey, DataComponentType<?> dataComponentType, Item.Properties properties) {
        super(entityType, fluid, soundEvent, properties);
        this.entityType = entityType;
        this.registryKey = registryKey.location();
        this.dataComponentType = dataComponentType;
    }

    public void verifyComponentsAfterLoad(ItemStack itemStack) {
        if (FishOfThieves.CONFIG.general.displayAllFishVariantInCreativeTab && !itemStack.has(DataComponents.CUSTOM_MODEL_DATA)) {
            itemStack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)FOTItem.createCustomModelData(0));
        }
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> consumer, TooltipFlag tooltipFlag) {
        if (this.entityType.is(FOTTags.EntityTypes.THIEVES_FISH_ENTITY_TYPE)) {
            MutableComponent type = null;
            Holder fishData = (Holder)itemStack.get(this.dataComponentType);
            if (fishData != null) {
                type = this.createTooltip(((AbstractFishVariant)fishData.value()).name());
            }
            CustomData customData = (CustomData)itemStack.getOrDefault(DataComponents.BUCKET_ENTITY_DATA, (Object)CustomData.EMPTY);
            if (type != null) {
                CompoundTag compoundTag;
                if (!customData.isEmpty() && (compoundTag = customData.copyTag()).getBooleanOr("Trophy", false)) {
                    type.append(", ").append((Component)Component.translatable((String)"entity.fishofthieves.trophy"));
                }
                consumer.accept((Component)type);
            }
        }
    }

    public static void addFishVariantsBucket(CreativeModeTab.ItemDisplayParameters itemDisplayParameters, CreativeModeTab.Output output, Item item) {
        if (FishOfThieves.CONFIG.general.displayAllFishVariantInCreativeTab) {
            if (item instanceof FOTMobBucketItem) {
                FOTMobBucketItem fotItem = (FOTMobBucketItem)item;
                Comparator<Holder> comparator = Comparator.comparing(Holder::value, Comparator.comparingInt(AbstractFishVariant::customModelData));
                ResourceKey registryKey = ResourceKey.createRegistryKey((ResourceLocation)fotItem.getRegistryKey());
                itemDisplayParameters.holders().lookup(registryKey).ifPresent(lookup -> lookup.listElements().sorted(comparator).forEach(holder -> output.accept(FOTMobBucketItem.create(item, fotItem.getDataComponentType(), (Holder<? extends AbstractFishVariant>)holder))));
            }
        } else {
            output.accept((ItemLike)item);
        }
    }

    public ResourceLocation getRegistryKey() {
        return this.registryKey;
    }

    public DataComponentType<?> getDataComponentType() {
        return this.dataComponentType;
    }

    private MutableComponent createTooltip(String location) {
        return Component.translatable((String)"entity.fishofthieves.%s.%s".formatted(BuiltInRegistries.ENTITY_TYPE.getKey(this.entityType).getPath(), ResourceLocation.tryParse((String)location).getPath())).withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY});
    }

    private static ItemStack create(Item item, DataComponentType<Holder<? extends AbstractFishVariant>> dataComponentType, Holder<? extends AbstractFishVariant> holder) {
        ItemStack itemStack = new ItemStack((ItemLike)item);
        itemStack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)FOTItem.createCustomModelData(((AbstractFishVariant)holder.value()).customModelData()));
        itemStack.set(dataComponentType, holder);
        return itemStack;
    }
}

