/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.mixin.entity;

import com.llamalad7.mixinextras.sugar.Local;
import com.stevekung.fishofthieves.entity.PartyFish;
import com.stevekung.fishofthieves.registry.FOTLootTables;
import com.stevekung.fishofthieves.registry.FOTTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class MixinLivingEntity
extends Entity
implements PartyFish {
    @Unique
    private boolean dancing;
    @Unique
    @Nullable
    private BlockPos jukeboxPos;

    MixinLivingEntity() {
        super(null, null);
    }

    @Inject(method={"dropFromLootTable(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/damagesource/DamageSource;Z)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/storage/loot/LootTable;getRandomItems(Lnet/minecraft/world/level/storage/loot/LootParams;JLjava/util/function/Consumer;)V")})
    private void fishofthieves$dropFishBone(ServerLevel serverLevel, DamageSource damageSource, boolean hitByPlayer, CallbackInfo info, @Local LootParams.Builder builder) {
        if (this.getType().is(FOTTags.EntityTypes.FISH_BONE_DROP)) {
            LootTable fishBoneDropLootTable = serverLevel.getServer().reloadableRegistries().getLootTable(FOTLootTables.Entities.FISH_BONE_DROP);
            fishBoneDropLootTable.getRandomItems(builder.create(LootContextParamSets.ENTITY), itemStack -> this.spawnAtLocation(serverLevel, (ItemStack)itemStack));
        }
    }

    @Inject(method={"aiStep()V"}, at={@At(value="HEAD")})
    private void fishofthieves$checkNearbyJukebox(CallbackInfo info) {
        if (this.jukeboxPos == null || !this.jukeboxPos.closerToCenterThan((Position)this.position(), (double)((GameEvent)GameEvent.JUKEBOX_PLAY.value()).notificationRadius()) || !this.level().getBlockState(this.jukeboxPos).is(Blocks.JUKEBOX)) {
            this.dancing = false;
            this.jukeboxPos = null;
        }
    }

    @Inject(method={"setRecordPlayingNearby(Lnet/minecraft/core/BlockPos;Z)V"}, at={@At(value="HEAD")})
    private void fishofthieves$setRecordPlayingNearby(BlockPos jukeboxPos, boolean jukeboxPlaying, CallbackInfo info) {
        this.dancing = jukeboxPlaying;
        this.jukeboxPos = jukeboxPos;
    }

    @Override
    public boolean fishofthieves$isDancing() {
        return this.dancing;
    }
}

