/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.mixin.level;

import com.llamalad7.mixinextras.sugar.Local;
import com.stevekung.fishofthieves.entity.animal.Stormfish;
import com.stevekung.fishofthieves.registry.FOTEntities;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLevel.class})
public abstract class MixinServerLevel
extends Level {
    MixinServerLevel() {
        super(null, null, null, null, false, false, 0L, 0);
    }

    @Inject(method={"tickThunder(Lnet/minecraft/world/level/chunk/LevelChunk;)V"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;isThundering()Z")})
    private void fishofthieves$specialThunderTick(LevelChunk chunk, CallbackInfo info, @Local(index=4, ordinal=0) int x, @Local(index=5, ordinal=1) int z) {
        Optional<BlockPos> blockPos;
        if (this.isThundering() && this.random.nextInt(5000) == 0 && (blockPos = this.findNearestStormfish(this.getBlockRandomPos(x, 0, z, 15))).isPresent()) {
            LightningBolt lightningBolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)this, EntitySpawnReason.EVENT);
            lightningBolt.snapTo(Vec3.atBottomCenterOf((Vec3i)((Vec3i)blockPos.get())));
            this.addFreshEntity((Entity)lightningBolt);
        }
    }

    @Unique
    private boolean isRainingAtFromBelowWater(BlockPos blockPos) {
        if (!this.isRaining() || !this.canSeeSkyFromBelowWater(blockPos) || this.getBrightness(LightLayer.SKY, blockPos) < 12) {
            return false;
        }
        Biome biome = (Biome)this.getBiome(blockPos).value();
        return biome.getPrecipitationAt(blockPos, this.getSeaLevel()) == Biome.Precipitation.RAIN;
    }

    @Unique
    private Optional<BlockPos> findNearestStormfish(BlockPos blockPos) {
        BlockPos blockPos2 = this.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, blockPos);
        AABB aabb = AABB.encapsulatingFullBlocks((BlockPos)blockPos2, (BlockPos)new BlockPos(blockPos2.getX(), this.getMaxY(), blockPos2.getZ())).inflate(8.0);
        return Optional.of(this.getEntities((EntityTypeTest)FOTEntities.STORMFISH, aabb, living -> living != null && living.isAlive() && this.isRainingAtFromBelowWater(blockPos2))).filter(stormfish -> !stormfish.isEmpty()).map(stormfish -> ((Stormfish)stormfish.get(this.random.nextInt(stormfish.size()))).blockPosition());
    }
}

