/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.registry.variant;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.condition.AllConditionCheck;
import com.stevekung.fishofthieves.entity.condition.AnyConditionCheck;
import com.stevekung.fishofthieves.entity.condition.NightCheck;
import com.stevekung.fishofthieves.entity.condition.ProbabilityCheck;
import com.stevekung.fishofthieves.entity.condition.RandomChanceCheck;
import com.stevekung.fishofthieves.entity.condition.SeeSkyCheck;
import com.stevekung.fishofthieves.entity.variant.AbstractFishVariant;
import com.stevekung.fishofthieves.entity.variant.AncientscaleVariant;
import com.stevekung.fishofthieves.registry.FOTRegistries;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.StructureTags;
import net.minecraft.world.entity.variant.MoonBrightnessCheck;
import net.minecraft.world.entity.variant.SpawnCondition;
import net.minecraft.world.entity.variant.StructureCheck;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;

public class AncientscaleVariants {
    public static final ResourceKey<AncientscaleVariant> ALMOND = AncientscaleVariants.createKey("almond");
    public static final ResourceKey<AncientscaleVariant> SAPPHIRE = AncientscaleVariants.createKey("sapphire");
    public static final ResourceKey<AncientscaleVariant> SMOKE = AncientscaleVariants.createKey("smoke");
    public static final ResourceKey<AncientscaleVariant> BONE = AncientscaleVariants.createKey("bone");
    public static final ResourceKey<AncientscaleVariant> STARSHINE = AncientscaleVariants.createKey("starshine");

    public static void bootstrap(BootstrapContext<AncientscaleVariant> context) {
        AbstractFishVariant.RegisterContext<AncientscaleVariant> registerContext = AbstractFishVariant.RegisterContext.create("ancientscale", AncientscaleVariant::new);
        HolderGetter structureLookup = context.lookup(Registries.STRUCTURE);
        registerContext.register(context, ALMOND, "almond", 0);
        registerContext.register(context, SAPPHIRE, "sapphire", 1);
        registerContext.register(context, SMOKE, "smoke", 2);
        registerContext.register(context, BONE, "bone", 3, registerContext.select(AllConditionCheck.allOf(AnyConditionCheck.anyOf(new SpawnCondition[]{new StructureCheck((HolderSet)HolderSet.direct((Holder[])new Holder[]{structureLookup.getOrThrow(BuiltinStructures.STRONGHOLD)})), new StructureCheck((HolderSet)structureLookup.getOrThrow(StructureTags.MINESHAFT))}).build(), RandomChanceCheck.chance(10)), 1), registerContext.select(ProbabilityCheck.defaultRareProbablity(), 0));
        registerContext.register(context, STARSHINE, "starshine", 4, true, AllConditionCheck.allOf(new SpawnCondition[]{NightCheck.night(), SeeSkyCheck.seeSky(), new MoonBrightnessCheck(MinMaxBounds.Doubles.atMost((double)0.25))}));
    }

    public static void bootstrapSimple(BootstrapContext<AncientscaleVariant> context) {
        AbstractFishVariant.RegisterContext<AncientscaleVariant> registerContext = AbstractFishVariant.RegisterContext.create("ancientscale", AncientscaleVariant::new);
        registerContext.register(context, ALMOND, "almond", 0);
        registerContext.register(context, SAPPHIRE, "sapphire", 1);
        registerContext.register(context, SMOKE, "smoke", 2);
        registerContext.register(context, BONE, "bone", 3, ProbabilityCheck.defaultRareProbablity());
        registerContext.register(context, STARSHINE, "starshine", 4, true, AllConditionCheck.allOf(NightCheck.night(), SeeSkyCheck.seeSky()));
    }

    private static ResourceKey<AncientscaleVariant> createKey(String name) {
        return ResourceKey.create(FOTRegistries.ANCIENTSCALE_VARIANT, (ResourceLocation)FishOfThieves.id(name));
    }
}

