/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.registry.variant;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.condition.AllConditionCheck;
import com.stevekung.fishofthieves.entity.condition.BlockRangeCheck;
import com.stevekung.fishofthieves.entity.condition.NightCheck;
import com.stevekung.fishofthieves.entity.condition.ProbabilityCheck;
import com.stevekung.fishofthieves.entity.condition.SeeSkyCheck;
import com.stevekung.fishofthieves.entity.variant.AbstractFishVariant;
import com.stevekung.fishofthieves.entity.variant.DevilfishVariant;
import com.stevekung.fishofthieves.registry.FOTRegistries;
import com.stevekung.fishofthieves.registry.FOTTags;
import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;

public class DevilfishVariants {
    public static final ResourceKey<DevilfishVariant> ASHEN = DevilfishVariants.createKey("ashen");
    public static final ResourceKey<DevilfishVariant> SEASHELL = DevilfishVariants.createKey("seashell");
    public static final ResourceKey<DevilfishVariant> LAVA = DevilfishVariants.createKey("lava");
    public static final ResourceKey<DevilfishVariant> FORSAKEN = DevilfishVariants.createKey("forsaken");
    public static final ResourceKey<DevilfishVariant> FIRELIGHT = DevilfishVariants.createKey("firelight");

    public static void bootstrap(BootstrapContext<DevilfishVariant> context) {
        AbstractFishVariant.RegisterContext<DevilfishVariant> registerContext = AbstractFishVariant.RegisterContext.create("devilfish", DevilfishVariant::new);
        registerContext.register(context, ASHEN, "ashen", 0);
        registerContext.register(context, SEASHELL, "seashell", 1);
        registerContext.register(context, LAVA, "lava", 2, BlockRangeCheck.blocksInRange(Optional.empty(), Optional.of(context.lookup(Registries.FLUID).getOrThrow(FluidTags.LAVA)), 4));
        registerContext.register(context, FORSAKEN, "forsaken", 3, ProbabilityCheck.defaultRareProbablity());
        registerContext.register(context, FIRELIGHT, "firelight", 4, true, AllConditionCheck.allOf(NightCheck.night(), BlockRangeCheck.blocksInRange(Optional.of(context.lookup(Registries.BLOCK).getOrThrow(FOTTags.Blocks.FIRELIGHT_DEVILFISH_WARM_BLOCKS)), Optional.of(context.lookup(Registries.FLUID).getOrThrow(FluidTags.LAVA)), 4)));
    }

    public static void bootstrapSimple(BootstrapContext<DevilfishVariant> context) {
        AbstractFishVariant.RegisterContext<DevilfishVariant> registerContext = AbstractFishVariant.RegisterContext.create("devilfish", DevilfishVariant::new);
        registerContext.register(context, ASHEN, "ashen", 0);
        registerContext.register(context, SEASHELL, "seashell", 1);
        registerContext.register(context, LAVA, "lava", 2);
        registerContext.register(context, FORSAKEN, "forsaken", 3, ProbabilityCheck.defaultRareProbablity());
        registerContext.register(context, FIRELIGHT, "firelight", 4, true, AllConditionCheck.allOf(NightCheck.night(), SeeSkyCheck.seeSky()));
    }

    private static ResourceKey<DevilfishVariant> createKey(String name) {
        return ResourceKey.create(FOTRegistries.DEVILFISH_VARIANT, (ResourceLocation)FishOfThieves.id(name));
    }
}

