/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.registry.variant;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.condition.AllConditionCheck;
import com.stevekung.fishofthieves.entity.condition.AnyConditionCheck;
import com.stevekung.fishofthieves.entity.condition.HasBeehiveCheck;
import com.stevekung.fishofthieves.entity.condition.HeightCheck;
import com.stevekung.fishofthieves.entity.condition.MinimumBlockRangeCheck;
import com.stevekung.fishofthieves.entity.condition.NightCheck;
import com.stevekung.fishofthieves.entity.condition.ProbabilityCheck;
import com.stevekung.fishofthieves.entity.condition.SeeSkyCheck;
import com.stevekung.fishofthieves.entity.variant.AbstractFishVariant;
import com.stevekung.fishofthieves.entity.variant.IslehopperVariant;
import com.stevekung.fishofthieves.registry.FOTBiomes;
import com.stevekung.fishofthieves.registry.FOTRegistries;
import com.stevekung.fishofthieves.registry.FOTTags;
import java.util.Optional;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.entity.variant.BiomeCheck;
import net.minecraft.world.entity.variant.SpawnCondition;
import net.minecraft.world.level.biome.Biomes;

public class IslehopperVariants {
    public static final ResourceKey<IslehopperVariant> STONE = IslehopperVariants.createKey("stone");
    public static final ResourceKey<IslehopperVariant> MOSS = IslehopperVariants.createKey("moss");
    public static final ResourceKey<IslehopperVariant> HONEY = IslehopperVariants.createKey("honey");
    public static final ResourceKey<IslehopperVariant> RAVEN = IslehopperVariants.createKey("raven");
    public static final ResourceKey<IslehopperVariant> AMETHYST = IslehopperVariants.createKey("amethyst");

    public static void bootstrap(BootstrapContext<IslehopperVariant> context) {
        AbstractFishVariant.RegisterContext<IslehopperVariant> registerContext = AbstractFishVariant.RegisterContext.create("islehopper", IslehopperVariant::new);
        HolderGetter biomeLookup = context.lookup(Registries.BIOME);
        registerContext.register(context, STONE, "stone", 0);
        registerContext.register(context, MOSS, "moss", 1, AnyConditionCheck.anyOf(new SpawnCondition[]{new BiomeCheck((HolderSet)biomeLookup.getOrThrow(BiomeTags.IS_JUNGLE)), new BiomeCheck((HolderSet)biomeLookup.getOrThrow(BiomeTags.HAS_CLOSER_WATER_FOG)), new BiomeCheck((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomeLookup.getOrThrow(Biomes.LUSH_CAVES), biomeLookup.getOrThrow(FOTBiomes.TROPICAL_ISLAND)}))}).build());
        registerContext.register(context, HONEY, "honey", 2, HasBeehiveCheck.beehive(5, 9));
        registerContext.register(context, RAVEN, "raven", 3, AllConditionCheck.allOf(ProbabilityCheck.defaultRareProbablity(), HeightCheck.height(MinMaxBounds.Ints.atMost((int)0))));
        registerContext.register(context, AMETHYST, "amethyst", 4, true, MinimumBlockRangeCheck.minimumBlocksInRange(Optional.of(context.lookup(Registries.BLOCK).getOrThrow(FOTTags.Blocks.AMETHYST_ISLEHOPPER_SPAWNABLE_ON)), Optional.empty(), 4, 16));
    }

    public static void bootstrapSimple(BootstrapContext<IslehopperVariant> context) {
        AbstractFishVariant.RegisterContext<IslehopperVariant> registerContext = AbstractFishVariant.RegisterContext.create("islehopper", IslehopperVariant::new);
        registerContext.register(context, STONE, "stone", 0);
        registerContext.register(context, MOSS, "moss", 1);
        registerContext.register(context, HONEY, "honey", 2);
        registerContext.register(context, RAVEN, "raven", 3, ProbabilityCheck.defaultRareProbablity());
        registerContext.register(context, AMETHYST, "amethyst", 4, true, AllConditionCheck.allOf(NightCheck.night(), SeeSkyCheck.seeSky()));
    }

    private static ResourceKey<IslehopperVariant> createKey(String name) {
        return ResourceKey.create(FOTRegistries.ISLEHOPPER_VARIANT, (ResourceLocation)FishOfThieves.id(name));
    }
}

