/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.registry.variant;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.condition.AllConditionCheck;
import com.stevekung.fishofthieves.entity.condition.DayCheck;
import com.stevekung.fishofthieves.entity.condition.NightCheck;
import com.stevekung.fishofthieves.entity.condition.ProbabilityCheck;
import com.stevekung.fishofthieves.entity.condition.SeeSkyCheck;
import com.stevekung.fishofthieves.entity.variant.AbstractFishVariant;
import com.stevekung.fishofthieves.entity.variant.SplashtailVariant;
import com.stevekung.fishofthieves.registry.FOTRegistries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class SplashtailVariants {
    public static final ResourceKey<SplashtailVariant> RUBY = SplashtailVariants.createKey("ruby");
    public static final ResourceKey<SplashtailVariant> SUNNY = SplashtailVariants.createKey("sunny");
    public static final ResourceKey<SplashtailVariant> INDIGO = SplashtailVariants.createKey("indigo");
    public static final ResourceKey<SplashtailVariant> UMBER = SplashtailVariants.createKey("umber");
    public static final ResourceKey<SplashtailVariant> SEAFOAM = SplashtailVariants.createKey("seafoam");

    public static void bootstrap(BootstrapContext<SplashtailVariant> context) {
        AbstractFishVariant.RegisterContext<SplashtailVariant> registerContext = AbstractFishVariant.RegisterContext.create("splashtail", SplashtailVariant::new);
        registerContext.register(context, RUBY, "ruby", 0);
        registerContext.register(context, SUNNY, "sunny", 1, AllConditionCheck.allOf(DayCheck.day(), SeeSkyCheck.seeSky()));
        registerContext.register(context, INDIGO, "indigo", 2);
        registerContext.register(context, UMBER, "umber", 3, ProbabilityCheck.defaultRareProbablity());
        registerContext.register(context, SEAFOAM, "seafoam", 4, true, AllConditionCheck.allOf(NightCheck.night(), SeeSkyCheck.seeSky()));
    }

    public static void bootstrapSimple(BootstrapContext<SplashtailVariant> context) {
        AbstractFishVariant.RegisterContext<SplashtailVariant> registerContext = AbstractFishVariant.RegisterContext.create("splashtail", SplashtailVariant::new);
        registerContext.register(context, RUBY, "ruby", 0);
        registerContext.register(context, SUNNY, "sunny", 1);
        registerContext.register(context, INDIGO, "indigo", 2);
        registerContext.register(context, UMBER, "umber", 3, ProbabilityCheck.defaultRareProbablity());
        registerContext.register(context, SEAFOAM, "seafoam", 4, true, AllConditionCheck.allOf(NightCheck.night(), SeeSkyCheck.seeSky()));
    }

    private static ResourceKey<SplashtailVariant> createKey(String name) {
        return ResourceKey.create(FOTRegistries.SPLASHTAIL_VARIANT, (ResourceLocation)FishOfThieves.id(name));
    }
}

