/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.registry.variant;

import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.entity.condition.AllConditionCheck;
import com.stevekung.fishofthieves.entity.condition.ContinentalnessCheck;
import com.stevekung.fishofthieves.entity.condition.NightCheck;
import com.stevekung.fishofthieves.entity.condition.ProbabilityCheck;
import com.stevekung.fishofthieves.entity.condition.SeeSkyCheck;
import com.stevekung.fishofthieves.entity.condition.SkyBrightnessCheck;
import com.stevekung.fishofthieves.entity.condition.SkyDarkenCheck;
import com.stevekung.fishofthieves.entity.variant.AbstractFishVariant;
import com.stevekung.fishofthieves.entity.variant.StormfishVariant;
import com.stevekung.fishofthieves.registry.FOTBiomes;
import com.stevekung.fishofthieves.registry.FOTRegistries;
import com.stevekung.fishofthieves.utils.Continentalness;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.variant.BiomeCheck;
import net.minecraft.world.entity.variant.SpawnCondition;
import net.minecraft.world.level.biome.Biomes;

public class StormfishVariants {
    public static final ResourceKey<StormfishVariant> ANCIENT = StormfishVariants.createKey("ancient");
    public static final ResourceKey<StormfishVariant> SHORES = StormfishVariants.createKey("shores");
    public static final ResourceKey<StormfishVariant> WILD = StormfishVariants.createKey("wild");
    public static final ResourceKey<StormfishVariant> SHADOW = StormfishVariants.createKey("shadow");
    public static final ResourceKey<StormfishVariant> TWILIGHT = StormfishVariants.createKey("twilight");

    public static void bootstrap(BootstrapContext<StormfishVariant> context) {
        AbstractFishVariant.RegisterContext<StormfishVariant> registerContext = AbstractFishVariant.RegisterContext.create("stormfish", StormfishVariant::new);
        HolderGetter biomeLookup = context.lookup(Registries.BIOME);
        registerContext.register(context, ANCIENT, "ancient", 0);
        registerContext.register(context, SHORES, "shores", 1, ContinentalnessCheck.continentalness(Continentalness.COAST));
        registerContext.register(context, WILD, "wild", 2, (SpawnCondition)new BiomeCheck((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomeLookup.getOrThrow(Biomes.SPARSE_JUNGLE), biomeLookup.getOrThrow(FOTBiomes.TROPICAL_ISLAND)})));
        registerContext.register(context, SHADOW, "shadow", 3, registerContext.select(AllConditionCheck.allOf(ProbabilityCheck.defaultRareProbablity(), SkyBrightnessCheck.skyBrightness(MinMaxBounds.Ints.atMost((int)4))), 1), registerContext.select(ProbabilityCheck.defaultRareProbablity(), 0));
        registerContext.register(context, TWILIGHT, "twilight", 4, true, SkyDarkenCheck.skyDarken(MinMaxBounds.Ints.between((int)9, (int)16)));
    }

    public static void bootstrapSimple(BootstrapContext<StormfishVariant> context) {
        AbstractFishVariant.RegisterContext<StormfishVariant> registerContext = AbstractFishVariant.RegisterContext.create("stormfish", StormfishVariant::new);
        registerContext.register(context, ANCIENT, "ancient", 0);
        registerContext.register(context, SHORES, "shores", 1);
        registerContext.register(context, WILD, "wild", 2);
        registerContext.register(context, SHADOW, "shadow", 3, ProbabilityCheck.defaultRareProbablity());
        registerContext.register(context, TWILIGHT, "twilight", 4, true, AllConditionCheck.allOf(NightCheck.night(), SeeSkyCheck.seeSky()));
    }

    private static ResourceKey<StormfishVariant> createKey(String name) {
        return ResourceKey.create(FOTRegistries.STORMFISH_VARIANT, (ResourceLocation)FishOfThieves.id(name));
    }
}

