/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.utils;

import com.mojang.serialization.Codec;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.StringRepresentable;

public enum PeakTypes implements StringRepresentable
{
    LOW("Low"),
    MID("Mid"),
    HIGH("High"),
    PEAK("Peak"),
    VALLEY("Valley");

    private static final PeakTypes[] VALUES;
    public static final Codec<PeakTypes> CODEC;
    private static final Map<String, PeakTypes> BY_NAME;
    private final String name;

    private PeakTypes(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getSerializedName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public static PeakTypes byName(String name) {
        return BY_NAME.get(name);
    }

    static {
        VALUES = PeakTypes.values();
        CODEC = StringRepresentable.fromEnum(() -> VALUES);
        BY_NAME = Stream.of(VALUES).collect(Collectors.toMap(PeakTypes::getName, Function.identity()));
    }
}

