/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.utils;

import com.stevekung.fishofthieves.utils.Continentalness;
import com.stevekung.fishofthieves.utils.PeakTypes;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import net.minecraft.world.level.levelgen.structure.Structure;

public class TerrainUtils {
    private static final OverworldBiomeBuilder OVERWORLD_BUILDER = new OverworldBiomeBuilder();

    public static Continentalness getContinentalness(ServerLevel level, BlockPos blockPos) {
        float continentalness = Climate.unquantizeCoord((long)TerrainUtils.getTargetPoint(level, blockPos).continentalness());
        return Continentalness.byName(OVERWORLD_BUILDER.getDebugStringForContinentalness((double)continentalness));
    }

    public static PeakTypes getPeakTypes(ServerLevel level, BlockPos blockPos) {
        float weirdness = Climate.unquantizeCoord((long)TerrainUtils.getTargetPoint(level, blockPos).weirdness());
        float peakTypes = NoiseRouterData.peaksAndValleys((float)weirdness);
        return PeakTypes.byName(OverworldBiomeBuilder.getDebugStringForPeaksAndValleys((double)peakTypes));
    }

    public static boolean isInFeature(ServerLevel level, BlockPos blockPos, TagKey<Structure> tagKey) {
        return level.structureManager().getStructureWithPieceAt(blockPos, tagKey).isValid();
    }

    public static Optional<BlockPos> lookForBlock(BlockPos blockPos, int range, Predicate<BlockPos> posFilter) {
        return BlockPos.findClosestMatch((BlockPos)blockPos, (int)range, (int)range, posFilter);
    }

    public static boolean lookForBlocksWithSize(BlockPos blockPos, int range, int maxSize, Predicate<BlockPos> posFilter) {
        int size = 0;
        for (BlockPos blockPos2 : BlockPos.withinManhattan((BlockPos)blockPos, (int)range, (int)range, (int)range)) {
            if (!posFilter.test(blockPos2) || ++size < maxSize) continue;
            return true;
        }
        return false;
    }

    private static Climate.TargetPoint getTargetPoint(ServerLevel level, BlockPos blockPos) {
        int chunkX = QuartPos.fromBlock((int)blockPos.getX());
        int chunkY = QuartPos.fromBlock((int)blockPos.getY());
        int chunkZ = QuartPos.fromBlock((int)blockPos.getZ());
        return Objects.requireNonNullElseGet(level.getChunkSource().randomState().sampler(), Climate::empty).sample(chunkX, chunkY, chunkZ);
    }
}

