/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.stevekung.fishofthieves.FishOfThieves;
import com.stevekung.fishofthieves.client.FOTModelLayers;
import com.stevekung.fishofthieves.client.model.AncientscaleModel;
import com.stevekung.fishofthieves.client.model.BattlegillModel;
import com.stevekung.fishofthieves.client.model.DevilfishModel;
import com.stevekung.fishofthieves.client.model.HeadphoneModel;
import com.stevekung.fishofthieves.client.model.IslehopperModel;
import com.stevekung.fishofthieves.client.model.PlentifinModel;
import com.stevekung.fishofthieves.client.model.PondieModel;
import com.stevekung.fishofthieves.client.model.SplashtailModel;
import com.stevekung.fishofthieves.client.model.StormfishModel;
import com.stevekung.fishofthieves.client.model.WildsplashModel;
import com.stevekung.fishofthieves.client.model.WreckerModel;
import com.stevekung.fishofthieves.client.renderer.blockentity.FishPlaqueRenderer;
import com.stevekung.fishofthieves.client.renderer.entity.AncientscaleRenderer;
import com.stevekung.fishofthieves.client.renderer.entity.BattlegillRenderer;
import com.stevekung.fishofthieves.client.renderer.entity.DevilfishRenderer;
import com.stevekung.fishofthieves.client.renderer.entity.IslehopperRenderer;
import com.stevekung.fishofthieves.client.renderer.entity.PlentifinRenderer;
import com.stevekung.fishofthieves.client.renderer.entity.PondieRenderer;
import com.stevekung.fishofthieves.client.renderer.entity.SplashtailRenderer;
import com.stevekung.fishofthieves.client.renderer.entity.StormfishRenderer;
import com.stevekung.fishofthieves.client.renderer.entity.WildsplashRenderer;
import com.stevekung.fishofthieves.client.renderer.entity.WreckerRenderer;
import com.stevekung.fishofthieves.config.FishOfThievesConfig;
import com.stevekung.fishofthieves.entity.animal.Ancientscale;
import com.stevekung.fishofthieves.entity.animal.Battlegill;
import com.stevekung.fishofthieves.entity.animal.Devilfish;
import com.stevekung.fishofthieves.entity.animal.Islehopper;
import com.stevekung.fishofthieves.entity.animal.Plentifin;
import com.stevekung.fishofthieves.entity.animal.Pondie;
import com.stevekung.fishofthieves.entity.animal.Splashtail;
import com.stevekung.fishofthieves.entity.animal.Stormfish;
import com.stevekung.fishofthieves.entity.animal.Wildsplash;
import com.stevekung.fishofthieves.entity.animal.Wrecker;
import com.stevekung.fishofthieves.mixin.client.MixinCreativeModeTabs;
import com.stevekung.fishofthieves.registry.FOTBlockEntityTypes;
import com.stevekung.fishofthieves.registry.FOTEntities;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.item.CreativeModeTab;

public class FishOfThievesClient {
    private static final Map<String, Object> PREVIOUS_CONFIG_VALUES = Maps.newHashMap();

    public static void init() {
        FishOfThievesClient.onConfigLoad();
        AutoConfig.getConfigHolder(FishOfThievesConfig.class).registerSaveListener((holder, config) -> FishOfThievesClient.onConfigChanged(config));
    }

    public static List<ModelLayerEntry> getModelLayers() {
        return List.of(new ModelLayerEntry(SplashtailModel.LAYER, SplashtailModel::createBodyLayer), new ModelLayerEntry(PondieModel.LAYER, PondieModel::createBodyLayer), new ModelLayerEntry(IslehopperModel.LAYER, IslehopperModel::createBodyLayer), new ModelLayerEntry(AncientscaleModel.LAYER, AncientscaleModel::createBodyLayer), new ModelLayerEntry(PlentifinModel.LAYER, PlentifinModel::createBodyLayer), new ModelLayerEntry(WildsplashModel.LAYER, WildsplashModel::createBodyLayer), new ModelLayerEntry(DevilfishModel.LAYER, DevilfishModel::createBodyLayer), new ModelLayerEntry(BattlegillModel.LAYER, BattlegillModel::createBodyLayer), new ModelLayerEntry(WreckerModel.LAYER, WreckerModel::createBodyLayer), new ModelLayerEntry(StormfishModel.LAYER, StormfishModel::createBodyLayer), new ModelLayerEntry(FOTModelLayers.COCONUT_BOAT, BoatModel::createBoatModel), new ModelLayerEntry(FOTModelLayers.COCONUT_CHEST_BOAT, BoatModel::createChestBoatModel), new ModelLayerEntry(HeadphoneModel.LAYER, HeadphoneModel::createBodyLayer));
    }

    public static List<EntityRendererEntry<Entity>> getEntityRenderers() {
        return ((ArrayList)Util.make((Object)Lists.newArrayList(), list -> {
            list.add(new EntityRendererEntry<Splashtail>(FOTEntities.SPLASHTAIL, SplashtailRenderer::new));
            list.add(new EntityRendererEntry<Pondie>(FOTEntities.PONDIE, PondieRenderer::new));
            list.add(new EntityRendererEntry<Islehopper>(FOTEntities.ISLEHOPPER, IslehopperRenderer::new));
            list.add(new EntityRendererEntry<Ancientscale>(FOTEntities.ANCIENTSCALE, AncientscaleRenderer::new));
            list.add(new EntityRendererEntry<Plentifin>(FOTEntities.PLENTIFIN, PlentifinRenderer::new));
            list.add(new EntityRendererEntry<Wildsplash>(FOTEntities.WILDSPLASH, WildsplashRenderer::new));
            list.add(new EntityRendererEntry<Devilfish>(FOTEntities.DEVILFISH, DevilfishRenderer::new));
            list.add(new EntityRendererEntry<Battlegill>(FOTEntities.BATTLEGILL, BattlegillRenderer::new));
            list.add(new EntityRendererEntry<Wrecker>(FOTEntities.WRECKER, WreckerRenderer::new));
            list.add(new EntityRendererEntry<Stormfish>(FOTEntities.STORMFISH, StormfishRenderer::new));
            list.add(new EntityRendererEntry<Boat>(FOTEntities.COCONUT_BOAT, context -> new BoatRenderer(context, FOTModelLayers.COCONUT_BOAT)));
            list.add(new EntityRendererEntry<ChestBoat>(FOTEntities.COCONUT_CHEST_BOAT, context -> new BoatRenderer(context, FOTModelLayers.COCONUT_CHEST_BOAT)));
        })).stream().map(entry -> entry).toList();
    }

    public static void registerBlockEntityRenderers() {
        BlockEntityRenderers.register(FOTBlockEntityTypes.FISH_PLAQUE, FishPlaqueRenderer::new);
        BlockEntityRenderers.register(FOTBlockEntityTypes.SIGN, SignRenderer::new);
        BlockEntityRenderers.register(FOTBlockEntityTypes.HANGING_SIGN, HangingSignRenderer::new);
    }

    public static List<HeadphoneEntry<LivingEntity, LivingEntityRenderState>> getHeadphone() {
        return ((ArrayList)Util.make((Object)Lists.newArrayList(), list -> {
            list.add(new HeadphoneEntry(EntityType.COD, HeadphoneModel.Scaleable.COD));
            list.add(new HeadphoneEntry(EntityType.SALMON, HeadphoneModel.Scaleable.SALMON));
            list.add(new HeadphoneEntry(EntityType.PUFFERFISH, HeadphoneModel.Scaleable.PUFFERFISH));
            list.add(new HeadphoneEntry(EntityType.TROPICAL_FISH, HeadphoneModel.Scaleable.TROPICAL_FISH));
            list.add(new HeadphoneEntry(EntityType.TADPOLE, HeadphoneModel.Scaleable.TADPOLE));
        })).stream().map(entry -> entry).toList();
    }

    private static void onConfigLoad() {
        PREVIOUS_CONFIG_VALUES.put("displayAllFishVariantInCreativeTab", FishOfThieves.CONFIG.general.displayAllFishVariantInCreativeTab);
        PREVIOUS_CONFIG_VALUES.put("displayTrophySpawnEggInCreativeTab", FishOfThieves.CONFIG.general.displayTrophySpawnEggInCreativeTab);
    }

    private static InteractionResult onConfigChanged(FishOfThievesConfig config) {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player != null && (FishOfThievesClient.isConfigChanged(config, "displayAllFishVariantInCreativeTab") || FishOfThievesClient.isConfigChanged(config, "displayTrophySpawnEggInCreativeTab"))) {
            MixinCreativeModeTabs.setCACHED_PARAMETERS(new CreativeModeTab.ItemDisplayParameters(player.connection.enabledFeatures(), player.canUseGameMasterBlocks(), (HolderLookup.Provider)player.registryAccess()));
            MixinCreativeModeTabs.invokeBuildAllTabContents(MixinCreativeModeTabs.getCACHED_PARAMETERS());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private static boolean isConfigChanged(FishOfThievesConfig config, String configName) {
        Boolean currentValue;
        Object previousValue = PREVIOUS_CONFIG_VALUES.get(configName);
        switch (configName) {
            case "displayAllFishVariantInCreativeTab": {
                Boolean bl = config.general.displayAllFishVariantInCreativeTab;
                break;
            }
            case "displayTrophySpawnEggInCreativeTab": {
                Boolean bl = config.general.displayTrophySpawnEggInCreativeTab;
                break;
            }
            default: {
                FishOfThieves.LOGGER.error("Unknown configuration parameter: {}", (Object)configName);
                Boolean bl = currentValue = Boolean.valueOf(false);
            }
        }
        if (previousValue == null || previousValue != currentValue) {
            PREVIOUS_CONFIG_VALUES.put(configName, currentValue);
            return true;
        }
        return false;
    }

    public record ModelLayerEntry(ModelLayerLocation layerLocation, Supplier<LayerDefinition> supplier) {
    }

    public record HeadphoneEntry<E extends LivingEntity, S extends LivingEntityRenderState>(EntityType<? extends E> entityType, HeadphoneModel.Scaleable<S> scaleable) {
    }

    public record EntityRendererEntry<E extends Entity>(EntityType<? extends E> entityType, EntityRendererProvider<E> factory) {
    }
}

