/*
 * Decompiled with CFR 0.152.
 */
package com.stevekung.fishofthieves.block;

import com.mojang.serialization.MapCodec;
import com.stevekung.fishofthieves.registry.FOTBlocks;
import com.stevekung.fishofthieves.registry.FOTTags;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BananaShootsPlantBlock
extends HorizontalDirectionalBlock {
    public static final MapCodec<BananaShootsPlantBlock> CODEC = BananaShootsPlantBlock.simpleCodec(BananaShootsPlantBlock::new);
    private static final Map<Direction, VoxelShape> SHAPES = Map.of(Direction.NORTH, Block.box((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)13.0, (double)8.0), Direction.WEST, Block.box((double)0.0, (double)0.0, (double)3.0, (double)8.0, (double)13.0, (double)13.0), Direction.SOUTH, Block.box((double)3.0, (double)0.0, (double)8.0, (double)13.0, (double)13.0, (double)16.0), Direction.EAST, Block.box((double)8.0, (double)0.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0));

    public BananaShootsPlantBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public float getMaxHorizontalOffset() {
        return 0.0f;
    }

    public float getMaxVerticalOffset() {
        return 0.3f;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockState blockState = level.getBlockState(pos.below());
        return blockState.is(FOTTags.Blocks.BANANA_SHOOTS_PLACEABLE_ON);
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean includeData) {
        return new ItemStack((ItemLike)FOTBlocks.BANANA_SHOOTS);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.getValue((Property)FACING));
    }

    public BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess scheduledTickAccess, BlockPos currentPos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource randomSource) {
        return !state.canSurvive(level, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, level, scheduledTickAccess, currentPos, direction, neighborPos, neighborState, randomSource);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

